/*
 * A controller object for a DSPRecorder.
 */

#import <dpsclient/dpsclient.h>
#import <sound/soundstruct.h>
#import <soundkit/Sound.h>
#import "DACPlayer.h"

#define	SND_RATE_HIGH_TAG	0
#define	SND_RATE_LOW_TAG	1

#define	MIN_FREQ	20.0
#define MAX_FREQ	4000.0
#define MIN_AMP		0.0
#define MAX_AMP		1.0

@interface Transport:Object
{
  DPSTimedEntry statusTE;	/* Timed entry to update status window */
  DACPlayer *dacPlayer;		/* The DACPlayer object */
  double frequency;		/* frequency in Hertz */
  double amplitude;		/* amplitude from 0-1.0 */
  short sampleAmplitude;	/* amplitude scaled from -32K to 32K */
  short sampleValue;		/* current value of sample output */
  short sampleDelta;		/* change in sampleValue at each tick */
  id aSound;			/* sound object */
  id aSound2;			/* sound object */
  short *soundpointer2;		/* pointer to soundobject */
  short *soundpointer;		/* pointer to soundobject */
  short *savesoundpointer;	/* save soundpointer */
  short *savesoundpointer2;	/* save soundpointer */
  int nsoundbytes;		/* number of bytes in sound object */
  int nbuffers;			/* number of sound buffers */
}

+ new;

/* user methods */
- stop:sender;
- pause:sender;
- tplay:(id)mySound with:(id)mySound bufcount:(int)nbuf;
- updateStatus;
- wait;


/* Internal methods */
- updateStatus;

/* Delegate methods */
- willPlay :player;
- didPlay :player;
- playData :player :(char *)region :(int)nbytes;

@end
