        sr      =       22050
        kr      =       4410
        ksmps   =       5
        nchnls  =       1

;=========================================================================;
;									  ;
;		      Risset's Waveshaping Clarinet                       ;
;									  ;
;=========================================================================;
;		 Coded by Thomas DiMeo - Brooklyn College		  ;
;=========================================================================;
; from the Csound Anthology of Instruments, Orchestras, and Scores (1990) ;
;		compiled and edited by Dr. Richard Boulanger		  ;
;=========================================================================;

instr 3
	i1 = cpspch(p4)
	i2 = .64
  if p3 >.75 igoto start
	i2 = p3 - .085
  start:
	a1  linen   255,.085,p3,i2
	a1  oscili  a1,i1,1
	a1  tablei  a1+256,2
	out a1*p5
endin

;=========================================================================;
;									  ;
;		Another of Risset's Waveshaping Instruments               ;
;									  ;
;=========================================================================;
;		 Coded by Thomas DiMeo - Brooklyn College		  ;
;=========================================================================;
; from the Csound Anthology of Instruments, Orchestras, and Scores (1990) ;
;		compiled and edited by Dr. Richard Boulanger		  ;
;=========================================================================;

instr 4
   i1=1/p3
   i2=cpspch(p4)

   a1 oscili p5,i1,2		 ;scaling factor code
   a2 oscili a1,i2,1

   a3 linseg 1,.04,0,p3-.04,0
   a4 oscili a3,i2*.7071,1	 ; audio code

; inline code for transfer function:
; f(x)=1+.841x-.707x**2-.595x**3+.5x**4+.42x**5-.354x**6-.279x**7+.25x**8+.21x**9

   a5=a4*a4
   a6=a5*a4
   a7=a5*a5
   a8=a7*a4
   a9=a6*a6
   a10=a9*a4
   a11=a10*a4
   a12=a11*a4

   a13=1+.841*a4-.707*a5-.595*a6+.5*a7+.42*a8-.354*a9-.297*a10+.25*a11+.21*a12

   a14=a13*a2
   out a14
endin

;=========================================================================;
;									  ;
;               Waveshape Drum Instrument from Dodge p. 145               ;
;               (Same as above, but using lookup table w/Gen3             ;
;               and envlpx for amp envelope.)                             ;
;									  ;
;=========================================================================;
;                Coded by Russell Pinkston - Univ. of Texas               ;
;=========================================================================;

        instr   5
ihertz  =       cpspch(p4)
kpitch  envlpx  p5,.02,.22,.2,3,1,.01
knoise  linseg  255,.04,0,1,0
apitch  oscili  kpitch,ihertz,1
aindex  oscili  knoise,ihertz*.7071,1
anoise  tablei  256+aindex,4            ;use raw index with 512-loc table
asignal =       apitch*anoise           ;ring modulate
        out     asignal
        endin

;=========================================================================;
;									  ;
;               Beauchamp Brass Instrument from Dodge p. 148              ;
;									  ;
;=========================================================================;
;                Coded by Russell Pinkston - Univ. of Texas               ;
;=========================================================================;

        instr   6
ihertz  =       cpspch(p4)
kindex  linseg  0,.025,255,p3-.075,255,.05,0,1,0
aindex  oscili  kindex,ihertz,1
asignal tablei  256+aindex,4            ;use raw index with 512-loc table
asignal atone   asignal,900            ;high pass filter
        out     asignal*p5
        endin

;=========================================================================;
;									  ;
;               Crude Clipping/Distortion Waveshaping Instrument          ;
;									  ;
;=========================================================================;
;                Coded by Russell Pinkston - Univ. of Texas               ;
;=========================================================================;

        instr   7
ihertz  =       cpspch(p4)
kvib    oscili  .05,6,1
kfm     expseg  1,p3,.1
kindex  linseg  1,p3,0
kindex  tablei  kindex,3,1
kindex  =       kindex*p6                  ;p6 >= .5 means major clipping
aindex  foscili kindex,ihertz+ihertz*kvib,1,1,20*kfm,1
asignal tablei  .5+aindex,4,1          ;use normalized index
        out     asignal*p5
        endin

;=========================================================================;
;									  ;
;               Better Clipping/Distortion Waveshaping Instrument         ;
;									  ;
;=========================================================================;
;                Coded by Russell Pinkston - Univ. of Texas               ;
;=========================================================================;

        instr   8
ihertz  =       cpspch(p4)
kgate   linen   1,.01,p3,.1             ;overall amp envelope
kvib    oscili  .05,6,1
kfm     expseg  1,p3,.1
kctrl   linseg  1,p3,0
kctrl   tablei  kctrl,3,1
kctrl   =       kctrl*p6                ;p6 >= 255 means major clipping
aindex  foscili kctrl,ihertz+ihertz*kvib,1,1,20*kfm,1
asignal tablei  256+aindex,4            ;use raw index w/512-loc table
knormal tablei  kctrl,5                 ;amplitude normalization function
        out     asignal*knormal*p5*kgate
        endin

;=========================================================================;
;									  ;
;               General Purpose Waveshaping Instrument                    ;
;									  ;
;=========================================================================;
;                Coded by Russell Pinkston - Univ. of Texas               ;
;=========================================================================;

        instr   9

ihertz  =       cpspch(p4)
kgate   linen   1,.01,p3,.1             ;overall amp envelope
kctrl   linseg  0,p3/2,.999,p3/2,0
aindex  oscili  kctrl/2,ihertz,1
asignal tablei  .5+aindex,4,1
knormal tablei  kctrl,5,1               ;amplitude normalization function
        out     asignal*knormal*p5*kgate
        endin

