.TH hetro EMS
.SH NAME
hetro \- hetrodyne filter analysis for Csound adsyn module
.SH SYNOPSIS
.B hetro 
[flags] [fundamental] [filename]
.SH DESCRIPTION
.PP
.I hetro
takes as input a file containing amplitude samples of some
sound over time (it is assumed that the samples are evenly spaced
in time) and decomposes that sound into a set of harmonically
related sine waves with time varying amplitude and phase.
.br
.sp
.RS .5i
NOTE:  it is necessary to provide hetro with an estimate
of the fundamental frequency of the sound being
analyzed.  
.RE
.sp
.PP
Below are listed the flags and their meanings.
All flags must be followed by a value with no intervening
space between the flag and its value.  
.sp
.nf
.RS .25i
-b:  Beginning time of the sound to be analyzed.(in seconds)

-e:  Specifies the "adsyn.m" file to write the output.

-f:  Allows user to use a 3rd order Butterworth LPF to
     filter the analysis terms instead of the averaging
     (comb) filter used by default. (cutoff freq. in cps)

-h:  The number of harmonics to be analyzed and contained
     in the output sound. (integer less than 50)

-i:  The duration time of the sound analyzed by hetro.
     (in seconds) Default of 0 means entire length of smpl file

-m:  The maximum output magnitude of the output sound.

-n:  The number of output points in the envelopes.

-s:  The sampling rate of the input file. (in cps)


Default values for the flags are as follows:
     -b0 -e1 -f1 -i0 -h50 -m1000 -n256 -s20000
.RE
.fi		
.SH EXAMPLE
.PP
The following is an example call to hetro:
.br
.ce
hetro -i2.5 -e4 -h10 -m3000 -b.5 -s25000 440 infile
.sp
This will analyze 2.5 seconds worth of samples in infile,
which was created with a sample rate of 25kHz, beginning 
0.5 seconds into the sample file.  Hetro will analyze the first
10 harmonics of the sound, and output 256 points for each of
the time-varying amplitude and frequency pairs into the file
adsyn.4 with a maximum amplitude of 3000.  The LPF is disabled.
.SH DIAGNOSTICS
.PP
Due to the large amount of calculation required to do the
analysis, hetro runs fairly slowly.  Think carefully about how 
many harmonics and how long a sample file is necessary to analyze.
.SH FILES
adysn.\fIm\fR	hetrodyne analysis data file
.SH "SEE ALSO"
adsyn(EMS),
Csound(EMS),
.I "The Csound Reference Manual"
.SH AUTHOR
.PP
Tom Sullivan, 
a.k.a. sullivan@ems.media.mit.edu.
