/* This program is used to copy the pitches of a pitch analysis, into
 * the fourth slots of the frames of an lpc analysis.  It assumes only
 * that the lpc frames will have n poles and 4 data values at the beginning
 * of each frame, the fourth of which is the pitch of the frame.
 * In the pitch analysis the frames consists of 2 values, pitch and rms
 * amplitude, so a plot can be done from there or from the concatenated
 * lpc/pitch data set. */
#include <stdio.h>
#define FLOAT 4

main()
{
        int anal,pitches,j;
	int npoles,lpcframe,pchframe,pchlast,nbpch;
	long nskiplpc,nskippch,nblpc;
	char  input[32],output[32];
	float pch[2],*val;
	printf(" Enter name of lpc analysis file\t");
	scanf("%s",output);
	if((anal = open(output,1)) < 0) {
		fprintf(stderr," Can't open lpc analysis file");
		exit(1);
		}
	printf(" Enter name of pitch analysis file\t");
	scanf("%s",input);
	if((pitches = open(input,0)) < 0) {
		fprintf(stderr," Can't open pitch analysis file");
		exit(1);
		};
	printf(" Enter number of poles in lpc analysis\t");
	scanf("%d",&npoles);
	printf(" Enter starting frame in lpc analysis\t");
	scanf("%d",&lpcframe);
	printf(" Enter starting frame in pitch analysis\t");
	scanf("%d",&pchframe);
	printf(" Enter final frame in pitch analysis\t");
	scanf("%d",&pchlast);
	nblpc = (npoles+4)*FLOAT - FLOAT;/*to beginning of next pchloc*/
	nbpch = 2*FLOAT;   /* pch analysis saves 2 float words */
	nskiplpc = (long)(lpcframe-1)*(long)(nblpc+FLOAT) + (3*FLOAT);  
				 /* pch is 4th data value in fr*/
	if((lseek(anal,nskiplpc,0)) < 0)  {
		printf("Bad lseek on analysis file\n");
		exit(1);
		}
	nskippch = (long)((pchframe-1) * nbpch);
	if((lseek(pitches,nskippch,0)) < 0) {
		printf("Bad lseek on pitch analysis file\n");
		exit(1);
		}
	for(j=pchframe;j<=pchlast;j++) {
		if((read(pitches,(char *)pch,nbpch)) != nbpch) {
			printf("Bad read on pitch analysis file\n");
			exit(1);
			}
		*val = pch[0];
		if((write(anal,(char *)val,FLOAT)) != FLOAT) {
			printf("Bad write on lpc analysis file\n");
			exit(1);
			}
		lseek(anal,nblpc,1);
	}
}
