#include <stdio.h>

#define PFRAMSIZ  2                    /* words per frame (pitch&rms */
#define PCHSIZE   16                   /* record size in float words */
#define BPPFRAME  FLOAT*PFRAMSIZ       /* bytes per frame */
#define BPPREC    BPPFRAME*PCHSIZE     /* bytes per record */
#define FPPREC    PCHSIZE/PFRAMSIZ     /* frames per record */
float PFPS;                 	       /* pitch frames per second */

#define FLOAT 4
float sampspf;
int pitches;

main()
{
        int anal,j;
	int npoles,lpcframe,lpclast,pchframe,pchlast,nbpch;
	long nskiplpc,nskippch,nblpc;
	char  input[32],output[32];
	float pch[2],val,sr,time,getfreq();
	printf(" Enter name of lpc analysis file\t");
	scanf("%s",output);
	if((anal = open(output,1)) < 0) {
		fprintf(stderr," Can't open lpc analysis file");
		exit(1);
		}
	printf(" Enter name of pitch analysis file and pitch frames per sec\t");
	scanf("%s %f",input,&PFPS);
	if((pitches = open(input,0)) < 0) {
		fprintf(stderr," Can't open pitch analysis file");
		exit(1);
		};
	printf(" Enter number of poles in lpc analysis\t");
	scanf("%d",&npoles);
	printf(" Enter starting and ending frame in lpc analysis\t");
	scanf("%d %d",&lpcframe,&lpclast);
	printf(" Enter sr and samples per lpcframe\t");
	scanf("%f %f",&sr,&sampspf);
	nblpc = (npoles+4)*FLOAT - FLOAT;/*to beginning of next pchloc*/
	nskiplpc = (long)(lpcframe)*(long)(nblpc+FLOAT) + (3*FLOAT);  
				 /* pch is 4th data value in fr*/
	if((lseek(anal,nskiplpc,0)) < 0)  {
		printf("Bad lseek on analysis file\n");
		exit(1);
		}
	for(j=lpcframe;j<=lpclast;j++) {
/*
		if((read(pitches,(char *)pch,nbpch)) != nbpch) {
			printf("Bad read on pitch analysis file\n");
			exit(1);
			}
*/
		time = (float)j*sampspf/sr;
		val = getfreq(time);
		if((write(anal,(char *)&val,FLOAT)) != FLOAT) {
			printf("Bad write on lpc analysis file\n");
			exit(1);
			}
		lseek(anal,nblpc,1);
	}
}

float getfreq(time) 
float time;
{


	int i,j,frame;
	float fframe,fraction,cps,error;
	static int oldframe = 0;
	static int endframe = 0;
	static float parray[PCHSIZE*2];

	fframe = time * PFPS;
	frame = (int)fframe;
	fraction = fframe - (float)frame;
	if(!((frame >= oldframe) && (frame < endframe))) {
		if(lseek(pitches,((long)frame*(long)BPPFRAME),0) < 0) {
			printf("Bad lseek on pitch file\n");
			exit(1);
		} 
		if(read(pitches,(char *)parray,BPPREC) != BPPREC) {
			printf("Bad read on pitch file\n");
		}
		oldframe = frame;
		endframe = oldframe + FPPREC - 1;
	}
	cps = (1.-fraction) * *(parray+(frame-oldframe)*PFRAMSIZ) +
	    fraction  * *((parray+(frame-oldframe)*PFRAMSIZ)+2);
	error = (1.-fraction) * *(parray+(frame-oldframe)*PFRAMSIZ+1) +
	    fraction  * *((parray+(frame-oldframe)*PFRAMSIZ)+3);
	return(cps);
}

