/* cc -o pedit -O pedit.c -lm */
/* this is a a more complex program to edit the output of
	Lansky's pitch tracker.
	A first line consisting of the input and output files is taken, then
	multiple lines of the standard input are taken
	in the following format:
	
	CHAR 	FR1	FR2	VAL1	[VAL2]

where:
	CHAR is one of 'r', specifying a 'replacement' function, or
			't' specifying a transposition function.
			'a' specifying an addition function.
	FR1 and FR2 specify inclusively which frames in the pitch
			file are to be altered.
	VAL1 is the value to replace or transpose the data by
	
	if the optinal VAL2 is present, the replacement or transposition
			with, respectively, a (natural) exponential or 
			linear interpolation between the values, where
			the full value of VAL1 is in effect at FR1
			and the full value of VAL2 is in effect at FR2
	lines beginning with a space are ignored (useful for comments)

	with exponential interpolations, end values of 0.0 are ignored.
*/

#include <math.h>
#include <stdio.h>
#define FLOAT sizeof(float)
int nbframe = 2*FLOAT; 
char  input[32]; /* orig file containing pitches & amps */
char  output[32]; /* new file containing pitches & amps */
int pfd, npfd;	/* pitch file des. and newpitch file des. */
#define ARRSIZ 200
float vals[ARRSIZ]; /* */

main()
{
        int n;
	float v1, v2;
	long frame1,frame2;
	char  answer[10], buf[80];

	printf("inputfilename outputfilename\n");
		/* skip all the beginning junk. */
	while( (gets(buf) == NULL)||(!strcmp(buf, ""))||(buf[0] == ' ') )
		;
	if(sscanf(buf,"%s %s", input, output) != 2) {
	   printf("first line must be input and output files.\n");
	   exit(1);
	}
	if((pfd = open(input,0)) < 0) {
	  fprintf(stderr,"Can't open pitch file '%s'\n",input);
	  exit(1);
	}
	if((npfd = creat(output,0666)) < 0) {
	  fprintf(stderr,"Can't create new pitch file '%s'\n",output);
	  exit(1);
	}
	close(npfd);
	if((npfd = open(output,2)) < 0) {
	  fprintf(stderr,"Can't open new pitch file '%s'\n",output);
	  exit(1);
	}

	/* just make it a copy of the old first */
	while((n = read(pfd, (char *)vals, ARRSIZ)) > 0)
		write(npfd, (char *)vals, n);
	if(lseek(npfd, 0L, 0) < 0) { /* rewind it */
		fprintf(stderr, "bad rewind on the new file.\n");
	}

	while( (gets(buf) != NULL) ) {
		if( !strcmp(buf, "") || (buf[0] == ' ') )
			continue;
		n = sscanf(buf, "%s %D %D %f %f", answer,
			&frame1, &frame2, &v1, &v2);
		/* maybe take this out */
		if(n < 4) {
			fprintf(stderr,
				"bad command line '%s'\n", buf);
			continue;
		}
		if(frame2 < frame1) {
			fprintf(stderr,
			   "pedit error: bad line: '%s'...f2 less than f1.\n",
			   buf);
			continue;
		}
		switch(n) {
			case 4:
				if(drawit(answer, frame1, frame2, v1) < 0) {
					fprintf(stderr, "error on drawit\n");
				}
				break;
			case 5:
				if(interp(answer, frame1, frame2,v1,v2) < 0) {
					fprintf(stderr, "erro on interp\n");
				}
				break;
			default:
				fprintf(stderr,"bad command line '%s'\n", buf);
		} 	/* end of switch */
	} /* end of while gets */
exit(0); /* the end of main for now */
}

drawit(ans, fr1, fr2, v1)
char *ans; long fr1, fr2; float v1;
{
	int n;

	windout(npfd, (fr1-1));	/* counting starts at 1 */
	switch(ans[0]) {
		case 't':
			for(n = fr1; n <= fr2; n++) {
				getfr(npfd, vals, nbframe);
				vals[0] *= v1;
					/*(putfr rewinds the file a fr first)*/
				putfr(npfd, vals, nbframe); 
			}
			break;
		case 'r':
			for(n = fr1; n <= fr2; n++) {
				getfr(npfd, vals, nbframe);
				vals[0] = v1;
					/*(putfr rewinds the file a fr first)*/
				putfr(npfd, vals, nbframe); 
			}
			break;
		case 'a':
			for(n = fr1; n <= fr2; n++) {
				getfr(npfd, vals, nbframe);
				vals[0] += v1;
					/*(putfr rewinds the file a fr first)*/
				putfr(npfd, vals, nbframe); 
			}
			break;
		default:
			fprintf(stderr,"bad transform command\n");
			return(-1);
	}
} /* end of drawit() */

interp(ans, fr1, fr2, v1, v2)
char *ans; long fr1, fr2; float v1, v2;
{
	int  n;
	float incre, pval;

	windout(npfd, (fr1-1));	/* 'cause counting starts at 1 */
	switch(ans[0]) {
		case 't':
			incre = (float) ( (v2 - v1) / (fr2 - fr1) );
			pval = v1;
			for(n = fr1; n <= fr2; n++) {
				getfr(npfd, vals, nbframe);
				vals[0] *= pval;
				pval += incre;
					/*(putfr rewinds the file a fr first)*/
				putfr(npfd, vals, nbframe); 
			}
			break;
		case 'r':
			if( v1 == 0 ) v1 = 0.00001;
			if( v2 == 0 ) v2 = 0.00001;
			/* incre = (log(v2/v1))/ (fr2 - fr1); not as clear*/
			incre = (float) ( (log(v2) - log(v1)) / (fr2 - fr1) );
			pval = (float) log(v1);
			for(n = fr1; n <= fr2; n++) {
				if(getfr(npfd, vals, nbframe) < 0) {
					fprintf(stderr,"bad getfr\n");
					return(-1);
				}
				vals[0] = (float) exp( pval );
				pval += incre;
					/*(putfr rewinds the file a fr first)*/
				putfr(npfd, vals, nbframe); 
			}
			break;
		case 'a':
			if( v1 == 0 ) v1 = 0.00001;
			if( v2 == 0 ) v2 = 0.00001;
			/* incre = (log(v2/v1))/ (fr2 - fr1); not as clear*/
			incre = (float) ( (log(v2) - log(v1)) / (fr2 - fr1) );
			pval = (float) log(v1);
			for(n = fr1; n <= fr2; n++) {
				if(getfr(npfd, vals, nbframe) < 0) {
					fprintf(stderr,"bad getfr\n");
					return(-1);
				}
				vals[0] += (float) exp( pval );
				pval += incre;
					/*(putfr rewinds the file a fr first)*/
				putfr(npfd, vals, nbframe); 
			}
			break;
		default:
			fprintf(stderr,"bad transform command\n");
			return(-1);
	}
} /* end of interp() */

windout(fd, nfram)
int fd; long nfram;
{
	if(lseek(fd, (long) (nfram * nbframe), 0) < 0) {
		fprintf(stderr,"couldn't windout\n");
		return(-1);
	}
}

getfr(fd, farr, nbytes)  /* get the next frame */
int fd; float *farr; int nbytes;
{
	int n;
	if((n =  read(fd,(char *)farr,nbytes)) != nbytes) {
		fprintf(stderr,"bad read, less than one frame\n");
		fprintf(stderr,"read %d bytes, wanted %d\n",n,nbytes);
		return(-1);
	}
}

putfr(fd, farr, nbytes)    /* opposite of getfr(). rewinds it first */
int fd; float *farr; int nbytes;
{

	if(lseek(fd, (long)-nbytes, 1) < 0) { /* rewind a frame */
		fprintf(stderr, "lseek err\n");
		return(-1);
	}
	if(write(fd, (char *)farr, nbytes) != nbytes) {
		printf("bad write to the new pitch file\n");
		return(-1);
	}
}

