#include "sysdep.h"		/*							DISPLAY.C	*/

#define HOR	80
#define	VER	20
#define	YOFF	10
#define	YOFF4	40

static	char	point[VER+1][HOR];

display(fstart,npts,msg,dwid)	  /* stub for display of n-point float array */
 float *fstart;			  /*	call with &array, npts, &msg, &dwid  */
 int   npts;
 char  *msg;
 int   *dwid;
{
extern	int	dsploption;

	switch(dsploption) {			/* use main.c switch to find */
	case 0:	break;
	case 1:	dsplascii(fstart,npts,msg);	     /* which display option */
		break;
#ifdef XWINDOWS
	case 2:
	case 3:	dsplXgraph(fstart,npts,msg,dwid);     /* this with window id */
		break;
#endif
	case 4: dsplRgraph(fstart,npts,msg);
		break;
	default: printf("unknown display option -d%1d\n",dsploption);
		exit(0);
	}
}

dsplascii(fstart,npts,msg)		/* display an n-pnt float array	*/
 float *fstart;				/*   using simple ascii chars	*/
 int   npts;				/* call with &array, npts, &msg */
 char  *msg;
{
	 float	max, min, absmax;
register float	*fp, *fplim = fstart + npts;
register char	*s, *t;
register int	n;

	for (s=point[0], n=(VER+1)*HOR; n; n-- )	/* blank out all pts */
		*s++ = ' ';
	for (fp=fstart, max=0, min=0; fp<fplim; fp++ ) {
		if (*fp > max)				/* find max/min vals */
			max = *fp;
		else if (*fp < min)
			min = *fp;
	}
	if (max >= -min)				/*   & absolute max */
		absmax = max;
	else absmax = -min;	
	printf("%s\t%d points, scalemax %5.3f\n", msg, npts, absmax);
	if (absmax) {					/* for non-triv fn: */
		register float	scalefactor;
		register int	vscale4, vpos, vmin, incr;
		scalefactor = YOFF4 / absmax;		/*   get normalizing */
		incr = (npts-1)/HOR + 1;		/*   & sampling facs */
		for (s=point[YOFF], n=0, fp=fstart; fp<fplim; fp+=incr ) {
			*(s+n) = '_';			/* now write x-axis  */
			vscale4 = *fp * scalefactor + YOFF4;
			vpos = vscale4 >>2;
			t = &point[vpos][n++];		/* and sampled pnts  */
			switch(vscale4 - (vpos <<2)) {
			case 0:	*t = '_';		/*  (with 1/4 line  */
				break;			/*	resolution) */
			case 1: *t = '.';
				break;
			case 2:	*t = '-';
				break;
			case 3:	*t = '\'';
				break;
			}				/* into dsplay array */
		}
		vmin = (int)(min*YOFF/absmax) + YOFF-1;	/* for all lines     */
		if (vmin < 0)	vmin = 0;
		for (vpos=VER; vpos>=vmin; vpos--) {	/*   to min value:   */
			s = point[vpos];
			t = s + HOR - 1;
			while (*t == ' ' && t >= s)	/*  find last char & */
				t--;
			while (s <= t)
				putchar(*s++);		/*  putline to there */
			putchar('\n');
		}
	}
}
