#include "cs.h"			/*					MAIN.C	*/
#include "soundio.h"

#ifdef XWINDOWS
#include <X/Xlib.h>
#endif

int	odebug = 0;		/* orch control switches	*/
int	initonly = 0;		/*   and default values		*/
int	sfwrite = 1;
int	floatout = 0, sampsize = 2, bufsmps = BUFSIZE/2;
int	ftdisplay = 1;
int	dsploption = 1;
int	msglevel = 7;
char	*term, *getenv();
char	*outfile;
extern	char errmsg[];

main(argc,argv)
 int argc;
 char **argv;
{
	register char c, *s;

	if (!(--argc))
		die("insufficient orch arguments");
	do {
		s = *++argv;
		if (*s++ != '-')		/* read all orch flags:  */
			break;
		while ((c = *s++) != NULL)
			switch(c) {
			case 'i': initonly = 1;		/* i-only implies */
			case 'n': sfwrite = 0;		/* nosound	  */
				  break;
			case 'f': floatout = 1;		/* sndfile floats */
				  sampsize = 4;
				  bufsmps = BUFSIZE/4;
				  break;
			case 'v': odebug = 1;		/* verbose otran  */
				  break;
			case 't': ftdisplay = 0;	/* no ftable dsplays */
				  break;
			case 'd': sscanf(s,"%d",&dsploption);
				  while (*++s);
				  break;
			case 'm': sscanf(s,"%d",&msglevel);
				  while (*++s);
				  break;
			case 'N': outfile = s;		/* soundfile name */
				  while (*++s);
				  break;
			default:  fprintf(stderr,"illegal char %c\n",c);
				  die("unknown orch flag");
			}
	} while (--argc);

	if ((term = getenv("TERM")) == NULL)
		die("environment variable TERM undefined");
#ifdef XWINDOWS						/* if Xgraph output, */
	if (dsploption == 2 || dsploption == 3) {
		XEvent	event;
		if (strcmp(term,"vs") && strcmp(term,"xterm")
				      && strcmp(term,"xterms")) {
			sprintf(errmsg,"TERM=%s cannot support option d%d",
					term, dsploption);
			die(errmsg);
		}
		XOpenDisplay(NULL);			/* init for Xwindows */
		musmon(--s);				/* perform score     */
		fprintf(stderr,"to exit, place cursor in background & press any key\n");
		XSelectInput(RootWindow, KeyPressed);
		XWindowEvent(RootWindow, KeyPressed, &event);
		while (event.type != KeyPressed);	/* & hold last image */
	}
	else musmon(--s);				/* else just perform */
#else
	musmon(--s);
#endif 
	return(0);
}
