#include "cs.h"		/*							UGENS4.C	*/
#include "ugens4.h"
#include <sys/types.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <math.h>

extern	float	esr, ekr, tpidsr, mtpdsr;
extern	int	ksmps;
extern	char	errmsg[];

porset(p)
 register PORT *p;
{
	p->c2 = pow(.5, (float) 1 / *p->ihtim / ekr);
	p->c1 = 1. - p->c2;
	if (*p->isig >= 0)
		p->yt1 = *p->isig;
}

port(p)
 register PORT *p;
{
	*p->kr = p->yt1 = p->c1 * *p->ksig + p->c2 * p->yt1;
}

tonset(p)
 register TONE *p;
{
	p->c1 = p->prvhp = 0;
	p->c2 = 1;
	if (!(*p->istor))
		p->yt1 = 0;
}

tone(p)
 register TONE *p;
{
register float	*ar, *asig;
register int	nsmps = ksmps;

	if (*p->khp != p->prvhp) {
		float b;
		p->prvhp = *p->khp;
		b = 2. - cos(*p->khp * tpidsr);
		p->c2 = b - sqrt(b * b - 1.);
		p->c1 = 1. - p->c2;
	}
	ar = p->ar;
	asig = p->asig;
	do  *ar++ = p->yt1 = p->c1 * *asig++ + p->c2 * p->yt1;
	while (--nsmps);
}

atone(p)
 register TONE *p;
{
register float	*ar, *asig;
register int	nsmps = ksmps;

	if (*p->khp != p->prvhp) {
		float b;
		p->prvhp = *p->khp;
		b = 2. - cos(*p->khp * tpidsr);
		p->c2 = b - sqrt(b * b - 1.);
		p->c1 = 1. - p->c2;
	}
	ar = p->ar;
	asig = p->asig;
	do {
		*ar++ = p->yt1 = p->c2 * (p->yt1 + *asig);
		p->yt1 -= *asig++;		/* yt1 contains yt1-xt1 */
	}
	while (--nsmps);
}

rsnset(p)
 register RESON *p;
{
 register int scale;
        p->scale = scale = *p->iscl;
	if (scale && scale != 1 && scale != 2) {
	        sprintf(errmsg,"illegal reson iscl value, %f",*p->iscl);
		initerror(errmsg);
	}
	p->prvcf = p->prvbw = -100.;
	if (!(*p->istor))
		p->yt1 = p->yt2 = 0;
}

reson(p)
 register RESON *p;
{
register int	flag = 0, nsmps = ksmps;
register float	*ar, *asig;
register float	c3p1, c3t4, omc3, c2sqr;

	if (*p->kcf != p->prvcf) {
		p->prvcf = *p->kcf;
		p->cosf = cos(*p->kcf * tpidsr);
		flag = 1;
	}
	if (*p->kbw != p->prvbw) {
		p->prvbw = *p->kbw;
		p->c3 = exp(*p->kbw * mtpdsr);
		flag = 1;
	}
	if (flag) {
		c3p1 = p->c3 + 1.;
		c3t4 = p->c3 * 4.;
		omc3 = 1 - p->c3;
		p->c2 = c3t4 * p->cosf / c3p1;		/* -B, so + below */
		c2sqr = p->c2 * p->c2;
		if (p->scale == 1)
			p->c1 = omc3 * sqrt(1. - c2sqr / c3t4);
		else if (p->scale == 2)
			p->c1 = sqrt((c3p1*c3p1 - c2sqr) * omc3 / c3p1);
		else p->c1 = 1.;
	}
	asig = p->asig;
	ar = p->ar;
	do {
		*ar = p->c1 * *asig++ + p->c2 * p->yt1 - p->c3 * p->yt2;
		p->yt2 = p->yt1;
		p->yt1 = *ar++;
	}
	while (--nsmps);
}

areson(p)
 register RESON *p;
{
register int	flag = 0, nsmps = ksmps;
register float	*ar, *asig;
register float	c3p1, c3t4, omc3, c2sqr;

	if (*p->kcf != p->prvcf) {
		p->prvcf = *p->kcf;
		p->cosf = cos(*p->kcf * tpidsr);
		flag = 1;
	}
	if (*p->kbw != p->prvbw) {
		p->prvbw = *p->kbw;
		p->c3 = exp(*p->kbw * mtpdsr);
		flag = 1;
	}
	if (flag) {
		c3p1 = p->c3 + 1.;
		c3t4 = p->c3 * 4.;
		omc3 = 1 - p->c3;
		p->c2 = c3t4 * p->cosf / c3p1;
		c2sqr = p->c2 * p->c2;
		if (p->scale == 1)			/* i.e. 1 - A(reson) */
			p->c1 = 1. - omc3 * sqrt(1. - c2sqr / c3t4);
		else if (p->scale == 2)
			p->c1 = 1. - sqrt((c3p1*c3p1 - c2sqr) * omc3 / c3p1);
		else p->c1 = 0.;
	}
	asig = p->asig;
	ar = p->ar;
	do {
		*ar = p->c1 * *asig + p->c2 * p->yt1 - p->c3 * p->yt2;
		p->yt2 = p->yt1;
		p->yt1 = *ar++ - *asig++;	/* yt1 contains yt1-xt1 */
	}
	while (--nsmps);
}

static	LPREAD	*lprdadr;
static	char	lpfilname[10];

lprdset(p)
 register LPREAD *p;
{
register int	n;
register LPHEADER *lph;
	struct	stat statbuf;
	int	nvalues;

	lprdadr = p;				     /* adr opds for lpreson */
	if (p->lpfd > 0)
		return;
	sprintf(lpfilname,"lp.%d",(int)*p->ifilno);	/* find file,open it */
	if ((p->lpfd = open(lpfilname,O_RDONLY)) < 0) {
		sprintf(errmsg,"lpread cannot open %s",lpfilname);
		goto lperr;
	}
	fdrecord(&p->lpfd);				/*    & log fd store */
	if ((n = read(p->lpfd,p->filbuf,LPBUFSIZ)) <= 0) /* now rd 1st blk */
		dies("read error on %s",lpfilname);
	lph = (LPHEADER *) p->filbuf;
	if (lph->lpmagic == LP_MAGIC) {			/* Header on file:   */
		p->headlongs = lph->headersize >> 2;	/* headsize in longs */
		if (*p->inpoles || *p->ifrmrate)
			warning("lpheader overriding inputs");
		if (lph->srate != esr)
			warning("lpfile srate != orch sr");
		p->npoles = lph->npoles;		/* note npoles, etc. */
		p->nvals = lph->nvals;
		p->framrat16 = lph->framrate * 65536.;	/* scaled framno cvt */
	}
	else if (BYTREVL(lph->lpmagic) == LP_MAGIC) {	/* Header reversed:  */
		sprintf(errmsg,"file %s bytes are in wrong order",lpfilname);
		goto lperr;
	}
	else {						/* No Header on file:*/
		p->headlongs = 0;
		p->npoles = *p->inpoles;		/*  data from inargs */
		p->nvals = p->npoles + 4;
		p->framrat16 = *p->ifrmrate * 65536.;
		if (!p->npoles || !p->framrat16) {
			sprintf(errmsg,"insufficient args and no file header");
			goto lperr;
		}
	}
	if (p->npoles > MAXPOLES) {
		sprintf(errmsg,"npoles > MAXPOLES");
		goto lperr;
	}
	p->tailvals = p->nvals << 1;			/* nvals prvbuf tail */
	p->tailpos =  LPBUFVALS - p->tailvals;		/* beg of vals tosav */
	p->bufno = 0;					/* this buf is #0    */
	p->prvtailset = 0;				/* no prv tail yet   */
	p->endfilpos = n >> 2;
	fstat(p->lpfd,&statbuf);
	nvalues = (statbuf.st_size >> 2) - p->headlongs;
	p->lastfram16 = (((nvalues - p->nvals) / p->nvals) << 16) - 1;
	p->lastmsg = 0;
	return;

lperr:	initerror(errmsg);
}

lpread(p)
 register LPREAD *p;
{
register float	*bp, *np, *cp;
register int	nn, framphase, valno, bufno, bufpos, bufdiff;
	float	fract;
extern int odebug;

	if ((framphase = *p->ktimpt * p->framrat16) < 0) { /* for kfram reqd */
		perferror("lpread timpnt < 0");
		return;
	}
	if (framphase > p->lastfram16) {		/* not past last one */
		framphase = p->lastfram16;
		if (!p->lastmsg) {
			p->lastmsg = 1;
			warning("lpread ktimpnt truncated to last frame");
		}
	}
	valno = (framphase >> 16) * p->nvals + p->headlongs;
	bufno = valno >> BUFNOSHIFT;			/* find which bufno  */
	bufpos = valno & BUFPOSMASK;			/*    & loc of frame */
	if (bufdiff = bufno - p->bufno) {		/* bufno different:  */
		if (bufdiff == -1			/*   for prv1,tail,& */
		 && bufpos >= p->tailpos && p->prvtailset) { /* already done */
			bufpos -= LPBUFVALS;		/*      we're allset */
			goto interp;
		}
		if (bufdiff != 1			/*     if not nxtbuf */
		  && (nn = lseek(p->lpfd,bufno*LPBUFSIZ,0)) <0) /* seek frst */
			die("lp seek error");
		nn = read(p->lpfd,p->filbuf,LPBUFSIZ);	/* else just readnxt */
		p->endfilpos = nn >> 2;
		p->bufno = bufno;
		p->prvtailset = 0;
	}
	if (bufpos >= p->tailpos) {		  /* if final frames thisbuf */
		bp = p->filbuf + p->tailpos;
		np = p->filbuf - p->tailvals;
		nn = p->tailvals;
		do *np++ = *bp++;			/* cpy tail this buf */
		while (--nn);
		nn = read(p->lpfd,p->filbuf,LPBUFSIZ);	     /* readnxt */
		p->endfilpos = nn >> 2;	
		p->bufno++;
		p->prvtailset = 1;
		bufpos -= LPBUFVALS;			/* pnt into prv tail */
	}
interp:	if (bufpos >= p->endfilpos - p->nvals) {
		bp = np = p->filbuf + p->endfilpos - p->nvals;
		fract = 0;
	}
	else  {					    /* interp betw adj frams */
		bp = p->filbuf + bufpos;
		np = bp + p->nvals;
		fract = (framphase & 0xffff) / 65536.;
	}
	*p->krmr = *bp + (*np - *bp) * fract;	bp++;	np++; /* for 4 rslts */
	*p->krmo = *bp + (*np - *bp) * fract;	bp++;	np++;
	*p->kerr = *bp + (*np - *bp) * fract;	bp++;	np++;
	*p->kcps = *bp + (*np - *bp) * fract;	bp++;	np++;
if (odebug) printf("phase:%x bufpos:%d fract:%6.2f rmsr:%6.2f rmso:%6.2f kerr:%6.2f kcps:%6.2f\n",
		framphase,bufpos,fract,*p->krmr,*p->krmo,*p->kerr,*p->kcps);
	cp = p->kcoefs;
	nn = p->npoles;						/* & n coefs */
	do { *cp = *bp + (*np - *bp) * fract;
if (odebug) printf(" %6.2f",*cp);
	bp++;	np++;	cp++;
	} while (--nn);
if (odebug) putchar('\n');
}

lprsnset(p)
 register LPRESON *p;
{
register LPREAD *q;

	p->lpread = q = lprdadr;		    /* get adr lpread struct */
	p->circjp = p->circbuf;
	p->jp2lim = p->circbuf + (q->npoles << 1);  /* npoles det circbuflim */
}

lpreson(p)
 register LPRESON *p;
{
register LPREAD *q = p->lpread;
register int	nn, nsmps = ksmps;
register float	*coefp, *pastp, *jp, *jp2, *rslt = p->ar, *asig = p->asig;
	float	x;

	jp = p->circjp;
	jp2 = jp + q->npoles;
	do {
		x = *asig++;
		coefp = q->kcoefs;		/* using lpread interp coefs */
		pastp = jp;
		nn = q->npoles;
		do  x += *coefp++ * *pastp++;
		while (--nn);
		*jp++ = *jp2++ = x;
		*rslt++ = x;
		if (jp2 >= p->jp2lim) {
			jp2 = jp;
			jp = p->circbuf;
		}
	} while (--nsmps);
	p->circjp = jp;
}

lpfrsnset(p)
 register LPFRESON *p;
{
 	p->lpread = lprdadr;
	p->prvratio = 1;
	p->d = 0;
	p->prvout = 0;
}

lpfreson(p)
 register LPFRESON *p;
{
register LPREAD	*q = p->lpread;
register int	nn, nsmps = ksmps;
register float	*coefp, *pastp, *pastp1, *rslt = p->ar, *asig = p->asig;
	float	x, temp1, temp2, ampscale, cq;

	if (*p->kfrqratio != p->prvratio) {		/* for new freqratio */
		if (*p->kfrqratio <= 0.) {
			sprintf(errmsg,"illegal frqratio, %5.2",*p->kfrqratio);
			perferror(errmsg);
			return;
		}					/*	calculate d  */
		p->d = (*p->kfrqratio - 1.) / (*p->kfrqratio + 1.);
		p->prvratio = *p->kfrqratio;
	}
	if (p->d != 0.) {				/* for non-zero d,   */
		coefp = q->kcoefs;
		nn = q->npoles - 1;
		do {
			temp1 = p->d * *coefp++;	/*    shift formants */
			*coefp += temp1;
		}
		while (--nn);
		ampscale = 1. / (1. - p->d * *coefp);	/*    & reset scales */
		cq = (1. - p->d * p->d) * ampscale;
	}
	else {
		cq = 1.;
		ampscale = 1.;
	}
	x = p->prvout;
	do {
		nn = q->npoles - 1;
		pastp  = pastp1 = p->past + nn;
		temp1 = *pastp;
		*pastp = cq * x - p->d * *pastp;
		pastp--;
		do {
			temp2 = *pastp;
			*pastp = (*pastp1 - *pastp) * p->d + temp1;
			pastp--;   pastp1--;
			temp1 = temp2;
		}
		while (--nn);
		x = *asig++;
		pastp = p->past;
		coefp = q->kcoefs;
		nn = q->npoles;
		do  x += *coefp++ * *pastp++;
		while (--nn);
		*rslt++ = x * ampscale;
	}
	while (--nsmps);
	p->prvout = x;
}

rmsset(p)
 register RMS *p;
{
register float	b;

	b = 2. - cos(*p->ihp * tpidsr);
	p->c2 = b - sqrt(b * b - 1.);
	p->c1 = 1. - p->c2;
	if (!*p->istor)
		p->prvq = 0;
}

gainset(p)
 register GAIN *p;
{
register float	b;

	b = 2. - cos(*p->ihp * tpidsr);
	p->c2 = b - sqrt(b * b - 1.);
	p->c1 = 1. - p->c2;
	if (!*p->istor)
		p->prvq = p->prva = 0;
}

balnset(p)
 register BALANCE *p;
{
register float	b;

	b = 2. - cos(*p->ihp * tpidsr);
	p->c2 = b - sqrt(b * b - 1.);
	p->c1 = 1. - p->c2;
	if (!*p->istor)
		p->prvq = p->prvr = p->prva = 0;
}

rms(p)
 register RMS *p;
{
register int	nsmps = ksmps;
register float	*asig;
register float	q;

	q = p->prvq;
	asig = p->asig;
	do {	q = p->c1 * *asig * *asig + p->c2 * q;
		asig++;
	}
	while (--nsmps);
	p->prvq = q;
	*p->kr = sqrt(q);
}

gain(p)
 register GAIN *p;
{
register int	nsmps = ksmps;
register float	*ar, *asig;
register float	q, a, m, diff, inc;

	q = p->prvq;
	asig = p->asig;
	do {	q = p->c1 * *asig * *asig + p->c2 * q;
		asig++;
	}
	while (--nsmps);
	p->prvq = q;
	if (q = sqrt(q))
		a = *p->krms / q;
	else	a = *p->krms;
	asig = p->asig;
	ar = p->ar;
	nsmps = ksmps;
	if ((diff = a - p->prva) != 0) {
		m = p->prva;
		inc = diff/ksmps;
		do {	*ar++ = *asig++ * m;
			m += inc;
		}
		while (--nsmps);
		p->prva = a;
	}
	else {	do *ar++ = *asig++ * a;
		while (--nsmps);
	}
}

balance(p)
 register BALANCE *p;
{
register int	nsmps = ksmps;
register float	*ar, *asig, *csig;
register float	q, r, a, m, diff, inc;

	q = p->prvq;
	r = p->prvr;
	asig = p->asig;
	csig = p->csig;
	do {	q = p->c1 * *asig * *asig + p->c2 * q;
		r = p->c1 * *csig * *csig + p->c2 * r;
		asig++;	csig++;
	}
	while (--nsmps);
	p->prvq = q;
	p->prvr = r;
	if (q)
		a = sqrt(r/q);
	else	a = sqrt(r);
	asig = p->asig;
	ar = p->ar;
	nsmps = ksmps;
	if ((diff = a - p->prva) != 0) {
		m = p->prva;
		inc = diff/ksmps;
		do {	*ar++ = *asig++ * m;
			m += inc;
		}
		while (--nsmps);
		p->prva = a;
	}
	else {	do *ar++ = *asig++ * a;
		while (--nsmps);
	}
}
