#! /usr/bin/perl
#
# makepv.pl - Copyright 1996 Richard W.E. Furse
#
# This is a simple Perl Script that runs pvcom on everything in a 'scripts'
# directory below the directory it is run from. Binaries produced are put
# into directory 'bin' which is also expected to exist directly below the
# directory the script is run from. Tailor to your needs.
#
# Note that this program expects every file in the scripts directory to
# be a script. If a file isn't then comilation will stop at that file.
#
# This script takes into account file dates - if up-to-date binaries
# for scripts already exist it won't bother recompiling those.
#
# Change the top line /usr/bin/perl to the full-path of perl (try
# 'whereis perl') if this script fails to run. If this doesn't work
# and you have Perl then #!/ probably doesn't work on your system, so
# run this script directly using the command 'perl < makepv.pl'.

# Read in the binary directory (create it if it doesn't exist:)
opendir (%dummy, "bin")
    || mkdir ("bin", 0755)
    || die ("Failed to open 'bin' directory");
# Read in the scripts directory
opendir (%dir, "scripts")
    || die ("Failed to open 'scripts' directory");
# Go through script files:
foreach $file (readdir (%dir))
{	if (-f "scripts/$file")
	{	if	((! -e "bin/$file")
			 || (! -f "bin/$file")
			 || (-M "scripts/$file" < -M "bin/$file"))
		{	print "Compiling $file.\n";
			# Compile:
			system "pvcom scripts/$file bin/$file"
			    || die ("Failed to compile $file.\n");

			# Running 'strip' at this point will make the
			# binary a little smaller and a little faster.
			# However there may not be strip on your
			# system so I'm leaving it commented out.

			# system "strip bin/$file"
			}
		else
		{	print "Skipping $file.\n";	}}}

###############################################################################





