
/* Musical Notation Editor for X, Chris Cannam 1994 */
/* Actions available from the Edit menu             */


#include "General.h"
#include "Widgets.h"
#include "Menu.h"
#include "Stave.h"
#include "StaveEdit.h"
#include "StavePrivate.h"
#include "Yawn.h"
#include "ItemList.h"
#include "GC.h"

#include <X11/Xaw/Form.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>

static ItemList clipboard = NULL;
static Boolean  cutting = False;

void EditMenuDelete (Widget, XtPointer, XtPointer);
void EditMenuCut    (Widget, XtPointer, XtPointer);
void EditMenuCopy   (Widget, XtPointer, XtPointer);
void EditMenuPaste  (Widget, XtPointer, XtPointer);


void EditMenuDelete(Widget w, XtPointer a, XtPointer b)
{
  ItemList       list;
  MajorStaveRec *mstave  = (MajorStaveRec *)stave;
  ItemList       start   = mstave->sweep.from.left;
  ItemList       end     = mstave->sweep.to.left;
  int            staveNo = mstave->sweep.stave;
  Boolean        oneItem;
  Clef          *clef;

  Begin("EditMenuDelete");

  if (!stave || !mstave->sweep.swept || !end || start == end) {
    XBell(display, 70);
    End;
  }

  oneItem =
    start ? (Next(start) == (List)end) : (end == mstave->music[staveNo]);

  if (mstave->bar_list->bars[staveNo] &&
      mstave->bar_list->bars[staveNo]->bar.clef) {

    clef = mstave->bar_list->bars[staveNo]->bar.clef;
    clef = (Clef *)clef->item.methods->clone((MusicObject)clef);

  } else {

    clef = NewClef(NULL, TrebleClef);
  }

  mstave->music[staveNo] =
    ItemListExpungeGroups(mstave->music[staveNo], start, end);

  if (start) list = (ItemList)Next(start);
  else       list = mstave->music[staveNo];

  while (list) {

    if (list == mstave->music[staveNo])
      mstave->music[staveNo] = (ItemList)Next(list);

    list->item->item.methods->destroy((MusicObject)list->item);

    if (list == end) {                                      /* final item? */

      Remove(list);
      break;

    } else {

      list = (ItemList)Remove(list);                            /* iterate */
    }
  }

  if (!mstave->music[staveNo]) {

    mstave->music[staveNo] = NewItemList((Item *)clef);
    
    if (oneItem && !cutting) IssueMenuComplaint
      ("You can't remove the only item in a staff.");
  }

  FileMenuMarkChanged(stave, True);
  StaveResetFormatting(stave, staveNo);
  StaveRefreshAsDisplayed(stave);
  End;
}



void EditMenuCopy(Widget w, XtPointer a, XtPointer b)
{
  ItemList       list;
  MajorStaveRec *mstave  = (MajorStaveRec *)stave;
  ItemList       start   = mstave->sweep.from.left;
  ItemList       end     = mstave->sweep.to.left;
  Item          *newItem;

  Begin("EditMenuCopy");

  if (!stave || !mstave->sweep.swept || !end || start == end) {
    XBell(display, 70);
    End;
  }

  if (clipboard) DestroyItemList(clipboard);
  clipboard = NULL;

  if (start) list = (ItemList)Next(start);
  else       list = mstave->music[mstave->sweep.stave];

  while (list) {

    if (list->item->generic.object_class == GroupClass) {

      if (list == end) break;
      list = (ItemList)Next(list);
      continue;
    }

    newItem = (Item *)list->item->item.methods->clone((MusicObject)list->item);
    clipboard = (ItemList)Nconc(clipboard, NewItemList(newItem));

    if (list == end) break;
    list = (ItemList)Next(list);
  }

  clipboard = (ItemList)First
    (Nconc
     (NewItemList((Item *)NewBar(NULL, 0L, SingleBar, SingleBar)), clipboard));

  ((Bar *)clipboard->item)->group.start = (ItemList)Next(First(clipboard));
  ((Bar *)clipboard->item)->group.end   = (ItemList)Last(clipboard);

  if (w) {
    StaveResetFormatting(stave, mstave->sweep.stave);
    StaveRefreshAsDisplayed(stave);
  }

  End;
}


/* for the time being lets cop out and implement Cut as a Copy and a Delete */

void EditMenuCut(Widget w, XtPointer a, XtPointer b)
{
  MajorStaveRec *mstave  = (MajorStaveRec *)stave;
  ItemList       start   = mstave->sweep.from.left;
  ItemList       end     = mstave->sweep.to.left;
  int            staveNo = mstave->sweep.stave;

  Begin("EditMenuCut");

  if (!stave || !mstave->sweep.swept || !end || start == end) {
    XBell(display, 70);
    End;
  }

  cutting = True;

  EditMenuCopy   (NULL, a, b);
  EditMenuDelete (w,    a, b);

  cutting = False;

  End;
}



void EditMenuPaste(Widget w, XtPointer a, XtPointer b)
{
  MajorStaveRec *mstave  = (MajorStaveRec *)stave;
  ItemList       start   = mstave->sweep.from.left;
  ItemList       end     = mstave->sweep.to.left;
  int            staveNo = mstave->sweep.stave;
  Item          *newItem;
  ItemList       newList = NULL;
  ItemList       list;

  Begin("EditMenuPaste");

  if (!stave || !mstave->sweep.swept || start != end) {
    XBell(display, 70);
    End;
  }

  if (!clipboard) {
    IssueMenuComplaint("The clipboard is empty.");
    End;
  }

  for (list = (ItemList)Next(First(clipboard));	/* miss out grouping item */
       list; list = (ItemList)Next(list)) {

    newItem = (Item *)list->item->item.methods->clone((MusicObject)list->item);
    newList = (ItemList)Nconc(newList, NewItemList(newItem));
  }

  if (start)
    if (Next(start)) Insert(newList, Next(start));
    else Nconc(start, newList);
  else start = (ItemList)Nconc(newList, start);

  FileMenuMarkChanged(stave, True);
  StaveResetFormatting(stave, staveNo);
  StaveRefreshAsDisplayed(stave);
  End;
}


static void ClipboardCallback(Widget w, XtPointer client, XtPointer call)
{
  Begin("ClipboardCallback");

  *((Boolean *)client) = True;

  End;
}


void EditMenuShowClipboard(Widget w, XtPointer a, XtPointer b)
{
  Widget       clipShell;
  Widget       clipPane;
  Widget       clipMapForm;
  Widget       clipMapViewport;
  Widget       clipMapLabel;
  Widget       clipBottomBox;
  Widget       clipButton;
  Widget       scrollbar;
  Pixmap       clipMap = NULL;
  XPoint       op;
  Dimension    h;
  Dimension    width;
  int          sy;
  Boolean      done = False;
  XtAppContext context;

  Begin("EditMenuShowClipboard");

  clipShell     = XtCreatePopupShell
    ("Editor Clipboard", transientShellWidgetClass, topLevel, NULL, 0);

  clipPane      = YCreateWidget("Clipboard Pane", panedWidgetClass, clipShell);

  clipMapForm   = YCreateShadedWidget
    ("Clipboard Label Form", formWidgetClass, clipPane, LightShade);
  clipBottomBox = YCreateShadedWidget
    ("Clipboard Button Box",  boxWidgetClass, clipPane, MediumShade);

  YSetValue(clipMapForm,   XtNshowGrip, False);
  YSetValue(clipBottomBox, XtNshowGrip, False);

  clipMapViewport = YCreateWidget
    ("Clipboard Viewport", viewportWidgetClass, clipMapForm);
  clipMapLabel    = YCreateWidget
    ("Clipboard Contents", labelWidgetClass, clipMapViewport);
  clipButton      = YCreateCommand("Dismiss", clipBottomBox);

  if (clipboard) {

    width = clipboard->item->item.methods->get_min_width
      ((MusicObject)clipboard->item);

    clipMap = XCreatePixmap
      (display, RootWindowOfScreen(XtScreen(topLevel)), width + 10,
       StaveHeight + 2 * StaveUpperGap,
       DefaultDepthOfScreen(XtScreen(topLevel)));

    XFillRectangle(display, clipMap, clearGC, 0, 0, width + 10,
		   StaveHeight + StaveUpperGap * 2);

    clipboard->item->item.methods->draw
      ((MusicObject)clipboard->item,
       clipMap, 5, StaveUpperGap, 0, width, NULL);

    for (sy = 0 ; sy < StaveHeight; sy += NoteHeight + 1)
      XDrawLine(display, clipMap, drawingGC,
		4, StaveUpperGap + sy, width + 4, StaveUpperGap + sy);

    XDrawLine(display, clipMap, drawingGC,
	      4, StaveUpperGap, 4, StaveUpperGap + StaveHeight - 1);

    YSetValue(clipMapLabel, XtNbitmap, clipMap);

  } else {

    YSetValue(clipMapLabel, XtNlabel, "The clipboard is empty.");
  }

  XtAddCallback(clipButton, XtNcallback, ClipboardCallback, &done);

  XtRealizeWidget(clipShell);
  YGetValue(clipButton, XtNheight, &h);
  XtUnrealizeWidget(clipShell);

  YSetValue(clipBottomBox, XtNmax, h + 15);
  YSetValue(clipBottomBox, XtNmin, h + 15);

  XtRealizeWidget(clipShell);

  scrollbar = XtNameToWidget(clipMapViewport, "horizontal");
  if (scrollbar) YSetValue(scrollbar, XtNthumb, lightGreyMap);

  op = YPlacePopupAndWarp(clipShell, XtGrabExclusive, clipButton, clipButton);
  YAssertDialogueActions(clipShell, clipButton, clipButton, NULL);

  context = XtWidgetToApplicationContext(clipShell);
  while (!done || XtAppPending(context)) XtAppProcessEvent(context, XtIMAll);

  if (op.x || op.y) (void) YPopPointerPosition();

  YPopdown(clipShell);
  YRetractDialogueActions(clipShell);
  XtDestroyWidget(clipShell);

  End;
}



/* I really must write this some time: */

void EditMenuChangeNote(Widget w, XtPointer a, XtPointer b)
{
  MajorStaveRec *mstave = (MajorStaveRec *)stave;
  ItemList       start   = mstave->sweep.from.left;
  ItemList       end     = mstave->sweep.to.left;
  int            staveNo = mstave->sweep.stave;

  Begin("EditMenuChangeNote");

  if (!stave || !mstave->sweep.swept || !end || start != (ItemList)Prev(end)) {
    XBell(display, 70);
    End;
  }

  End; 
}

