
#ifndef _MUSIC_RESOURCES_
#define _MUSIC_RESOURCES_

#include "General.h"


#define XtNtimeSignatureFont "timeSignatureFont"
#define XtCTimeSignatureFont "TimeSignatureFont"
#define XtNbigTextFont       "bigTextFont"
#define XtCBigTextFont       "BigTextFont"
#define XtNlittleTextFont    "littleTextFont"
#define XtCLittleTextFont    "LittleTextFont"
#define XtNitalicTextFont    "italicTextFont"
#define XtCItalicTextFont    "ItalicTextFont"
#define XtNtinyTextFont      "tinyTextFont"
#define XtCTinyTextFont      "TinyTextFont"
#define XtNaboutTextFont     "aboutTextFont"
#define XtCAboutTextFont     "AboutTextFont"
#define XtNinterlockWindow   "interlockWindow"
#define XtCInterlockWindow   "InterlockWindow"
#define XtNmusicDirectory    "musicDirectory"
#define XtCMusicDirectory    "MusicDirectory"
#define XtNmidi2texName      "midi2texName"
#define XtCMidi2texName      "Midi2texName"
#define XtNacceleratorTable  "acceleratorTable"
#define XtCAcceleratorTable  "AcceleratorTable"
#define XtNfoundDefaults     "foundDefaults"
#define XtCFoundDefaults     "FoundDefaults"
#define XtNmidiBarEmphasis   "midiBarEmphasis"
#define XtCMidiBarEmphasis   "MidiBarEmphasis"


static XtResource resources[] = {
  {
    XtNtimeSignatureFont,
    XtCTimeSignatureFont,
    XtRString,
    sizeof(char *),
    XtOffset(AppDataPtr, timeSignatureFont),
    XtRImmediate,
    (caddr_t)"-*-new century schoolbook-medium-r-*--20-*-*-*-*-*-*-*",
  },
  {
    XtNbigTextFont,
    XtCBigTextFont,
    XtRString,
    sizeof(char *),
    XtOffset(AppDataPtr, bigTextFont),
    XtRImmediate,
    (caddr_t)"-*-new century schoolbook-medium-r-*--18-*-*-*-*-*-*-*",
  },
  {
    XtNlittleTextFont,
    XtCLittleTextFont,
    XtRString,
    sizeof(char *),
    XtOffset(AppDataPtr, littleTextFont),
    XtRImmediate,
    (caddr_t)"-*-new century schoolbook-medium-r-*--14-*-*-*-*-*-*-*",
  },
  {
    XtNitalicTextFont,
    XtCItalicTextFont,
    XtRString,
    sizeof(char *),
    XtOffset(AppDataPtr, italicTextFont),
    XtRImmediate,
    (caddr_t)"-*-new century schoolbook-medium-i-*--14-*-*-*-*-*-*-*",
  },
  {
    XtNtinyTextFont,
    XtCTinyTextFont,
    XtRString,
    sizeof(char *),
    XtOffset(AppDataPtr, tinyTextFont),
    XtRImmediate,
    (caddr_t)"-*-new century schoolbook-medium-i-*-*-12-*-*-*-*-*-*-*",
  },
  {
    XtNaboutTextFont,
    XtCAboutTextFont,
    XtRString,
    sizeof(char *),
    XtOffset(AppDataPtr, aboutTextFont),
    XtRImmediate,
    (caddr_t)"-*-lucida-medium-r-*-*-18-*-75-*-*-*-*-*",
  },
  {
    XtNmusicDirectory,
    XtCMusicDirectory,
    XtRString,
    sizeof(char *),
    XtOffset(AppDataPtr, musicDirectory),
    XtRImmediate,
    (caddr_t)".",
  },
  {
    XtNinterlockWindow,
    XtCInterlockWindow,
    XtRString,
    sizeof(char *),
    XtOffset(AppDataPtr, interlockWindow),
    XtRImmediate,
    (caddr_t)NULL,
  },
  {
    XtNmidi2texName,
    XtCMidi2texName,
    XtRString,
    sizeof(char *),
    XtOffset(AppDataPtr, midi2texName),
    XtRImmediate,
    (caddr_t)NULL,
  },
  {
    XtNacceleratorTable,
    XtCAcceleratorTable,
    XtRString,
    sizeof(char *),
    XtOffset(AppDataPtr, acceleratorTable),
    XtRImmediate,
    (caddr_t)NULL,
  },
  {
    XtNmidiBarEmphasis,
    XtCMidiBarEmphasis,
    XtRInt,
    sizeof(int),
    XtOffset(AppDataPtr, midiBarEmphasis),
    XtRImmediate,
    (caddr_t)15,
  },
  {
    XtNfoundDefaults,
    XtCFoundDefaults,
    XtRBoolean,
    sizeof(Boolean),
    XtOffset(AppDataPtr, foundDefaults),
    XtRImmediate,
    (caddr_t)False,
  }
};


static XrmOptionDescRec commandOptions[] = {
  { "-musicdir",    "*musicDirectory",    XrmoptionSepArg, NULL },
  { "-midi2texname","*midi2texName",      XrmoptionSepArg, NULL },
  { "-tsigfn",      "*timeSignatureFont", XrmoptionSepArg, NULL },
  { "-bigfn",       "*bigTextFont",       XrmoptionSepArg, NULL },
  { "-littlefn",    "*littleTextFont",    XrmoptionSepArg, NULL },
  { "-tinyfn",      "*tinyTextFont",      XrmoptionSepArg, NULL },
  { "-italicfn",    "*italicTextFont",    XrmoptionSepArg, NULL },
  { "-aboutfn",     "*aboutTextFont",     XrmoptionSepArg, NULL },
  { "-accelerators","*acceleratorTable",  XrmoptionSepArg, NULL },
  { "-baremphasis", "*midiBarEmphasis",   XrmoptionSepArg, NULL },
  { "-ILTopBoxWin", "*interlockWindow",   XrmoptionSepArg, NULL },
};


#endif /* _MUSIC_RESOURCES_ */
