
#ifndef _MUSIC_STAVE_
#define _MUSIC_STAVE_

#include <stdio.h>
#include "Classes.h"

typedef void *MajorStave;
extern Boolean staveMoved;          /* cursor-drawing sets False,
				       scroll, load &c. True */

extern void       StaveInitialise          (Widget);
extern void       StaveInitialiseScrollbar (Widget);
extern void       StaveRefresh             (MajorStave, int);
extern void       StaveRefreshAsDisplayed  (MajorStave);
extern void       StaveResetFormatting     (MajorStave, int);
extern void       StaveUnmap               (MajorStave);
extern void       StaveScrollbarCallback   (Widget, XtPointer, XtPointer);
extern void       StaveLeftCallback        (Widget, XtPointer, XtPointer);
extern void       StaveRightCallback       (Widget, XtPointer, XtPointer);
extern void       StaveJumpCallback        (Widget, XtPointer, XtPointer);
extern void       StavePageCallback        (Widget, XtPointer, XtPointer);
extern MajorStave NewStave                 (int, ItemList *);
extern void       StaveDestroy             (MajorStave, Boolean);
extern void       StaveRenameStave         (MajorStave, int, String);
extern void       StaveSetBarStyle         (MajorStave, int, Boolean, BarTag);
extern void       StaveWriteToFile         (MajorStave, FILE *);
extern void       StaveCleanUp             (void);

extern MajorStave stave;

#endif /* _MUSIC_STAVE_ */

