
#ifndef _MUSIC_STAVECURSOR_
#define _MUSIC_STAVECURSOR_

#include <X11/Intrinsic.h>
#include "Lists.h"
#include "Classes.h"
#include "Stave.h"


typedef struct _PointerRec {
  ItemList left;		/* list giving item to left of pointer  */
  Position bound;		/* x-coord of left edge of item in list */
} PointerRec;

#define TestNullRec(x) (!((x).left || (x).bound))
#define MakeNullRec(x) do { (x).left = NULL; (x).bound = 0; } while(0)


/* the Lists here are actually StaveEltLists: */

extern int        StaveGetPointedStave (MajorStave, XPoint);
extern List       StaveGetPointedBar   (MajorStave, XPoint, int);
extern PointerRec StaveGetPointedItem  (MajorStave, XPoint, int, List);
extern Pitch      StaveGetPointedPitch (MajorStave, XPoint, int, ClefTag);

extern void       StaveCursorDrawX     (XPoint);

extern void       StaveCursorExpose    (MajorStave);
extern void       StaveCursorRemove    (MajorStave);
extern void       StaveCursorMark      (MajorStave, XPoint);
extern void       StaveCursorExtend    (MajorStave, XPoint);
extern void       StaveCursorFinish    (MajorStave, XPoint);


#endif /* _MUSIC_STAVECURSOR_ */

