
#ifndef _MUSIC_TAGS_
#define _MUSIC_TAGS_

/* These are referred to in Notes.h */

typedef unsigned int  NoteMods;
typedef unsigned long ChordMods;

#define ModNone      (0)

#define ModSharp     (1<<0)
#define ModFlat      (1<<1)
#define ModNatural   (1<<2)

#define ModDot       (1L<<0)
#define ModLegato    (1L<<1)
#define ModAccent    (1L<<2)
#define ModSfz       (1L<<3)
#define ModRfz       (1L<<4)
#define ModTrill     (1L<<5)
#define ModTurn      (1L<<6)
#define ModPause     (1L<<7)

#define ModDotPower    0
#define ModLegatoPower 1
#define ModAccentPower 2
#define ModSfzPower    3
#define ModRfzPower    4
#define ModTrillPower  5
#define ModTurnPower   6
#define ModPausePower  7


typedef short NoteTag;

#define Hemidemisemiquaver 0
#define Demisemiquaver     1
#define Semiquaver         2
#define Quaver             3
#define Crotchet           4
#define Minim              5
#define Semibreve          6

#define ShortestNote       0
#define LongestNote        6
#define NoteCount          7


typedef enum {
  Slur, Crescendo, Decrescendo
} MarkTag;


typedef short ClassTag;

#define GenericClass        0
#define ItemClass           1
#define IndicatorClass      2
#define MetronomeClass      3
#define ClefClass           4
#define KeyClass            5
#define TextClass           6
#define PhraseClass         7
#define RestClass           8
#define GroupClass          9
#define TimeSignatureClass 10
#define ChordClass         11
#define BarClass           12



typedef unsigned long MenuMode;

#define NullMode                (0L)
#define AreaSweptMode           (1L<<0)
#define NoAreaSweptMode         (1L<<1)
#define SequencerRunningMode    (1L<<2)
#define SequencerNotRunningMode (1L<<3)
#define FileLoadedMode          (1L<<4)
#define FileNotLoadedMode       (1L<<5)
#define CursorPlacedMode        (1L<<6)
#define CursorNotPlacedMode     (1L<<7)
#define NoFilenameToSaveInMode  (1L<<8)
#define MultipleItemsSweptMode  (1L<<9)
#define Midi2TeXUnavailableMode (1L<<10)

typedef enum {
  TrebleClef, TenorClef, AltoClef, BassClef
} ClefTag;

typedef enum {
  KeyA, KeyAflat, KeyB, KeyBflat, KeyC, KeyCflat, KeyCsharp,
  KeyD, KeyDflat, KeyE, KeyEflat, KeyF, KeyFsharp, KeyG, KeyGflat
} KeyTag;

typedef enum {
  TextAboveStave, TextAboveStaveLarge, TextAboveBarLine,
  TextBelowStave, TextBelowStaveItalic
} TextPosnTag;

typedef enum {
  GroupNoDecoration, GroupBeamed, GroupTupled, GroupDeGrace
} GroupTag;

typedef enum {
  SingleBar, DoubleBar, RepeatBar
} BarTag;

typedef enum {
  PaletteNothing, PaletteNotes, PaletteRests, PaletteKeys, PaletteClefs
} PaletteTag;



#endif /* _MUSIC_TAGS_ */

