/*
---------------------------------------------------------------------------------------------
			MIDI Sequencer - Final Year Project, A.J. Green
---------------------------------------------------------------------------------------------

File Name:	Resources.h

Description:	Definitions of application resources.

Author:		AJG

History:

Update	Date		Programmer	Comments
======	====		==========	========
001	24/01/94	AJG		File Created.
002     02/10/94        JPff		Added resource for midiPort

--------------------------------------------------------------------------------------------
*/


#define XtNaboutTextFont     "aboutTextFont"
#define XtCAboutTextFont     "AboutTextFont"
#define XtNinterlockWindow   "interlockWindow"
#define XtCInterlockWindow   "InterlockWindow"
#define XtNfoundDefaults     "foundDefaults"
#define XtCFoundDefaults     "FoundDefaults"
#define XtNmusicDirectory    "musicDirectory"
#define XtCmusicDirectory    "MusicDirectory"
#define XtNacceleratorTable  "acceleratorTable"
#define XtCacceleratorTable  "AcceleratorTable"
#define XtNmidiPort	     "midiPort"
#define XtCmidiPort	     "MidiPort"

static XtResource Midi_Resources[] = 
{
  	{
    		XtNinterlockWindow,
    		XtCInterlockWindow,
    		XtRString,
    		sizeof(char *),
    		XtOffset(AppDataPtr, interlockWindow),
    		XtRImmediate,
    		(caddr_t)NULL,
  	},
  	{
    		XtNfoundDefaults,
    		XtCFoundDefaults,
    		XtRBoolean,
    		sizeof(Boolean),
    		XtOffset(AppDataPtr, foundDefaults),
    		XtRImmediate,
    		(caddr_t)False,
  	},
	{
	  	XtNaboutTextFont,
    		XtCAboutTextFont,
    		XtRString,
    		sizeof(char *),
    		XtOffset(AppDataPtr, aboutTextFont),
    		XtRImmediate,
    		(caddr_t)"-*-lucida-medium-r-*-*-18-*-*-*-*-*-*-*",
  	},
	{
		XtNmusicDirectory,
		XtCmusicDirectory,
		XtRString,
		sizeof(char *),
		XtOffset(AppDataPtr, musicDirectory),
		(caddr_t)NULL,
	},
 	{
 	    	XtNmidiPort,
     		XtCmidiPort,
     		XtRString,
     		sizeof(char *),
     		XtOffset(AppDataPtr, midiPortName),
     		XtRImmediate,
     		(caddr_t)"/dev/ttyd2",
   	},
	{
	    	XtNacceleratorTable,
    		XtCacceleratorTable,
    		XtRString,
    		sizeof(char *),
    		XtOffset(AppDataPtr, acceleratorTable),
    		XtRImmediate,
    		(caddr_t)NULL,
  	},
};


static XrmOptionDescRec Midi_CommandOptions[] = 
{
    { "-aboutfn",     "*aboutTextFont",     XrmoptionSepArg, NULL },
    { "-ILTopBoxWin", "*interlockWindow",   XrmoptionSepArg, NULL },
    { "-midiport",    "*midiPort",          XrmoptionSepArg, NULL }
};
