
/* Rosegarden Top Box, widget creation stuff */

#include "General.h"
#include "Widgets.h"
#include "ILTypes.h"
#include "ILServer.h"
#include "ILClient.h"
#include "Yawn.h"
#include "YHelp.h"
#include "Visuals.h"

#include <sys/types.h>
#include <sys/stat.h>

#include <X11/Xaw/Form.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>

static Widget editButton;
static Widget midiButton;
static Widget helpButton;

Boolean serverStarted = False;

YMessageString aboutText[] = {
  { "The Rosegarden Top Box was written by", YMessageNormal, },
  { "Chris Cannam",                          YMessageBold,   },
  { "and",                                   YMessageItalic, },
  { "Andy Green",                            YMessageBold,   },
  { "as part of a final-year project at",    YMessageNormal, },
  { "the University of Bath, UK.",           YMessageNormal, },
};


void ActivateILClient(String tag)
{
  Begin("ActivateILClient");

  if (!strncmp(tag, "Mseq", 4) || !strncmp(tag, "Play", 4)) {

    SetSigHupForClient();
    XtSetSensitive(midiButton, False);

  } else if (!strncmp(tag, "Edit", 4)) {

    SetSigHupForClient();
    XtSetSensitive(editButton, False);

  }  else if (!strncmp(tag, "Help", 4)) {

    XtSetSensitive(helpButton, False);
  }

  End;
}


void InitialiseILServer(void)
{
  struct stat buf;

  Begin("InitialiseILServer");

  IL_ServerInit(topLevel, ProgramName, ClientFinished, ActivateILClient, NULL);

  serverStarted = True;
  
  if (stat(appData.editorName, &buf)) {
    fprintf(stderr,"%s: Cannot open editor service\n", ProgramName);
    appData.editorName = NULL;
  }

  if (stat(appData.sequencerName, &buf)) {
    fprintf(stderr,"%s: Cannot open sequencer service\n", ProgramName);
    appData.sequencerName = NULL;
  }

  if (appData.editorName) IL_AddService("Edit", appData.editorName);
  else XtSetSensitive(editButton, False);

  if (appData.sequencerName) {
    IL_AddService("Play", appData.sequencerName);
    IL_AddService("Mseq", appData.sequencerName);
  } else XtSetSensitive(midiButton, False);

  End;
}


void HelpILCallback(char *chunk)
{
  Begin("HelpILCallback");
  if (strcmp(chunk, "Nothing")) YHelpSetTopic(chunk);
  YHelpInstallHelp();
  IL_AcknowledgeRequest("Help", IL_SERVICE_OK);
  XtSetSensitive(helpButton, False);
  End;
}


void ILQuit(Boolean confirm)
{
  Begin("ILQuit");
  if (confirm) IL_DeRegisterWithServer("Help");
  YHelpClose();
  End;
}


/* This application is both server and client.  Interlock can't handle */
/* the case where the server window is the same as one of the clients  */
/* (it has multiple-messaging problems, things get sent to both client */
/* and server), so we have to use a different window for the client id */

void InitialiseILClient(void)
{
  Begin("InitialiseILClient");

  IL_ClientInit(XtWindow(topLevel), helpButton, ILQuit);
  IL_RegisterWithServer("Help", HelpILCallback);

  End;
}


void EditButton(Widget w, XtPointer a, XtPointer b)
{
  Begin("EditButton");
  IL_StartTask("Edit");
  YDarkenWidget(w);
  XtSetSensitive(w, False);
  SetSigHupForClient();
  End;
}


void MidiButton(Widget w, XtPointer a, XtPointer b)
{
  Begin("MidiButton");
  IL_StartTask("Mseq");
  YDarkenWidget(w);
  XtSetSensitive(w, False);
  SetSigHupForClient();
  End;
}


void AboutButton(Widget w, XtPointer a, XtPointer b)
{
  Begin("AboutButton");
  YMessage(XtParent(w), "About Rosegarden",
	   "Enough!", aboutText, XtNumber(aboutText));
  End;
}


void ClientFinished(char *name)
{
  Begin("ClientFinished");
  if (strncmp(name, "Edit", 4) == 0)
    XtSetSensitive(editButton, True);
  else if (strncmp(name, "Mseq", 4) == 0 || strncmp(name, "Play", 4) == 0)
    XtSetSensitive(midiButton, True);
  else if (strncmp(name, "Help", 4) == 0)
    XtSetSensitive(helpButton, True);
  End;
}


void HelpFinished()
{
  XtSetSensitive(helpButton, True);
}


void HelpButton(Widget w, XtPointer a, XtPointer b)
{
  YHelpSetTopic("The Rosegarden Top Box");
  YHelpInstallHelp();
  IL_AcknowledgeRequest("Help", IL_SERVICE_OK);
  YDarkenWidget(w);
  XtSetSensitive(helpButton, False);
}


void CreateApplicationWidgets(void)
{
  Widget outerForm;
  Widget aboutButton;
  Widget quitButton;
  Window w;

  Begin("CreateApplicationWidgets");

  w = RootWindowOfScreen(XtScreen(topLevel));

  YInitialise(topLevel, NULL);
  YHelpInitialise(topLevel, "Rosegarden Help", NULL, HelpFinished,
		  "The Rosegarden Help System");
  YHelpSetHelpFile(appData.helpFile);

  InitialiseVisuals();

  YMessageInitialise(roseMap, appData.aboutTextFont);

  outerForm   = YCreateShadedWidget
    ("Top Box", formWidgetClass, topLevel, MediumShade);
  aboutButton = YCreateSurroundedWidget
    ("About", commandWidgetClass, outerForm, SurroundShade, NoShade);

  YSetValue( aboutButton, XtNbitmap,        roseMap );
  YSetValue(    topLevel, XtNiconPixmap,    roseMap );
  YSetValue(    topLevel, XtNiconMask,  roseMaskMap );

  editButton = YCreateCommand("Editor",    outerForm);
  midiButton = YCreateCommand("Sequencer", outerForm);
  quitButton = YCreateCommand("Quit",      outerForm);
  helpButton = YCreateCommand("Help",      outerForm);

  XtAddCallback(quitButton,  XtNcallback, QuitNicelyCallback, NULL);
  XtAddCallback(editButton,  XtNcallback,         EditButton, NULL);
  XtAddCallback(midiButton,  XtNcallback,         MidiButton, NULL);
  XtAddCallback(helpButton,  XtNcallback,         HelpButton, NULL);
  XtAddCallback(aboutButton, XtNcallback,        AboutButton, NULL);

  XtRealizeWidget(topLevel);

  YHelpSetIdentifyingBitmap(roseMap);
  YHelpSetXrefFont(appData.helpXrefFont);
  YHelpSetTitleFont(appData.helpTitleFont);
  YHelpSetTextFont(appData.helpTextFont);
  YHelpSetVerbatimFont(appData.helpVerbatimFont);

  InitialiseILServer();
  InitialiseILClient();
  End;
}

