			/* ENTRY.C with extra lines for new ugens 
			 * ugrw1.c. ugrw2.c
			 * Robin Whittle September 1995. 
			 *
			 * Also, the lines for kpow and apow changed to make
			 * inorm an optional parameter like it says it should
			 * be in the README.csoound of 14 April 95.
			 *
			 */
	 			
#include "cs.h"		/*				ENTRY.C		*/
#include "insert.h"
#include "aops.h"
#include "midiops.h"
#include "ugens1.h"
#include "ugens2.h"
#include "ugens3.h"
#include "ugens4.h"
#include "ugens5.h"
#include "ugens6.h"
#include "ugens7.h"
#include "dsputil.h"
#include "ugens8.h"
#include "ugens9.h"
#include "window.h"
#include "windin.h"
#include "spectra.h"
#include "disprep.h"
#include "soundio.h"
#include "dumpf.h"
#include "vdelay.h"
#include "aoscilx.h"
#include "follow.h"
#include "butter.h"
#include "grain.h"
#include "cmath.h"
#include "ugrw1.h"
#include "ugrw2.h"


#define S	sizeof

void	ihold(void*), turnoff(void*);
void	assign(void*), rassign(void*), aassign(void*);
void	init(void*), ainit(void*), flwset(void*), follow(void*);
void	gt(void*), ge(void*), lt(void*), le(void*), eq(void*), ne(void*);
void	and(void*), or(void*);
void	conval(void*), aconval(void*);
void	addkk(void*), subkk(void*), mulkk(void*), divkk(void*);
void	addka(void*), subka(void*), mulka(void*), divka(void*);
void	addak(void*), subak(void*), mulak(void*), divak(void*);
void	addaa(void*), subaa(void*), mulaa(void*), divaa(void*);
void	int1(void*), frac1(void*);
void	abs1(void*), exp01(void*), log01(void*), sqrt1(void*), sin1(void*), cos1(void*);
void	absa(void*), expa(void*), loga(void*), sqrta(void*), sina(void*), cosa(void*);
void	dbamp(void*), ampdb(void*), aampdb(void*);
void	ftlen(void*);
void	cpsoct(void*), octpch(void*), cpspch(void*);
void	pchoct(void*), octcps(void*), acpsoct(void*);
void	massign(void*), ctrlinit(void*), notnum(void*), veloc(void*);
void	pchmidi(void*), pchmidib(void*), octmidi(void*), octmidib(void*);
void	cpsmidi(void*), cpsmidib(void*);
void    ipchmidib(void*), ioctmidib(void*), icpsmidib(void*);
void    kpchmidib(void*), koctmidib(void*), kcpsmidib(void*), msclset(void*);
void	ampmidi(void*), aftset(void*), aftouch(void*), chpress(void*);
void	pbenset(void*), pchbend(void*);
void	imidictl(void*), mctlset(void*), midictl(void*);
void    ichanctl(void*), chctlset(void*), chanctl(void*);
void    kmapset(void*), polyaft(void*), pchbend(void*);
void	linset(void*), kline(void*), aline(void*);
void	expset(void*), kexpon(void*), expon(void*);
void	lsgset(void*), klnseg(void*), linseg(void*);
void	xsgset(void*), kxpseg(void*), expseg(void*);
void	lnnset(void*), klinen(void*), linen(void*);
void	lnrset(void*), klinenr(void*), linenr(void*);
void	evxset(void*), knvlpx(void*), envlpx(void*);
void	phsset(void*), kphsor(void*), phsor(void*);
void	itable(void*), itabli(void*);

void	tblset(void*), ktable(void*), table(void*), ktabli(void*), tabli(void*);

/* New k rate control table read functions 
 * in UGENS2.C
 */

void	tblsetkt(void*), ktablekt(void*), tablekt(void*), ktablikt(void*), tablikt(void*);

void	ko1set(void*), kosc1(void*),  kosc1i(void*);
void	oscset(void*), koscil(void*), osckk(void*), oscka(void*), oscak(void*);
void	oscaa(void*);
void	koscli(void*), osckki(void*), osckai(void*), oscaki(void*), oscaai(void*);
void	foscset(void*), foscil(void*), foscili(void*), losset(void*), loscil(void*);
void	adset(void*), adsyn(void*);
void	fofset(void*), fof(void*), pvset(void*), pvoc(void*);
void	bzzset(void*), buzz(void*);
void	gbzset(void*), gbuzz(void*);
void	plukset(void*), pluck(void*);
void	rndset(void*), krand(void*), arand(void*);
void	rhset(void*), krandh(void*), randh(void*);
void	riset(void*), krandi(void*), randi(void*);
void	porset(void*), port(void*);
void	tonset(void*), tone(void*), atone(void*);
void	rsnset(void*), reson(void*), areson(void*);
void	lprdset(void*), lpread(void*), lprsnset(void*), lpreson(void*);
void	lpfrsnset(void*), lpfreson(void*);
void	rmsset(void*), rms(void*), gainset(void*), gain(void*);
void	balnset(void*), balance(void*);
void	downset(void*), downsamp(void*), upsamp(void*);
void	indfset(void*), interp(void*), kntegrate(void*), integrate(void*);
void	kdiff(void*), diff(void*);
void	samphset(void*), ksmphold(void*), samphold(void*);
void	delset(void*),  delay(void*),  del1set(void*), delay1(void*);
void	delrset(void*), delayr(void*), delwset(void*), delayw(void*);
void	tapset(void*), deltap(void*), deltapi(void*);
void	cmbset(void*), comb(void*), alpass(void*), rvbset(void*), reverb(void*);
void	panset(void*), pan(void*);
void	sndinset(void*), soundin(void*);
void	in(void*),  ins(void*), inq(void*);
void	out(void*),  outs(void*), outs1(void*), outs2(void*);
void	outq(void*), outq1(void*), outq2(void*), outq3(void*), outq4(void*);
void	igoto(void*), kgoto(void*), icgoto(void*), kcgoto(void*);
void	timset(void*), timout(void*);
void	reinit(void*), rigoto(void*), rireturn(void*);
void	tigoto(void*), tival(void*);
void	printv(void*), dspset(void*), kdsplay(void*), dsplay(void*);
void	fftset(void*), kdspfft(void*), dspfft(void*);
void	octdwnset(void*), koctdown(void*), octdown(void*), nocdfset(void*), noctdft(void*);
void	spadmset(void*), specaddm(void*), spdifset(void*), specdiff(void*);
void	spsclset(void*), specscal(void*), sphstset(void*), spechist(void*);
void	spfilset(void*), specfilt(void*);
void	sptrkset(void*), specptrk(void*), spsumset(void*), specsum(void*);
void	spdspset(void*), specdisp(void*);

void	xyinset(void*), xyin(void*), tempeset(void*), tempest(void*);
void	tempset(void*), tempo(void*);
void    kdmpset(void*), kdmp2set(void*), kdmp3set(void*), kdmp4set(void*);
void    kdump(void*), kdump2(void*), kdump3(void*), kdump4(void*);

void	reverb2_set(void*), reverb2_play(void*);
void    butset(void*), bbutset(void*), hibut(void*), lobut(void*);
void	bpbut(void*), bcbut(void*);
void    butter_filter(void*);
void    vdelset(void*), vdelay(void*), multitap_set(void*), multitap_play(void*);
void    agsset(void*), ags(void*);
void	aoscilxset(void*), aoscilxplay(void*);
void    ipow(void*), kpow(void*), apow(void*);
void	alinear(void*), iklinear(void*), atrian(void*), iktrian(void*), aexp(void*);
void	ikexp(void*), abiexp(void*), ikbiexp(void*), agaus(void*), ikgaus(void*);
void	acauchy(void*), ikcauchy(void*), apcauchy(void*), ikpcauchy(void*), abeta(void*);
void	ikbeta(void*), aweib(void*), ikweib(void*), apoiss(void*);
void	ikpoiss(void*), seedrand(void*);

void	midiolap(void*),midiage(void*);
void	cvset(void*), convolve(void*);

/* New functions in UGRW1.C
 */

void	tblsetw(void*), ktablew(void*), tablew(void*), itablew(void*);
void	tblsetwkt(void*), ktablewkt(void*), tablewkt(void*);

void	tableng(void*), itableng(void*);
void	tablegpw(void*), itablegpw(void*);

void	tablemixset(void*), tablemix(void*), itablemix(void*); 
void	tablecopyset(void*), tablecopy(void*), itablecopy(void*);

void	tableraset(void*), tablera(void*);
void	tablewaset(void*), tablewa(void*);

void	zakinit();
void	zkset(void*), zir(void*), zkr(void*), ziw(void*), zkw(void*);
void	ziwm(void*), zkwm(void*), zkmod(void*), zkcl(void*);

void	zaset(void*), zar(void*), zarg(void*), zaw(void*);
void	zawm(void*), zamod(void*), zacl(void*);

void	timek(void*), times(void*);
void	instimset(void*), instimek(void*), instimes(void*);

void	printkset(void*), printk(void*);
void	printksset(void*), printks(void*);

/* New functions in UGRW2.C
 */

void 	kporset(void*), kport(void*);	
void	ktonset(void*), ktone(void*), katone(void*);
void	krsnset(void*), kreson(void*), kareson(void*);

void	limitset(void*), klimit(void*), limit(void*);
 

/* New functions in CMATH.C
 */

void	auniform(void*), ikuniform(void*);


/*****************************************************************************/


/* thread vals, where isub=1, ksub=2, asub=4:
		0 =	1  OR	2  (B out only)
		1 =	1
		2 =		2
		3 =	1  AND	2
		4 =			4
		5 =	1  AND		4
		7 =	1  AND (2  OR	4)			*/
		
/* inarg types include the following:
		m	begins an indef list of iargs (any count)
		n	begins an indef list of iargs (nargs odd)
		o	optional, defaulting to 0
		p	   "		"	1
		q	   "		"	10
		v	   "		"	.5
		j	   "		"	-1
   outarg types include:
		m	multiple outargs (1 to 4 allowed)
   (these types must agree with rdorch.c)			*/

OENTRY opcodlst[] = {
/* opcode   dspace	thread	outarg	inargs	isub	ksub	asub	*/
{ ""									},
{ "instr",  0					 			},
{ "endin",  0								},
{ "$label", S(LBLBLK)							},
{ "=",	    0								},
{ "init",   0	/* base names for later prefixes,suffixes */		},
{ "pchmidib",0								},
{ "octmidib",0								},
{ "cpsmidib",0								},
{ "midictrl",0								},
{ "oscil",  0								},
{ "oscili", 0								},

{ "ihold",  S(LINK),	1,	"",	"",	ihold			},
{ "turnoff",S(LINK),	2,	"",	"",	NULL,	turnoff		},
{ "r=",	    S(ASSIGN),	1,	"r",	"i",	rassign			},
{ "i=",	    S(ASSIGN),	1,	"i",	"i",	assign			},
{ "k=",	    S(ASSIGN),	2,	"k",	"k",	NULL,	assign		},
{ "a=",	    S(ASSIGN),	4,	"a",	"x",	NULL,	NULL,	aassign	},
{ "iinit",  S(ASSIGN),	1,	"i",	"i",	init			},
{ "kinit",  S(ASSIGN),	1,	"k",	"i",	init			},
{ "ainit",  S(ASSIGN),	1,	"a",	"i",	ainit			},
{ ">",      S(RELAT),	0,	"B",	"kk",	gt,	gt		},
{ ">=",     S(RELAT),	0,	"B",	"kk",	ge,	ge		},
{ "<",      S(RELAT),	0,	"B",	"kk",	lt,	lt		},
{ "<=",     S(RELAT),	0,	"B",	"kk",	le,	le		},
{ "==",     S(RELAT),	0,	"B",	"kk",	eq,	eq		},
{ "!=",     S(RELAT),	0,	"B",	"kk",	ne,	ne		},
{ "&&",     S(LOGCL),	0,	"B",	"BB",	and,	and		},
{ "||",     S(LOGCL),	0,	"B",	"BB",	or,	or		},
{ ":i",     S(CONVAL),	1,	"i",	"bii",	conval			},
{ ":k",     S(CONVAL),	2,	"k",	"Bkk",	NULL,	conval		},
{ ":a",     S(CONVAL),	4,	"a",	"Bxx",	NULL,	NULL,	aconval	},
{ "addii",  S(AOP),	1,	"i",	"ii",	addkk			},
{ "subii",  S(AOP),	1,	"i",	"ii",	subkk			},
{ "mulii",  S(AOP),	1,	"i",	"ii",	mulkk			},
{ "divii",  S(AOP),	1,	"i",	"ii",	divkk			},
{ "addkk",  S(AOP),	2,	"k",	"kk",	NULL,	addkk		},
{ "subkk",  S(AOP),	2,	"k",	"kk",	NULL,	subkk		},
{ "mulkk",  S(AOP),	2,	"k",	"kk",	NULL,	mulkk		},
{ "divkk",  S(AOP),	2,	"k",	"kk",	NULL,	divkk		},
{ "addka",  S(AOP),	4,	"a",	"ka",	NULL,	NULL,	addka	},
{ "subka",  S(AOP),	4,	"a",	"ka",	NULL,	NULL,	subka	},
{ "mulka",  S(AOP),	4,	"a",	"ka",	NULL,	NULL,	mulka	},
{ "divka",  S(AOP),	4,	"a",	"ka",	NULL,	NULL,	divka	},
{ "addak",  S(AOP),	4,	"a",	"ak",	NULL,	NULL,	addak	},
{ "subak",  S(AOP),	4,	"a",	"ak",	NULL,	NULL,	subak	},
{ "mulak",  S(AOP),	4,	"a",	"ak",	NULL,	NULL,	mulak	},
{ "divak",  S(AOP),	4,	"a",	"ak",	NULL,	NULL,	divak	},
{ "addaa",  S(AOP),	4,	"a",	"aa",	NULL,	NULL,	addaa	},
{ "subaa",  S(AOP),	4,	"a",	"aa",	NULL,	NULL,	subaa	},
{ "mulaa",  S(AOP),	4,	"a",	"aa",	NULL,	NULL,	mulaa	},
{ "divaa",  S(AOP),	4,	"a",	"aa",	NULL,	NULL,	divaa	},
{ "iint",   S(EVAL),	1,	"i",	"i",	int1			},
{ "ifrac",  S(EVAL),	1,	"i",	"i",	frac1			},
{ "iabs",   S(EVAL),	1,	"i",	"i",	abs1			},
{ "iexp",   S(EVAL),	1,	"i",	"i",	exp01			},
{ "ilog",   S(EVAL),	1,	"i",	"i",	log01			},
{ "isqrt",  S(EVAL),	1,	"i",	"i",	sqrt1			},
{ "isin",   S(EVAL),	1,	"i",	"i",	sin1			},
{ "icos",   S(EVAL),	1,	"i",	"i",	cos1			},
{ "kint",   S(EVAL),	2,	"k",	"k",	NULL,	int1		},
{ "kfrac",  S(EVAL),	2,	"k",	"k",	NULL,	frac1		},
{ "kabs",   S(EVAL),	2,	"k",	"k",	NULL,	abs1		},
{ "kexp",   S(EVAL),	2,	"k",	"k",	NULL,	exp01		},
{ "klog",   S(EVAL),	2,	"k",	"k",	NULL,	log01		},
{ "ksqrt",  S(EVAL),	2,	"k",	"k",	NULL,	sqrt1		},
{ "ksin",   S(EVAL),	2,	"k",	"k",	NULL,	sin1		},
{ "kcos",   S(EVAL),	2,	"k",	"k",	NULL,	cos1		},
{ "aabs",   S(EVAL),	4,	"a",	"a",	NULL,	NULL,	absa	},
{ "aexp",   S(EVAL),	4,	"a",	"a",	NULL,	NULL,	expa	},
{ "alog",   S(EVAL),	4,	"a",	"a",	NULL,	NULL,	loga	},
{ "asqrt",  S(EVAL),	4,	"a",	"a",	NULL,	NULL,	sqrta	},
{ "asin",   S(EVAL),	4,	"a",	"a",	NULL,	NULL,	sina	},
{ "acos",   S(EVAL),	4,	"a",	"a",	NULL,	NULL,	cosa	},
{ "idbamp", S(EVAL),	1,	"i",	"i",	dbamp			},
{ "iampdb", S(EVAL),	1,	"i",	"i",	ampdb			},
{ "kdbamp", S(EVAL),	2,	"k",	"k",	NULL,	dbamp		},
{ "kampdb", S(EVAL),	2,	"k",	"k",	NULL,	ampdb		},
{ "aampdb", S(EVAL),	4,	"a",	"a",	NULL,	NULL,	aampdb	},
{ "iftlen", S(EVAL),	1,	"i",	"i",	ftlen			},
{ "ki",	    S(ASSIGN),	1,	"i",	"k",	init			},
{ "icpsoct",S(EVAL),	1,	"i",	"i",	cpsoct			},
{ "ioctpch",S(EVAL),	1,	"i",	"i",	octpch			},
{ "icpspch",S(EVAL),	1,	"i",	"i",	cpspch			},
{ "ipchoct",S(EVAL),	1,	"i",	"i",	pchoct			},
{ "ioctcps",S(EVAL),	1,	"i",	"i",	octcps			},
{ "kcpsoct",S(EVAL),	2,	"k",	"k",	NULL,	cpsoct		},
{ "koctpch",S(EVAL),	2,	"k",	"k",	NULL,	octpch		},
{ "kcpspch",S(EVAL),	2,	"k",	"k",	NULL,	cpspch		},
{ "kpchoct",S(EVAL),	2,	"k",	"k",	NULL,	pchoct		},
{ "koctcps",S(EVAL),	2,	"k",	"k",	NULL,	octcps		},
{ "acpsoct",S(EVAL),	4,	"a",	"a",	NULL,	NULL,	acpsoct	},
{ "notnum", S(MIDIVAL), 1,	"i",	"",	notnum			},
{ "veloc",  S(MIDIVAL), 1,	"i",	"",	veloc			},
{ "pchmidi",S(MIDIVAL), 1,	"i",	"",	pchmidi			},
{ "octmidi",S(MIDIVAL), 1,	"i",	"",	octmidi			},
{ "cpsmidi",S(MIDIVAL), 1,	"i",	"",	cpsmidi			},
{ "ipchmidib",S(MIDIVAL),1,	"i",	"",	pchmidib		},
{ "ioctmidib",S(MIDIVAL),1,	"i",	"",	octmidib		},
{ "icpsmidib",S(MIDIVAL),1,	"i",	"",	cpsmidib		},
{ "kpchmidib",S(MIDIVAL),2,	"k",	"",	NULL,	pchmidib	},
{ "koctmidib",S(MIDIVAL),2,	"k",	"",	NULL,	octmidib	},
{ "kcpsmidib",S(MIDIVAL),2,	"k",	"",	NULL,	cpsmidib	},
{ "ampmidi",S(MIDIAMP), 1,	"i",	"io",	ampmidi			},
{ "aftouch",S(MIDISCL), 3,	"k",	"i",	aftset, aftouch		},
{ "chpress",S(MIDISCL), 3,	"k",	"i",	aftset, chpress		},
{ "pchbend",S(MIDISCL), 3,	"k",	"i",	pbenset,pchbend 	},
{ "imidictrl",S(MIDICTL),1,	"i",	"i",	imidictl		},
{ "kmidictrl",S(MIDICTL),3,	"k",	"i",	mctlset,midictl 	},
{ "line",   S(LINE),	7,	"s",	"iii",	linset,	kline,	aline	},
{ "expon",  S(EXPON),	7,	"s",	"iii",	expset,	kexpon,	expon	},
{ "linseg", S(LINSEG),  7,	"s",	"iin",	lsgset,	klnseg,	linseg	},
{ "expseg", S(EXPSEG),  7,	"s",	"iin",	xsgset,	kxpseg,	expseg	},
{ "linen",  S(LINEN),	7,	"s",	"xiii",	lnnset,	klinen,	linen	},
{ "linenr", S(LINENR),	7,	"s",	"xiii", lnrset,	klinenr,linenr	},
{ "envlpx", S(ENVLPX),	7,	"s",  "xiiiiiio",evxset,knvlpx,	envlpx	},
{ "phasor", S(PHSOR),	7,	"s",	"xo",	phsset,	kphsor,	phsor	},


{ "itable", S(TABLE),	1,	"i",	"iiooo",itable	 		},
{ "itablei", S(TABLE),	1,	"i",	"iiooo",itabli	 		},

{ "table",  S(TABLE),	7,	"s",	"xiooo",tblset,	ktable,	table	},
{ "tablei", S(TABLE),	7,	"s",	"xiooo",tblset,	ktabli,	tabli	},

{ "tablekt",  S(TABLE),	7,	"s",  "xkooo",tblsetkt,	ktablekt, tablekt },
{ "tableikt", S(TABLE),	7,	"s",  "xkooo",tblsetkt,	ktablikt, tablikt },


{ "oscil1", S(OSCIL1),	3,	"k",	"ikii", ko1set,	kosc1   	},
{ "oscil1i",S(OSCIL1),	3,	"k",	"ikii", ko1set,	kosc1i  	},
{ "oscilkk",S(OSC),	7,	"s",	"kkio",	oscset,	koscil,	osckk	},
{ "oscilka",S(OSC),	5,	"a",	"kaio",	oscset,	NULL,	oscka	},
{ "oscilak",S(OSC),	5,	"a",	"akio",	oscset,	NULL,	oscak	},
{ "oscilaa",S(OSC),	5,	"a",	"aaio",	oscset,	NULL,	oscaa	},
{ "oscilikk",S(OSC),	7,	"s",	"kkio",	oscset,	koscli,	osckki	},
{ "oscilika",S(OSC),	5,	"a",	"kaio",	oscset,	NULL,	osckai	},
{ "osciliak",S(OSC),	5,	"a",	"akio",	oscset,	NULL,	oscaki	},
{ "osciliaa",S(OSC),	5,	"a",	"aaio",	oscset,	NULL,	oscaai	},
{ "foscil", S(FOSC),	5,	"a",  "xkkkkio",foscset,NULL,	foscil	},
{ "foscili",S(FOSC),	5,	"a",  "xkkkkio",foscset,NULL,	foscili	},
{ "loscil", S(LOSC),	5,	"mm", "xkiojoojoo",losset,NULL, loscil	},
{ "adsyn",  S(ADSYN),	5,	"a",	"kkkS",	adset,	NULL,	adsyn	},
{ "pvoc",   S(PVOC),	5,	"a",	"kkSo",	pvset,	NULL,	pvoc	},
{ "fof",    S(FOFS),	5,	"a","xxxkkkkkiiiioo",fofset,NULL,fof	},
{ "buzz",   S(BUZZ),	5,	"a",  "xxkio",  bzzset,	NULL,	buzz	},
{ "gbuzz",  S(GBUZZ),	5,	"a",  "xxkkkio",gbzset,	NULL,	gbuzz	},
{ "pluck",  S(PLUCK),	5,	"a",  "kkiiioo",plukset,NULL,	pluck	},
{ "rand",   S(RAND),	7,	"s",	"xv",	rndset,	krand,	arand	},
{ "randh",  S(RANDH),	7,	"s",	"xxv",	rhset,	krandh,	randh	},
{ "randi",  S(RANDI),	7,	"s",	"xxv",	riset,	krandi,	randi	},
{ "port",   S(PORT),	3,	"k",	"kio",	porset,	port		},
{ "tone",   S(TONE),	5,	"a",	"ako",	tonset,	NULL,	tone	},
{ "atone",  S(TONE),	5,	"a",	"ako",	tonset,	NULL,	atone	},
{ "reson",  S(RESON),	5,	"a",	"akkoo",rsnset,	NULL,	reson	},
{ "areson", S(RESON),	5,	"a",	"akkoo",rsnset,	NULL,	areson	},
{ "lpread", S(LPREAD),	3,	"kkkk",	"kSoo",	lprdset,lpread		},
{ "lpreson",S(LPRESON),	5,	"a",	"a",	lprsnset,NULL,	lpreson	},
{ "lpfreson",S(LPFRESON),5,	"a",	"ak",	lpfrsnset,NULL,	lpfreson},
{ "rms",    S(RMS),	3,	"k",	"aqo",	rmsset,	rms		},
{ "gain",   S(GAIN),	5,	"a",	"akqo",	gainset,NULL,	gain	},
{ "balance",S(BALANCE),	5,	"a",	"aaqo",	balnset,NULL,	balance	},
{ "downsamp",S(DOWNSAMP),3,	"k",	"ao",	downset,downsamp	},
{ "upsamp", S(UPSAMP),	4,	"a",	"k",	NULL,	NULL,	upsamp	},
{ "interp", S(INDIFF),	5,	"a",	"ko",	indfset,NULL,	interp	},
{ "integ",  S(INDIFF),	7,	"s",	"xo",	indfset,kntegrate,integrate},
{ "diff",   S(INDIFF),	7,	"s",	"xo",	indfset,kdiff,	diff	},
{ "samphold",S(SAMPHOLD),7,	"s",	"xxoo",	samphset,ksmphold,samphold},
{ "delay",  S(DELAY),	5,	"a",	"aio",	delset,	NULL,	delay	},
{ "delayr", S(DELAYR),	5,	"a",	"io",	delrset,NULL,	delayr	},
{ "delayw", S(DELAYW),	5,	"",	"a",	delwset,NULL,	delayw	},
{ "delay1", S(DELAY1),	5,	"a",	"ao",	del1set,NULL,	delay1	},
{ "deltap", S(DELTAP),	5,	"a",	"k",	tapset, NULL,	deltap	},
{ "deltapi",S(DELTAP),	5,	"a",	"x",	tapset, NULL,	deltapi	},
{ "comb",   S(COMB),	5,	"a",	"akio",	cmbset,	NULL,	comb	},
{ "alpass", S(COMB),	5,	"a",	"akio",	cmbset,	NULL,	alpass	},
{ "reverb", S(REVERB),	5,	"a",	"ako",	rvbset,	NULL,	reverb	},
{ "pan",    S(PAN),	5,	"aaaa",	"akkioo",panset,NULL,	pan	},
{ "soundin",S(SOUNDIN),	5,	"mmmm",	"Soo",	sndinset,NULL,	soundin	},
{ "in",     S(IN),	4,	"a",	"",	NULL,	NULL,	in	},
{ "ins",    S(INS),	4,	"aa",	"",	NULL,	NULL,	ins	},
{ "inq",    S(INQ),	4,	"aaaa",	"",	NULL,	NULL,	inq	},
{ "out",    S(OUT),	4,	"",	"a",	NULL,	NULL,	out	},
{ "outs",   S(OUTS),	4,	"",	"aa",	NULL,	NULL,	outs	},
{ "outq",   S(OUTQ),	4,	"",	"aaaa",	NULL,	NULL,	outq	},
{ "outs1",  S(OUT),	4,	"",	"a",	NULL,	NULL,	outs1	},
{ "outs2",  S(OUT),	4,	"",	"a",	NULL,	NULL,	outs2	},
{ "outq1",  S(OUT),	4,	"",	"a",	NULL,	NULL,	outq1	},
{ "outq2",  S(OUT),	4,	"",	"a",	NULL,	NULL,	outq2	},
{ "outq3",  S(OUT),	4,	"",	"a",	NULL,	NULL,	outq3	},
{ "outq4",  S(OUT),	4,	"",	"a",	NULL,	NULL,	outq4	},
{ "igoto",  S(GOTO),	1,	"",	"l",	igoto			},
{ "kgoto",  S(GOTO),	2,	"",	"l",	NULL,	kgoto		},
{ "goto",   S(GOTO),	3,	"",	"l",	igoto,	kgoto		},
{ "icgoto", S(CGOTO),	1,	"",	"Bl",	icgoto			},
{ "kcgoto", S(CGOTO),	2,	"",	"Bl",	NULL,	kcgoto		},
{ "gcgoto", S(CGOTO),	3,	"",	"Bl",	icgoto,	kcgoto		},
{ "timout", S(TIMOUT),	3,	"",	"iil",	timset,	timout		},
{ "reinit", S(GOTO),	2,	"",	"l",	NULL,	reinit		},
{ "rigoto", S(GOTO),	1,	"",	"l",	rigoto			},
{ "rireturn",S(LINK),	1,	"",	"",	rireturn		},
{ "tigoto", S(GOTO),	1,	"",	"l",	tigoto			},
{ "tival",  S(EVAL),	1,	"i",	"",	tival			},
{ "print",  S(PRINTV),	1,	"",	"m",	printv			},
{ "display",S(DSPLAY),	7,	"",	"sioo",	dspset, kdsplay,dsplay	},
{ "dispfft",S(DSPFFT),	7,	"",	"siiooo",fftset,kdspfft,dspfft	},
{ "kdump",  S(KDUMP),	3,	"",	"kSii", kdmpset,kdump		},
{ "kdump2", S(KDUMP2),	3,	"",	"kkSii",kdmp2set,kdump2		},
{ "kdump3", S(KDUMP3),	3,	"",	"kkkSii",kdmp3set,kdump3	},
{ "kdump4", S(KDUMP4),	3,	"",	"kkkkSii",kdmp4set,kdump4	},
{ "octdown",S(OCTDOWN),	7,	"d",	"siio",octdwnset,koctdown,octdown},
{ "noctdft",S(NOCTDFT), 5,	"w",	"diiqooo",nocdfset,NULL,noctdft },
{ "specaddm",S(SPECADDM),5,	"w",	"wwp",  spadmset,NULL,	specaddm},
{ "specdiff",S(SPECDIFF),5,	"w",	"w",    spdifset,NULL,	specdiff},
{ "specscal",S(SPECSCAL),5,	"w",	"wii",  spsclset,NULL,	specscal},
{ "spechist",S(SPECHIST),5,	"w",	"w",    sphstset,NULL,	spechist},
{ "specfilt",S(SPECFILT),5,	"w",	"wi",   spfilset,NULL,	specfilt},
{ "specptrk",S(SPECPTRK),5,	"k",	"wiioooo",sptrkset,NULL,specptrk},
{ "specsum",S(SPECSUM), 5,	"k",	"wo",   spsumset,NULL,	specsum },
{ "specdisp",S(SPECDISP),5,	"",	"wii",  spdspset,NULL,	specdisp},
{ "xyin",   S(XYIN),    3,      "kk",   "iiiiioo",xyinset,xyin          },
{ "tempest",S(TEMPEST), 5,	"k","kiiiiiiiiiop",tempeset,NULL,tempest},
{ "tempo",  S(TEMPO),   3,      "",     "ki",   tempset,tempo           },
{ "reverb2", S(STVB),	5,	"a",	"akk",	reverb2_set, NULL, reverb2_play},
{ "butterhp",S(BFIL),   5,      "a",    "ak",   butset, NULL,   hibut   },
{ "butterlp",S(BFIL),   5,      "a",    "ak",   butset, NULL,   lobut   },
{ "butterbp",S(BBFIL),  5,      "a",    "akk",  bbutset, NULL,  bpbut   },
{ "butterbr",S(BBFIL),  5,      "a",    "akk",  bbutset, NULL,  bcbut   },
{ "vdelay",  S(VDEL),   5,      "a",    "axi",  vdelset, NULL,  vdelay  },
{ "grain",   S(PGRA),   5,      "a",    "xxxkkkiiio", agsset, NULL, ags },
{ "ipow",    S(POW),    1,      "i",    "ii",   ipow, NULL,     NULL    },
{ "kpow",    S(POW),    2,      "k",    "kkp",  NULL, kpow,     NULL    },
{ "apow",    S(POW),    4,      "a",    "akp",  NULL, NULL,     apow    },
{ "multitap",S(MDEL),	5,	"a",	"am",	multitap_set, NULL, multitap_play},
{ "follow",  S(FOL),	5,	"a",	"ai",	flwset, NULL,	follow  },
{ "oscilx",  S(AOX),	5,	"a",	"kiii",	aoscilxset, NULL, aoscilxplay},
{ "ilinrand", S(PRAND),	1,	"i",	"k",   	iklinear, NULL, NULL    },
{ "klinrand", S(PRAND),	2,	"k",	"k",	NULL, iklinear, NULL	},
{ "alinrand", S(PRAND),	4,	"a",	"k",	NULL, NULL,     alinear	},
{ "itrirand", S(PRAND),	1,	"i",	"k",	iktrian, NULL,  NULL	},
{ "ktrirand", S(PRAND),	2,	"k",	"k",	NULL, iktrian,  NULL	},
{ "atrirand", S(PRAND),	4,	"a",	"k",	NULL, NULL,     atrian	},
{ "iexprand", S(PRAND),	1,	"i",	"k",	ikexp, NULL,    NULL	},
{ "kexprand", S(PRAND),	2,	"k",	"k",	NULL, ikexp,    NULL	},
{ "aexprand", S(PRAND),	4,	"a",	"k",	NULL, NULL,     aexp	},
{ "ibexprnd", S(PRAND),	1,	"i",	"k",	ikbiexp, NULL,  NULL	},
{ "kbexprnd", S(PRAND),	2,	"k",	"k",	NULL, ikbiexp,  NULL	},
{ "abexprnd", S(PRAND),	4,	"a",	"k",	NULL, NULL,     abiexp	},
{ "icauchy" , S(PRAND),	1,	"i",	"k",	ikcauchy, NULL, NULL	},
{ "kcauchy" , S(PRAND),	2,	"k",	"k",	NULL, ikcauchy, NULL	},
{ "acauchy" , S(PRAND),	4,	"a",	"k",	NULL, NULL,     acauchy	},
{ "ipcauchy", S(PRAND),	1,	"i",	"k",	ikpcauchy, NULL,NULL	},
{ "kpcauchy", S(PRAND),	2,	"k",	"k",	NULL, ikpcauchy,NULL	},
{ "apcauchy", S(PRAND),	4,	"a",	"k",	NULL, NULL,     apcauchy},
{ "ipoisson", S(PRAND),	1,	"i",	"k",	ikpoiss, NULL,  NULL	},
{ "kpoisson", S(PRAND),	2,	"k",	"k",	NULL, ikpoiss,  NULL	},
{ "apoisson", S(PRAND),	4,	"a",	"k",	NULL, NULL,     apoiss	},
{ "igauss"  , S(PRAND),	1,	"i",	"k",	ikgaus, NULL,   NULL	},
{ "kgauss"  , S(PRAND),	2,	"k",	"k",	NULL, ikgaus,   NULL	},
{ "agauss"  , S(PRAND),	4,	"a",	"k",	NULL, NULL,     agaus	},
{ "iweibull", S(PRAND),	1,	"i",	"kk",	ikweib, NULL,   NULL	},
{ "kweibull", S(PRAND),	2,	"k",	"kk",	NULL, ikweib,   NULL	},
{ "aweibull", S(PRAND),	4,	"a",	"kk",	NULL, NULL,     aweib	},
{ "ibetarand",S(PRAND),	1,	"i",	"kkk",	ikbeta, NULL,   NULL	},
{ "kbetarand",S(PRAND),	2,	"k",	"kkk",	NULL, ikbeta,   NULL	},
{ "abetarand",S(PRAND),	4,	"a",	"kkk",	NULL, NULL,     abeta	},
{ "seed",     S(PRAND),	1,	"",	"i",	seedrand, NULL, NULL	},
{ "midiolap", S(MIDIOLAP), 1,   "",     "i",    midiolap                },
{ "midiage",S(MIDIOLAP),2,      "k",    "i",    NULL, midiage           },
{ "convolve", S(CONVOLVE), 5,	"mmmm", "aSo",  cvset, NULL,    convolve},


{ "itablew", S(TABLEW),	1,	"",	"iiiooo", itablew, NULL, NULL},
{ "tablew",  S(TABLEW),	7,	"",	"xxiooo",tblsetw,ktablew,tablew},

{ "tablewkt",S(TABLEW),	7,	"",   "xxkooo",tblsetwkt,ktablewkt,tablewkt},


{ "itableng",S(TABLENG),1,	"i",	"i",	 itableng, NULL,  NULL},
{ "tableng", S(TABLENG),2,	"k",	"k",	 NULL,	tableng, NULL},

{ "itablegpw",S(TABLENG),1,	"",	"i",	 itablegpw, NULL,  NULL},
{ "tablegpw", S(TABLENG),2,	"",	"k",	 NULL,	tablegpw, NULL},


{ "itablemix",S(TABLEMIX),1,	"",   "iiiiiiiii", itablemix, NULL, NULL},
{ "tablemix", S(TABLEMIX),2,	"",   "kkkkkkkkk",tablemixset, tablemix, NULL},

{ "itablecopy",S(TABLECOPY),1,	"",	"ii", 	 itablecopy, NULL, NULL},
{ "tablecopy", S(TABLECOPY),2,	"",	"kk",  tablecopyset, tablecopy, NULL},


{ "tablera", S(TABLERA),5,	"a",	"kkk",	 tableraset, NULL, tablera},
{ "tablewa", S(TABLEWA),5,	"k",	"kak",	 tablewaset, NULL, tablewa},


{ "zakinit", S(ZAKINIT), 1,	"",	"ii",	zakinit, NULL, 	NULL},

{ "zir",    S(ZKR),	1,	"i",	"i",	zir,	 NULL, 	NULL},
{ "zkr",    S(ZKR),	3,	"k",	"k",	zkset,   zkr,	NULL},

{ "ziw",    S(ZKW),	1,	"",	"ii",	ziw,	 NULL, 	NULL},
{ "zkw",    S(ZKW),	3,	"",	"kk",	zkset,   zkw,	NULL},

{ "ziwm",   S(ZKWM),	1,	"",	"iip",	ziwm,	 NULL, 	NULL},
{ "zkwm",   S(ZKWM),	3,	"",	"kkp",	zkset,   zkwm,	NULL},

{ "zkmod",  S(ZKMOD),	2,	"k",	"kk",	NULL,    zkmod,	NULL},

{ "zkcl",   S(ZKCL),	3,	"",	"kk",	zkset,   zkcl,	NULL},


{ "zar",    S(ZAR),	5,	"a",	"k",	zaset,   NULL, 	zar},
{ "zarg",   S(ZARG),	5,	"a",	"kk",	zaset,   NULL, 	zarg},

{ "zaw",    S(ZAW),	5,	"",	"ak",	zaset,   NULL, 	zaw},

{ "zawm",   S(ZAWM),	5,	"",	"akp",	zaset,   NULL, 	zawm},

{ "zamod",  S(ZAMOD),	4,	"a",	"ak",	NULL,    NULL,  zamod},

{ "zacl",   S(ZACL),	5,	"",	"kk",	zaset,   NULL, 	zacl},


{ "itimek", S(RDTIME), 	1,	"i",	"",	timek, 	 NULL,	NULL},
{ "itimes", S(RDTIME), 	1,	"i",	"",	times, 	 NULL,	NULL},
{ "timek",  S(RDTIME), 	2,	"k",	"",	NULL, 	 timek,	NULL},
{ "times",  S(RDTIME), 	2,	"k",	"",	NULL, 	 times,	NULL},
{ "instimek", S(RDTIME), 3,	"k",	"",   instimset, instimek, NULL},
{ "instimes", S(RDTIME), 3,	"k",	"",   instimset, instimes, NULL},


{ "printk", S(PRINTK), 	3,	"",	"iko",	printkset, printk, NULL},
{ "printks",S(PRINTKS),	3,	"",	"Sikkkk",printksset,printks, NULL},

{ "kport",   S(KPORT),	3,	"k",	"kko",	kporset, kport, NULL	},
{ "ktone",   S(KTONE),	3,	"k",	"kko",	ktonset, ktone, NULL	},
{ "katone",  S(KTONE),	3,	"k",	"kko",	ktonset, katone, NULL	},
{ "kreson",  S(KRESON),	3,	"k",	"kkkpo",krsnset, kreson, NULL	},
{ "kareson", S(KRESON),	3,	"k",	"kkkpo",krsnset, kareson, NULL	},

{ "ilimit", S(LIMIT),	1,	"i",	"iii",	 klimit, NULL, 	 NULL},
{ "limit",  S(LIMIT),	7,	"s",	"xkk",	 limitset, klimit, limit},


{ "iunirand", S(PRAND),	1,	"i",	"k",   	ikuniform, NULL, NULL },
{ "kunirand", S(PRAND),	2,	"k",	"k",	NULL, ikuniform, NULL },
{ "aunirand", S(PRAND),	4,	"a",	"k",	NULL, NULL, auniform  },


};

OENTRY *oplstend = opcodlst + sizeof(opcodlst)/sizeof(OENTRY);


