		/*					UGENS5.H	*/

					/* Comments added, but code is
					 * unchanged - Robin Whitttle 
					 * August 95
					 */
#include "lpc.h"	

					/* PORT data structure.
					 *
					 * Output and input pointers.
					 *
					 * kr		To k rate result.
 					 *
					 * ksig		k rate input.
					 *
					 * ihtim	i rate half time
					 *
					 *
					 * isig		Initial value for
					 * 		internal state.
					 */					
typedef	struct {
	OPDS	h;
	float	*kr, *ksig, *ihtim, *isig;
					
					/* Internal variables.
					 *
					 * c1 		Value to multiply with
					 *		input value.
					 *
					 * c2		Value to multiply with
					 *		previous state.
					 *
					 * yt1		Previous state.
					 */
	float	c1, c2, yt1;
} PORT;

					/*************************************/

					/* TONE data structure.
					 *
					 * For tone and atone.
					 *
					 * Output and input pointers.
					 *
					 * ar		To a rate result.
 					 *
					 * asig		a rate input.
					 *
					 * khp		k rate half power
					 *		frequency input.
					 *
					 * isig		Set to 0 to clear 
					 * 		internal state.
					 */
					
typedef struct {
	OPDS	h;
	float	*ar, *asig, *khp, *istor;

					/* Internal variables.
					 *
					 * c1 		Value to multiply with
					 *		input value.
					 *
					 * c2		Value to multiply with
					 *		previous state.
					 *
					 * yt1		Previous state - just
					 * 		one float, used
					 *		between calculations
					 *		in the array, and for
					 *		storing state between
					 *		k cycles.
					 *
					 * prvhp	Previous half power
					 *		frequency.
					 */
	float	c1, c2, yt1, prvhp;
} TONE;



					/*************************************/

					/* RESON data structure.
					 *
					 * For reson and areson.
					 *
					 * Output and input pointers.
					 *
					 * ar		To a rate result.
 					 *
					 * asig		a rate input.
					 *
					 * kcf		k rate centre freq.
					 *
					 * kbw		k rate bandwidth
					 *
					 * iscl		i rate scaling factor
					 *		0, 1 or 2.
					 *
					 * istor	Set to 0 to clear 
					 * 		internal state.
					 */
typedef	struct {
	OPDS	h;
	float	*ar, *asig, *kcf, *kbw, *iscl, *istor;
					
					/* Integers:
					 *
					 * scale	Copy of istor
					 */
	int     scale;
					/* c1, c2, c3 	Filter factors
					 *
					 * yt1		Delay 1 a sample
					 *	
					 * yt2		Delay 2 a samples
					 *
					 * cosf		Intermediate variable
					 *		to help calculations.
					 *		
					 * prvcf, prvbw	Previous centre freq
					 *		and bandwidth.
					 */

	float	c1, c2, c3, yt1, yt2, cosf, prvcf, prvbw;
} RESON;


					/* End of comments.
					 */


typedef struct {
	OPDS	h;
	float	*krmr, *krmo, *kerr, *kcps, *ktimpt, *ifilno, *inpoles, *ifrmrate;
	long	headlongs, npoles, nvals, lastfram16, lastmsg;
	float	kcoefs[MAXPOLES], framrat16;
	MEMFIL	*mfp;
} LPREAD;

typedef	struct {
	OPDS	h;
	float	*ar, *asig;
	float	circbuf[MAXPOLES<<1], *circjp, *jp2lim;
	LPREAD	*lpread;
} LPRESON;

typedef	struct {
	OPDS	h;
	float	*ar, *asig, *kfrqratio;
	float	past[MAXPOLES], prvratio, d, prvout;
	LPREAD	*lpread;
} LPFRESON;

typedef	struct {
	OPDS	h;
	float	*kr, *asig, *ihp, *istor;
	float	c1, c2, prvq;
} RMS;

typedef	struct {
	OPDS	h;
	float	*ar, *asig, *krms, *ihp, *istor;
	float	c1, c2, prvq, prva;
} GAIN;

typedef	struct {
	OPDS	h;
	float	*ar, *asig, *csig, *ihp, *istor;
	float	c1, c2, prvq, prvr, prva;
} BALANCE;
