							/*	UGRW1.H	
							 */

/*
 *	Unit generators by Robin Whittle 		7 September 1995
 *	Header file containing data structures for UGRW1.C.
 *	
 */

				/* TABLEW data structure used by all the
				 * tablew subroutines.
				 */	
typedef struct {

				/* Opcode data structure - see CS.H.
				 */
	OPDS	h;

				/* Seven pointers to input arguments. 
				 *
				 * xsig		Input value to write to table.
				 * 
				 * xndx  	Index into the table
				 *		where we want to write.
				 * 
				 * xfn		Number of table we are
				 * 		writing to.
				 *
				 * ixmode	Index mode (optional parm).
				 * 		0 --> Use raw xfn and ixoff.
				 *		1 --> Use these with a range of
				 *		      0 to 1 for the entire 
				 *    		      range of the table.
				 *
				 * ixoff	Offset (optional parm). 
				 *		Fixed value to add to ndx.
				 *
				 * iwgmode	Wrap and guard point mode 
				 *		(optional parm).
				 *
				 * 		0 --> Limit mode. 
				 *		      Limit indx to between 0 	
				 * 		      and length of table.		      
				 *
				 *		1 --> Wrap mode.
				 *		      Index wraps around modulo
				 * 		      length.
				 *
				 *		2 --> Guardpoint mode.
				 * 		      Write with 0.5 step 
				 * 		      offset, and write both
				 *		      location 0 and the 
				 *		      guardpoint with the 
				 *		      same data.
				 */

	float	*xsig, *xndx, *xfn;

	float	*ixmode, *ixoff, *iwgmode;


				/* Internal variable for previous state
				 * of xfn.
				 */
	long	pfn;

				/* Internal variable for what to multiply 
				 * the ndx and ixoff by. Set to 1 or table 
				 * length by tblwset() depending on ixmode.
				 */
	long   	xbmul;

				/* Internal variable for iwrap and igmode.
				 */
	long	iwgm;


				/* Internal variable for offset.
				 */
	float	offset;
	
				/* Pointer to data structure used to access 
				 * function table. See CS.H.  
				 * tblwset() writes this, based on the value 
				 * of xfn.
				 */
	FUNC	*ftp;
				

} TABLEW;
				/*-------------------------------------------*/

				/* TABLENG data structure used by function
				 * tableng to return the length of the table.
				 *
				 */	
typedef struct {
				/* Opcode data structure - see CS.H.
				 */
	OPDS	h;
				/* Pointer to arguments. 
				 *
				 * kout		Output pointer.
				 *
				 * xfn		Points to input parameter -
				 *		the number of the table.
				 */
	float	*kout, *xfn;

} TABLENG;
				/*-------------------------------------------*/

				/* TABLEGPW data structure used by function
				 * tablegpw to write the guard point of a 
				 * specified table.
				 *
				 * No output arguments.
				 */	
typedef struct {
				/* Opcode data structure - see CS.H.
				 */
	OPDS	h;
				/* Pointer to input argument. 
				 *
				 * xfn		Points to number of table.
				 */
	float	*xfn;

} TABLEGPW;


				/*-------------------------------------------*/

				/* TABLEMIX data structure used by function
				 * tablemix.
				 */	
typedef struct {
				/* Opcode data structure - see CS.H.
				 */
	OPDS	h;
				/* Pointer to nine input arguments. 
				 *
				 * See doco in ugrw2.c - too many to list 	
				 * here.
				 */

	float	*dft, *doff, *len, *s1ft, *s1off, *s1g, *s2ft, *s2off, *s2g;

				/* Storage to remember what the table numbers
				 * were from a previous k cycle, and to 
				 * store pointers to their FUNC data 
				 * structures.
				 *
				 * Ints:
				 *
				 * pdft		Previous destination and
				 * ps1ft ps2ft	source function table numbers.
				 *
				 * Pointers to FUNC data structures:
 				 *
				 * funcd	 Destination.
				 * funcs1 funcs2 Source.	
				 */

	int	pdft, ps1ft, ps2ft;

	FUNC	*funcd, *funcs1, *funcs2;

} TABLEMIX;

				/*-------------------------------------------*/

				/* TABLECOPY data structure used by function
				 * tablecopy.
				 */	
typedef struct {
				/* Opcode data structure - see CS.H.
				 */
	OPDS	h;
				/* Pointers to two input arguments. 
				 *
				 * dft	Destination function table number.
				 *
				 * sft	Source function table number.
				 */
	float	*dft, *sft;

				/* Storage to remember what the table numbers
				 * were from a previous k cycle, and to 
				 * store pointers to their FUNC data 
				 * structures.
				 *
				 * Ints:
				 *
				 * pdft		Previous destination and
				 * psft		source function table numbers.
				 *
				 * Pointers to FUNC data structures:
 				 *
				 * funcd	Destination.
				 * funcs	Source.	
				 */
	int	pdft, psft;

	FUNC	*funcd, *funcs;

} TABLECOPY;

				/*-------------------------------------------*/

				/* TABLERA data structure used by tablera
				 * subroutine.
				 */	
typedef struct {

				/* Opcode data structure - see CS.H.
				 */
	OPDS	h;
				/* Pointer to output argument:
				 *
				 * adest	A rate destination for the 
				 *		ksmps floats read from the 	
				 * 		table.
				 *
				 * Pointers to input arguments. 
				 *
				 * kfn		Number of table we are
				 * 		reading from.
				 *
				 * kstart	Index mode within table from
				 *		which we start reading.
				 *
				 * koff		Offset to add to table 
				 *		index.
				 */

	float	*adest, *kfn, *kstart, *koff;

				/* Internal variable for previous state
				 * of xfn.
				 */
	long	pfn;
	
				/* Pointer to data structure used to access 
				 * function table. See CS.H.  
				 */
	FUNC	*ftp;
				

} TABLERA;

				/*-------------------------------------------*/

				/* TABLEWA data structure used by tablewa
				 * subroutine.
				 */	
typedef struct {

				/* Opcode data structure - see CS.H.
				 */
	OPDS	h;
				/* Pointer to output argument:
				 *
				 * kstart	Index mode within table from
				 *		which we start reading.
				 *
				 *		Note this is also an input
				 *		argument.  First we read it
				 *		to determine where we should
				 *		start writing the a rate
				 *		samples. When we have finished
				 *		we write to it the number of
				 *		the next location which should
				 *		be written.
				 *
				 * Pointers to input arguments. 
				 *
				 * kfn		Number of table we are
				 * 		reading from.
				 *
				 * asig		a rate input signal.
				 *
				 * koff		Offset to add to table 
				 *		index.
				 */

	float	*kstart, *kfn, *asig, *koff;

				/* Internal variable for previous state
				 * of xfn.
				 */
	long	pfn;
	
				/* Pointer to data structure used to access 
				 * function table. See CS.H.  
				 */
	FUNC	*ftp;
				

} TABLEWA;




/*****************************************************************************/

				/* Data structures for the zak family of 
				 * ugens for patching data at i, k or a rates.
				 *
				 * See also four global variables declared in
				 * the C code.
				 */


				/* ZAKINIT data structure for zakinit().
				 */	
typedef struct {
				/* Opcode data structure - see CS.H.
				 */
	OPDS	h;
				/* Two pointers to input arguments. 
				 *
				 * isizea  	Number of a locations, each an
				 *		array of ksmps long, to 
				 *		to reserve for a rate patching.
				 *	
				 * isizek	Number of locations for i or k
				 *		rate variables.
				 * 
				 */

	float	*isizea, *isizek;

} ZAKINIT;

				/* ZKR data structure for zir() and zkr().
				 */	
typedef struct {
				/* Opcode data structure - see CS.H.
				 */
	OPDS	h;
				/* Pointers to floats. 
				 *
				 * rslt		Where to write the value which
				 *		we read from the zk location.
				 *
				 * ndx		Input argument: 
				 *		Location in zk space to read.
				 */

	float	*rslt, *ndx;

} ZKR;


				/* ZKW data structure for ziw() and zkw().
				 */	
typedef struct {
				/* Opcode data structure - see CS.H.
				 */
	OPDS	h;
				/* Two pointers to float input arguments. 
				 *
				 * sig		Value to write.
				 *
				 * ndx		Locations to read.
				 */

	float	*sig, *ndx;

} ZKW;

				/* ZKWM data structure for ziwm() and zkwm().
				 */	
typedef struct {
				/* Opcode data structure - see CS.H.
				 */
	OPDS	h;
				/* Three pointers to float input arguments. 
				 *
				 * sig		Value to write.
				 *
				 * ndx		Locations to read.
				 *
				 * mix		0 for write directly,
				 *		!0 for mix - add to the 
				 *		current value in the variable.
				 */

	float	*sig, *ndx, *mix;

} ZKWM;

				/* ZKMOD data structure for zkmod().
				 */	
typedef struct {
				/* Opcode data structure - see CS.H.
				 */
	OPDS	h;

				/* Pointers to floats:
				 *
				 * rslt		Points to where to write
				 *		output.  
				 * 
				 * Two pointers to float input arguments. 
				 *
				 * sig		Value to modulate.
				 *
 				 * zkmod	Which zk variable to use
				 *		to modulate sig.
				 */

	float	*rslt, *sig, *zkmod;

} ZKMOD;

				/* ZKCL data structure for zkcl().
				 */	
typedef struct {
				/* Opcode data structure - see CS.H.
				 */
	OPDS	h;
				/* Two pointers to float input arguments. 
				 *
				 * first	First variable to clear.
				 *
				 * last		Final variable to clear.
				 */

	float	*first, *last;

} ZKCL;



				/* ZAR data structure for zar().
				 */	
typedef struct {
				/* Opcode data structure - see CS.H.
				 */
	OPDS	h;
				/* Pointers to floats. 
				 *
				 * rslt		Where to write the value which
				 *		we read from the zk location.
				 *
				 * ndx		Input argument: 
				 *		Location in za space to read.
				 *		
				 *		These both point to arrays
				 *		of a rate variables - arrays
				 *		ksmps long.
				 */

	float	*rslt, *ndx;

} ZAR;


				/* ZARG data structure for zarg().
				 */	
typedef struct {
				/* Opcode data structure - see CS.H.
				 */
	OPDS	h;
				/* Pointers to floats. 
				 *
				 * rslt		Where to write the value which
				 *		we read from the zk location.
				 *
				 * ndx		Input argument: 
				 *		Location in za space to read.
				 *		
				 *		These both point to arrays
				 *		of a rate variables - arrays
				 *		ksmps long.
				 *
				 * kgain	What to multiply the a rate 
				 *		signal by as we read it.
				 */

	float	*rslt, *ndx, *kgain;

} ZARG;


				/* ZAW data structure for zaw().
				 */	
typedef struct {
				/* Opcode data structure - see CS.H.
				 */
	OPDS	h;
				/* Two pointers to float input arguments. 
				 *
				 * sig		Value to write.
				 *
				 * ndx		Locations to read.
				 *
				 *		These both point to arrays
				 *		of a rate variables - arrays
				 *		ksmps long.
				 */
	float	*sig, *ndx;

} ZAW;


				/* ZAWM data structure for zawm().
				 */	
typedef struct {
				/* Opcode data structure - see CS.H.
				 */
	OPDS	h;
				/* Two pointers to float input arguments. 
				 *
				 * sig		Value to write.
				 *
				 * ndx		Locations to read.
				 *
				 *		These both point to arrays
				 *		of a rate variables - arrays
				 *		ksmps long.
				 *
				 * mix		0 for write directly,
				 *		!0 for mix - add to the 
				 *		current values in the variable.
				 */

	float	*sig, *ndx, *mix;

} ZAWM;

				/* ZAWOD data structure for zamod().
				 */	
typedef struct {
				/* Opcode data structure - see CS.H.
				 */
	OPDS	h;

				/* Pointers to floats:
				 *
				 * rslt		Points to where to write
				 *		output.  
				 * 
				 * Two pointers to float input arguments. 
				 *
				 * sig		Value to modulate.
				 *
 				 * zamod	Which za variable to use
				 *		to modulate sig.
				 */

	float	*rslt, *sig, *zamod;

} ZAMOD;

				/* ZACL data structure for zacl().
				 */	
typedef struct {
				/* Opcode data structure - see CS.H.
				 */
	OPDS	h;
				/* Two pointers to float input arguments. 
				 *
				 * first	First variable to clear.
				 *
				 * last		Final variable to clear.
				 */

	float	*first, *last;

} ZACL;


/*****************************************************************************/
				
				/* RDTIME data structure for timek(), times(),
				 * instimset(), instimek() and instimes().
				 */

typedef struct {
				/* Opcode data structure - see CS.H.
				 */
	OPDS	h;

				/* Only one I/O variable - a pointer to 
				 * where to put the result.
 				 */
	float 	*rslt;

				/* One local variables for the instime srs.
				 *	
				 * instartk	Int to remember what the 
				 *		k counter was when this 
				 *		instance of the instrument
				 *		was initialised.		
				 */
	long	instartk;

} RDTIME;


/*****************************************************************************/
				
				/* PRINTK data structure for printk() and 
				 * printkset().
				 */

typedef struct {
				/* Opcode data structure - see CS.H.
				 */
	OPDS	h;

				/* No output variables.
				 *
				 * Three input variables:
				 *
				 * ptime	How much time to 
				 *		leave between each
				 *		print - we generally do
				 *		not want it printing on 
				 *		every k cycle, but make it
				 *		0 if we do.	
				 *	
				 *		Time is in seconds, referenced
				 *		to the absolute time and 
				 *		starting on the k cycle when 
				 *		this ugen is initialised.
				 *
				 * val		Value to print.
				 *
				 * space	Spaces to insert before 
				 *		printing it so that it is 
				 *		easier to see variables
				 *		from different kprint
				 *		instances when looking
				 *		at the screen.
 				 */

	float 	*ptime, *val, *space;

				/* Local variables:
				 * 
				 * initime	Time when this instance was
				 *		initialised.
				 *		
				 * ctime	Cycle time - positive copy of
				 *		*ptime above.	
				 */
	float	initime, ctime;

				/* pspace	How many spaces to print before
				 *		the value.
				 *
				 * cysofar	Number of print cycles so far 
				 *		- where the first one is 0.
				 */
	long	pspace, cysofar;

} PRINTK;


				/* PRINTKS data structure for printks() and 
				 * printksset().
				 */

typedef struct {
				/* Opcode data structure - see CS.H.
				 */
	OPDS	h;

				/* No output variables.
				 * Pointers to four input variables:
				 *
				 * ifilcod	Contains magic number
				 *		sstrcod = SSTRCOD = 0xFFFFFF
				 *		if a string is in quotes for
				 *		the first parameter.  
				 *
				 *		The string itself is pointed
				 * 		to by something more abstruse
				 *		see printks().
				 *
				 * ptime	How much time to 
				 *		leave between each
				 *		print - see notes for PRINTK
				 *
				 * kval1-4	K rate values to print.
 				 */

	float 	*ifilcod, *ptime, *kval1, *kval2, *kval3, *kval4;

				/* Local variables:
				 * 
				 * initime	Time when this instance was
				 *		initialised.
				 *		
				 * ctime	Cycle time - positive copy of
				 *		*ptime above.	
				 */
	float	initime, ctime;

				/* cysofar	Number of print cycles so far 
				 *		- where the first one is 0.
				 */
	long	cysofar;

				/*	
				 * txtsting[]	Place to store the string
				 *		which will be printed.
				 *		printks() writes this.
			 	 * 		Make it nice and long!	
				 */
	char	txtstring[260];	


} PRINTKS;

