/*								UGRW2.H	*/

/*
 *	Unit generators by Robin Whittle 		9 September 1995
 *
 *	Header file containing data structures for UGRW2.C.
 */

					/* KPORT data structure.
					 *
					 * Output and input pointers.
					 *
					 * kr		To k rate result.
 					 *
					 * ksig		k rate input.
					 *
					 * khtim	k rate half time
					 *
					 * isig		Initial value for
					 * 		internal state.
					 */					
typedef	struct {
	OPDS	h;
	float	*kr, *ksig, *khtim, *isig;
					
					/* Internal variables.
					 *
					 * c1 		Value to multiply with
					 *		input value.
					 *
					 * c2		Value to multiply with
					 *		previous state.
					 *
					 * yt1		Previous state.
					 *
					 * prvhtim	Previous khtim.
					 */
	float	c1, c2, yt1, prvhtim;
} KPORT;


					/*************************************/

					/* KTONE data structure.
					 *
					 * For ktone and katone.
					 *
					 * Output and input pointers.
					 *
					 * kr		To k rate result.
 					 *
					 * ksig		k rate input.
					 *
					 * khp		k rate half power
					 *		frequency input.
					 *
					 * isig		Set to 0 to clear 
					 * 		internal state.
					 */
					
typedef struct {
	OPDS	h;
	float	*kr, *ksig, *khp, *istor;

					/* Internal variables.
					 *
					 * c1 		Value to multiply with
					 *		input value.
					 *
					 * c2		Value to multiply with
					 *		previous state.
					 *
					 * yt1		Previous state - just
					 * 		one float, used
					 *		between calculations
					 *		in the array, and for
					 *		storing state between
					 *		k cycles.
					 *
					 * prvhp	Previous half power
					 *		frequency.
					 */
	float	c1, c2, yt1, prvhp;
} KTONE;



					/*************************************/

					/* KRESON data structure.
					 *
					 * For kreson and kareson.
					 *
					 * Output and input pointers.
					 *
					 * kr		To k rate result.
 					 *
					 * ksig		k rate input.
					 *
					 * kcf		k rate centre freq.
					 *
					 * kbw		k rate bandwidth
					 *
					 * iscl		i rate scaling factor
					 *		0, 1 or 2.
					 *
					 * istor	Set to 0 to clear 
					 * 		internal state.
					 */
typedef	struct {
	OPDS	h;
	float	*kr, *ksig, *kcf, *kbw, *iscl, *istor;
					
					/* Integers:
					 *
					 * scale	Copy of istor
					 */
	int     scale;
					/* c1, c2, c3 	Filter factors
					 *
					 * yt1		Delay 1 k sample
					 *	
					 * yt2		Delay 2 k samples
					 *
					 * cosf		Intermediate variable
					 *		to help calculations.
					 *		
					 * prvcf, prvbw	Previous centre freq
					 *		and bandwidth.
					 */

	float	c1, c2, c3, yt1, yt2, cosf, prvcf, prvbw;
} KRESON;


					/*************************************/
					
					/* LIMIT data structure.
					 *
					 * For ilimit(), klimit() and limit().
					 */
typedef struct {
	OPDS	h;
					/* xdest	Pointer to destination
					 *		- i, k or a rate.
					 *
					 * xsig		Pointer to input value
					 *		- i, k or a rate.
					 *
					 * xlow		Limits - i or k rate.
					 * xhigh
					 *
					 */ 

	float	*xdest, *xsig, *xlow, *xhigh;

} LIMIT;

 