/* 
 * this module contains everythings relating to the gui and to 
 * preset storage and retreaval.
 * most code is borrowed from markus spitzer.
 */


#include <stdio.h>
#include <stdlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Cardinals.h>	
#include <X11/Xlib.h>	
#include <midi.h>
#include <midiio.h>
#include <malloc.h>
#include "main.h"
#include "utils.h"
#include "generate.h"
#include "synthesis.h"
#include "random.h"
#include "faders.h"

#define MAXPARAM 100

XtAppContext app_con;
Widget toplevel, scrollbar;
Widget frame, butns, presets, names, quit, save, load;
Widget button[32], presetButton[32];
Display *display;
Window window;
XtInputId input_id;
MIport *mport;
MIevent e[1];
int MIDIreceiveChannel = 0; 
MIconfig *c;
u_int pbuf[2];

float preset[32][32];
		
static void Jumped();
static void presetCallback();
static void read_midi();
static void standardCallback();
static void Quit();
static void Save();
static void Load();
static XrmOptionDescRec options[] = {
{"-horiz",	"scrollbar.orientation", XrmoptionNoArg,  "horizontal"}
};

String fallback_resources[] = {
	"*faders.defaultDistance:	0",
	"*fader.defaultDistance:	0",
	"*fader.borderWidth:	0",
	"*fader.control.width:	50",
	"*fader.control.bottom:	ChainBottom",
	"*fader.value.width:	50",
	"*fader.value.top:	ChainBottom",
	"*fader.value.bottom:	ChainBottom",
	"*frame.faders.top:	ChainTop",
	"*frame.butns.top:	ChainTop",
	"*frame.butns.bottom:	ChainTop",
	"*frame.butns.right:	ChainLeft",
	"*frame.butns.left:	ChainLeft",
	"*butns.orientation:	horizontal",
	"*frame.presets.top:	ChainTop",
	"*frame.presets.bottom:	ChainTop",
	"*presets.orientation:	vertical",
	"*presets.presetButton.width: 50",
	"*background:           light gray",
	"*shadowColor:     	light gray",
	"*Command.background:  	light gray",
	"*Command.shadowColor: 	light gray",
	"*highlightThickness:  	1",
	"*TopShadowContrast:  	9",
	"*BottomShadowContrast: 39",
	"*Command.shadowWidth:  3",
	"*Box.vSpace:   	0",
	"*Box.hSpace:   	0",
	"*Scrollbar.borderWidth: 1",
	"*control.height: 1000",
	"*overview.height: 1000",
	NULL,
};


float param[MAXPARAM];
float fine[MAXPARAM];
Widget fader[MAXPARAM], faders, value[MAXPARAM], control[MAXPARAM];
Widget name[MAXPARAM];
Widget overview;

void setup_faders()
{	XtArgVal *l_top;
	float top;
	Arg args[5];
	Cardinal num_args;
	int i;
	char string[512];
	char namestr[512];

	frame = XtCreateManagedWidget("frame", formWidgetClass, toplevel, NULL, NULL);
	display = XtDisplay (frame);
	window = XtWindow (frame);
	butns = XtCreateManagedWidget("butns", boxWidgetClass, frame, NULL, NULL);
	names = XtCreateManagedWidget("names", boxWidgetClass, frame, NULL, NULL);
	quit = XtCreateManagedWidget("quit", commandWidgetClass, butns, NULL, NULL);
	save = XtCreateManagedWidget("save", commandWidgetClass, butns, NULL, NULL);
	load = XtCreateManagedWidget("load", commandWidgetClass, butns, NULL, NULL);
	for (i = 0; i < buttons_count; i++)
	{	button[i] = XtCreateManagedWidget(button_name[i], commandWidgetClass, butns, NULL, NULL);
		XtAddCallback(button[i], XtNcallback, standardCallback, NULL);
	}
	XtAddCallback(quit, XtNcallback, Quit, NULL);
	XtAddCallback(save, XtNcallback, Save, NULL);
	XtAddCallback(load, XtNcallback, Load, NULL);
	XtSetArg(args[0], XtNfromVert, butns );
	faders = XtCreateManagedWidget("faders", formWidgetClass, frame, args, ONE);
    	for (i=0;i<faders_count;i++) {
		param[i]=1.0;
		if (i>0) {
			XtSetArg(args[0], XtNfromHoriz, fader[i-1] );
		} else {
			XtSetArg(args[0], XtNfromHoriz, overview );
		};
    		/*XtSetArg(args[1], XtNborderWidth, 0);*/
		fader[i] = XtCreateManagedWidget("fader", formWidgetClass, faders, args, ONE);
    		XtSetArg(args[0], XtNlength, 1000);
		control[i] = XtCreateManagedWidget("control", scrollbarWidgetClass, fader[i], args, ONE);
		sprintf(string,"%1.3f",param[i]);
    		XtSetArg(args[0], XtNlabel, string);
		XtSetArg(args[1], XtNfromVert, control[i] );
		value[i] = XtCreateManagedWidget("value", labelWidgetClass, fader[i], args, TWO);
		sprintf(namestr, "name%d", i);
		name[i] = XtVaCreateManagedWidget(namestr,
			labelWidgetClass, fader[i], 
			XtNfromVert, value[i],
			XtNlabel, fader_name[i],
			NULL);
		XtAddCallback(control[i], XtNjumpProc, Jumped, NULL);
	}
	XtSetArg(args[0], XtNfromHoriz, faders );
	XtSetArg(args[1], XtNfromVert, butns );
	XtSetArg(args[2], XtNlength, 1000);
	presets = XtCreateManagedWidget("presets", boxWidgetClass, frame, args, THREE);
	for (i = 0; i < 32; i++)
	{	sprintf (string, "%d", i);
		XtSetArg(args[0], XtNwidth, 50);
		presetButton[i] = XtCreateManagedWidget (string, commandWidgetClass, presets, args, ONE);
		XtAddCallback(presetButton[i], XtNcallback, presetCallback, NULL);
	}
    	c = MInewconfig();
        pbuf[0] = MI_STAMPING;
        pbuf[1] = MIRELSTAMP;
        MIsetparams(&c, pbuf, 2);
        mport = MInewport();
        if ((MIopen (mport, "r", &c)) == -1) 
		printf ("MIDI server not running - MIDI is not available\n");
	input_id = XtAppAddInput(
		app_con, MIgetfd(mport), (XtPointer)XtInputReadMask,
		read_midi, NULL );
	XtRealizeWidget(toplevel);
}

static void Jumped(w, closure, call_data)
	Widget w;
	XtPointer closure, call_data;
{
	char string[512];
	Arg args[5];
	int i;
	int pnumber= -1;
	float wert;
	float top = *((float *) call_data);
	static Widget lastw=NULL;
	static int lastp= -1;

	wert=1-top;
	if (w==lastw) pnumber=lastp;
	else
		for (i=0;i<faders_count;i++) {
			if (w==control[i]) {
				pnumber=i;
				lastp=pnumber;
				lastw=control[i];
				break;
			};
		};
	fader_value[pnumber] = map (0., 1., 
		fader_min[pnumber], fader_max[pnumber], wert);
	sprintf(string,"%1.3f",fader_value[pnumber]);
    	XtSetArg(args[0] , XtNlabel, string);
	XtSetValues(value[pnumber], args, ONE);

	update();
}

int shiftKey()
{	char keys_return[32];
	XQueryKeymap (display, keys_return);
	if (keys_return[3] == 4) return 1;
	else return 0;
}

int altKey()
{	char keys_return[32];
	XQueryKeymap (display, keys_return);
	if (keys_return[4] == 2) return 1;
	else return 0;
}

void markPreset(int i)
{	char string[512];
	Arg args[5];
	sprintf (string, ">%d<", i);
	XtSetArg(args[0], XtNwidth, 50);
	XtSetArg(args[1] , XtNlabel, string);
	XtSetValues(presetButton[i], args, TWO);
}

void unmarkPreset(int i)
{	char string[512];
	Arg args[5];
	sprintf (string, "%d", i);
	XtSetArg(args[0], XtNwidth, 50);
	XtSetArg(args[1] , XtNlabel, string);
	XtSetValues(presetButton[i], args, TWO);
}

static void presetCallback(w, closure, call_data)
	Widget w;
	XtPointer closure, call_data;
{	int i;
	for (i = 0; presetButton[i] != w; i++);
	presetAction(i);
}

void setFloatValue(w, resourcename, new_val)
        Widget w;
        String resourcename;
        float new_val;
{
        Arg args[1];
        union { int int_val; float float_val; } val;

        /* XtVaSetValues darf nicht mit floats verwendet werden!!!
        Siehe O'R Vol. Four, S. 46 ( Note ... ).
        Daher diese ziemlich umstaendliche Konstruktion!.
        */

        val.float_val = new_val;
        XtSetArg(args[0], resourcename, val.int_val);
        XtSetValues(w, args, 1);
}

void display_fader_value(int i, float v)
{ 	setFloatValue(control[i], XtNtopOfThumb, map (fader_min[i], 
			fader_max[i], 1., 0., v));
}

void flushDisplay() 
{	XFlush(display); 
}

void init_faders()
{	int i;
	char string[512];
	float f;
	Arg args[5];
	for (i = 0; i < faders_count; i++)
	{	setFloatValue(control[i], XtNtopOfThumb, map (fader_min[i], 
			fader_max[i], 1., 0., fader_value[i]));
		XtVaGetValues(control[i], XtNtopOfThumb, &f, NULL);	
		sprintf(string,"%1.3f",fader_value[i]);
    		XtSetArg(args[0] , XtNlabel, string);
		XtSetValues(value[i], args, ONE);
	}
}

static void read_midi( client_data, fid, id )
	XtPointer client_data;
	int *fid;
	XtInputId *id;
{
	int retval;
        MImessage msg;
        MIevent e[1];
	char	label[200];
	char	str[50];
	int zahl;

	if ((retval = MIreceive (mport, e, 1)) < 0) exit (-1);
        if (retval)
        {       msg = e->mm.msgbuf;
                if ((MIbyte1 (msg) < faders_count) && 
		    (MIchannel (msg) == MIDIreceiveChannel)) {
		  fader_value[MIbyte1(msg)] = 
		    map (	0, 127,
				fader_min[MIbyte1(msg)],
				fader_max[MIbyte1(msg)],
				MIbyte2(msg)
				);
		  update();
		  init_faders();
		}
	}
}



static void Quit(w, closure, call_data)
{
  exit(1);
}


static void Save(w, closure, call_data)
	Widget w;
	XtPointer closure, call_data;
{	FILE *file;
	int i, p;
	char string[512];
	printf ("save settings in file: ");
	scanf ("%s", string);
	if (file = fopen (string, "w"))
	{	for (i = 0; i < faders_count; i++) /* augenblickliche Stellung */
			fprintf (file, "%3.3f ", fader_value[i]);
		fprintf (file, "\n");
		for (p = 0; p < 32; p++) /* alle Presets */
		{	for (i = 0; i < faders_count; i++)
				fprintf (file, "%3.3f ", preset[p][i]);
			fprintf (file, "\n");
		}
	}	
	else printf ("error\n");
	fclose (file);
}

static void Load(w, closure, call_data)
	Widget w;
	XtPointer closure, call_data;
{	FILE *file;
	int i, p, occupied;
	char string[512];
	printf ("load settings from file: ");
	scanf ("%s", string);
	if (file = fopen (string, "r"))
	{	for (i = 0; i < faders_count; i++)
		 	fscanf (file, "%f", fader_value + i); 
                for (p = 0; p < 32; p++) /* all Presets */
                        for (i = 0; i < faders_count; i++)
                        {	preset[p][i] = 0.;
			        fscanf (file, "%f\n", &(preset[p][i]));
			}
		for (p = 0; p < 32; p++) /* all Presets */
		{	occupied = 0;
			for (i = 0; i < faders_count; i++)
				if (preset[p][i]) occupied = 1;
			if (occupied) markPreset(p);
			else unmarkPreset(p);
		}
		init_faders();
		update();
	}
	else printf ("error\n");
	fclose (file);
}

static void standardCallback(w, closure, call_data)
	Widget w;
	XtPointer closure, call_data;
{	int i;
	for (i = 0; ((button[i] != w) && (i < buttons_count)); i++); 
	button_callback[i]();
}


