/* 
 * forks a subprocess that polls for requests to fill up audio-queue. 
 * an alternative solution is in generate.alternative.c. it does not
 * fork a subprocess, but instead registers the audioport as an 
 * entry to the x mainloop. 
 * due to the large buffersizes used here, the threaded version seems 
 * to work better, and it doesn't cost more, it turns out.
 */


#include <stdio.h>
#include <sys/types.h>
#include <math.h>
#include <audio.h>
#include <signal.h>
#include <sys/schedctl.h>
#include <ulocks.h>
#include <stropts.h>
#include <poll.h>
#include <sys/prctl.h>
#include <ulocks.h>
#include <errno.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Cardinals.h>	
#include "faders.h"
#include "main.h"
#include "synthesis.h"

ALport port;
ALconfig config;
struct pollfd PollFD[1];

extern int xplotinit();
extern int xplotdata();

void generate(void *v)
{	int pid;
	long pvbuf[4];
	pvbuf[0] = AL_OUTPUT_RATE;
	pvbuf[2] = AL_OUTPUT_COUNT;
	ALgetparams(AL_DEFAULT_DEVICE, pvbuf, 4);
	if (samplerate) 
	{	if (pvbuf[1] != samplerate) 
		{	if (pvbuf[3] > 0) printf ("Samplerate mismatch\n");
			else 
			{	pvbuf[1] = samplerate;
				printf ("attemmting to set output samplerate to %d Hz\n", samplerate);
				ALsetparams(AL_DEFAULT_DEVICE, pvbuf, 2);
	}	}	}
	else samplerate = pvbuf[1];
 	config = ALnewconfig();
	ALsetqueuesize(config, queuesize);
	ALsetchannels(config, nochannels);
	ALsetsampfmt(config, AL_SAMPFMT_FLOAT);
	ALsetfloatmax(config, 1.0);
	port = ALopenport("granular","w",config);
	pid = getpid();
	schedctl(NDPRI,pid,NDPHIMIN);
	
	PollFD[0].fd = ALgetfd(port);
	PollFD[0].events = POLLOUT;
	
	ALsetfillpoint(port,fillpoint);

	while(1)
	{	poll(PollFD,1,-1);
		if (PollFD[0].revents&POLLOUT)
		{	beforeWritesamps();
			ALwritesamps(port,flbuf,bufsize);
			afterWritesamps();
}	}	}

play_init(){

	usptr_t *arena;
	static short signum=9;

	usconfig(CONF_ARENATYPE,US_SHAREDONLY);
	arena=usinit(tmpnam(0));

	prctl(PR_SETEXITSIG, (void *) signum);
	sproc(generate,PR_SALL);

}

update()
{	mapping();
}

play_stop()
{	ALfreeconfig(config);
	ALcloseport(port);
	exit(0);
}

