/* 
 * soundfile access. based on sgi aiff lib 
 */




#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <audiofile.h>
#include "main.h"

char path[256];
	
/* sucht ein aiff-file mit Namen name im aktuellen Verzeichnis oder im 
SFDIR-Verzeichnis des Anwenders. Laedt das Soundfile in RAM, 
konvertiert in floats in einem -1 bis 1- Bereich und blockiert
die betroffenen Mempages vom Swappen (sofern moeglich); 
liefert die Adresse eines float-Puffer mit allen Samples aller Kanaele 
(interleaved) oder NULL bei Scheitern. 
Legt die Zahl der Sample-Frames, die Zahl der Kanaele und die Samplerate wie 
im Soundfile verzeichnet in nframes, nchannels und srate ab. */
float *getsoundfile (char* name, int* nframes, int* nchannels, int* srate)
{	float *soundstart;
	short *sf_shorts;
	int i, ch;
	char *sfdir;
	int nsamps;
	int fd;
	AFfilehandle file;
	if ((fd = open (name, O_RDONLY)) == -1) /* sucht im aktuellen Verzeichnis */
	{	if (!(sfdir = getenv ("SFDIR"))) 
		{	printf ("can't open soundfile %s in current directory. SFDIR environment variable not set.\n", name);
			return NULL;
		}
		sprintf (path, "%s/%s", sfdir, name);
		if ((fd = open (path, O_RDONLY)) == -1)
		{	perror (name);
			return NULL;
		}
		printf ("using %s\n", path);
	}	
	file = AFopenfd (fd, "r", 0);
	*srate = AFgetrate (file, AF_DEFAULT_TRACK);
	*nchannels = AFgetchannels (file, AF_DEFAULT_TRACK);
	*nframes = AFgetframecnt (file, AF_DEFAULT_TRACK);
	nsamps = *nchannels * *nframes;
	if (!(sf_shorts = (short*) malloc (nsamps * sizeof (short))))
	{	printf ("insufficient memory space for short-sample buffer\n");
		return NULL;
	}
	if (!(soundstart = (float*) malloc (nsamps * sizeof (float))))
	{	printf ("insufficient memory space for float-sample buffer\n");
		return NULL;
	}
	if (mpin (soundstart, nsamps * sizeof (float)) == -1)
	{	printf ("can't lock memory pages for soundfile-buffer\n");
	}
	printf ("loading samples.. ");
	AFreadframes (file, AF_DEFAULT_TRACK, sf_shorts, *nframes);
	printf (" done.\nconverting shortsamples to floatsamples..");
	for (i = 0; i < nsamps; i++) /* short nach float */
		soundstart[i] = ((float) sf_shorts[i]) / 32767.0;
	printf (" done.\n");
	free (sf_shorts);
	return soundstart;
}
	
void drawSoundFileInOverview (char* name)
{	int fd;
	char *sfdir;
	if ((fd = open (name, O_RDONLY)) == -1) /* sucht im aktuellen Verzeichnis */
	{	if (!(sfdir = getenv ("SFDIR"))) 
			printf ("can't open soundfile %s in current directory. SFDIR environment variable not set.\n", name);
		if ((fd = open (path, O_RDONLY)) == -1)
			perror (name);
		printf ("using %s\n", path);
	}	
}

/* sucht ein aiff-file mit Namen name im aktuellen Verzeichnis oder im 
SFDIR-Verzeichnis des Anwenders. Laedt das Soundfile in RAM, 
konvertiert in floats in einem -1 bis 1- Bereich und blockiert
die betroffenen Mempages vom Swappen (sofern moeglich); 
liefert die Adresse eines Arrays von Zeigern auf die float-Puffer der einzelnen
Kanaele (maximal 4) oder NULL bei Scheitern. 
Legt die Zahl der Sample-Frames, die Zahl der Kanaele und die Samplerate wie 
im Soundfile verzeichnet in nframes, nchannels und srate ab. */
float **getsoundfile_deinterleaved (char* name, int* nframes, int* nchannels, int* srate)
{	float *channel_data[4];
	short *sf_shorts;
	int i, ch;
	char *sfdir;
	char path[256];
	int nsamps;
	int fd;
	AFfilehandle file;
	if ((fd = open (name, O_RDONLY)) == -1) /* sucht im aktuellen Verzeichnis */
	{	if (!(sfdir = getenv ("SFDIR"))) 
		{	printf ("can't open soundfile %s in current directory.\nSFDIR environment variable not set\n", name);
			return NULL;
		}
		sprintf (path, "%s/%s", sfdir, name);
		printf ("%s not present in working directory.\nattempt to open from %s ", name, sfdir);
		if ((fd = open (path, O_RDONLY)) == -1) {
		  printf ("failed.\n");
		  return NULL;
		}
		else printf ("successfull.\n");
	}	
	if (!(file = AFopenfd (fd, "r", 0))) return NULL;
	*srate = AFgetrate (file, AF_DEFAULT_TRACK);
	*nchannels = AFgetchannels (file, AF_DEFAULT_TRACK);
	*nframes = AFgetframecnt (file, AF_DEFAULT_TRACK);
	nsamps = *nchannels * *nframes;
	if (!(sf_shorts = (short*) malloc (nsamps * sizeof (short))))
	{	printf ("insufficient memory space for short-sample buffer\n");
		return NULL;
	}
	for (ch = 0; ch < *nchannels; ch++)
	{	if (!(channel_data[ch] = (float*) malloc (nsamps * sizeof (float))))
		{	printf ("insufficient memory space for float-sample buffer\n");
			return NULL;
		}
		if (mpin (channel_data[ch], nsamps * sizeof (float)) == -1)
		{	printf ("can't lock memory pages for soundfile-buffer\n");
		}
	}
	printf ("loading samples.. ");
	AFreadframes (file, AF_DEFAULT_TRACK, sf_shorts, *nframes);
	printf (" done.\nconverting shortsamples to floatsamples..");
	for (ch = 0; ch < *nchannels; ch++)
		for (i = 0; i < *nframes; i++) /* short nach float */
			*(channel_data[ch] + i) = 
				((float) sf_shorts[i * *nchannels]) / 32767.0;
	printf (" done.\n");
	free (sf_shorts);
	return channel_data;
}
	
