/* 
 * this module contains everything specific to the synthesis method used 
 */ 


#include <stdio.h>
#include <stdlib.h> 
#include <assert.h>
#include <sys/types.h>
#include <math.h>
#include <audio.h>
#include <audiofile.h>
#include <signal.h>
#include <sigfpe.h>
#include <sys/schedctl.h>
#include <ulocks.h>
#include <stropts.h>
#include <poll.h>
#include <sys/prctl.h>
#include <ulocks.h>
#include <errno.h>
#include <fcntl.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Cardinals.h>	

#include "faders.h"
#include "soundfile.h"
#include "random.h"
#include "utils.h"
#include "main.h"
#include "generate.h"

#define BUFSIZE 16384 
#define TIMEPERBUF 8192 /* Anzahl der Outputframes pro Buffer (= BUFSIZE / NOOUTPUCHANNELS) */

#define BIGBUFSIZE 131072 /* Der Puffer ist um eine Zweierpotenz groesser als ein 
Block, der an den Audioport uebergeben wird. Ein Grain kann also laenger sein 
als BUFSIZE und gegebenenfalls vorausberechnet werden. Die Reaktionszeit der 
Synthese leidet nicht darunter. */

#define BUFMASK 0x1ffff /* Bitmaske, die bei AND alle Bits ausblendet, 
	die hoeher als BUFSIZE liegen */

#define MIN_DURATION 30
#define MAX_DURATION 8000


int 	bufsize = BUFSIZE;
int 	samplerate = 0;
int 	queuesize = 18432;
int 	fillpoint = 2048; 

float 	bigbuf[BIGBUFSIZE];
float 	*flbuf = bigbuf; /* Aktuelle Stelle im Synthese-Puffer */
float 	workbench[32][BIGBUFSIZE]; /* Puffer zum Anfertigen von Grains */

int timeNow = TIMEPERBUF; /* Zeit seit Start der Programms in Outputframes.
Diese Zeit ist immer die Zeit am ENDE des aktuellen Buffers */
int transPending = 0; /* Flag gibt an, dass neue Transition stattfinden muss */
int syncPending = 0; /* Flag gibt an, dass gesynct werden muss */

#define NOOUTPUTCHANNELS 2
#define OUTCHANNELSHIFT 1 /* 	NOOUTPUTCHANNELS   ->	OUTCHANNELSHIFT
					1			0
					2			1
					4			2
					8			3	*/		
int nochannels = NOOUTPUTCHANNELS;

int buttons_count = 1; /* Anzahl der Tasten */
int faders_count = 23; /* Anzahl der Regler */
#define PARA_COUNT 22 /* Anzahl der Regler die Syntheseparameter steuern */

/* Synthese-Parameter */
float	nextGrain[32]; /* naechster Startzeitpunkt jeder Stimme */
float	lastGrainSf = 0; /* Punkt im Soundfile beim letzten Grain */
float	lastGrainSpeed = 0; /* Geschwindigkeit beim letzten Grain */
float 	lastGrainTime = 0; /* Zeitpunkt des letzten Grains (egal welche Stimme)*/
int	sfTransIsOver = 1; /* Flag gibt an, dass Transition der Geschwindigkeit
				vorbei ist. Wird vom ersten Grain gesetzt, das
				es "merkt" */
float 	sfRms; /* Durchschnittspegel des gesamten Soundfiles */
float 	sfMax; /* Maximale Amplitude des Soundfiles */
float 	speedMod, durMod; /* Einfluss der letzten Grain-Intensitaet auf 
		die Geschwindigkeit bzw die Dauer */
int 	sfsr = 0; /* Samplerate des Soundfiles */
int	nvoices; /* augenblickliche Anzahl der Stimmen */ 
int 	dispMode = 0; /* Flag fuer static mode */
int	t = 0; /* Zeit des naechsten grains, global wegen Effektivitaet */
float   overlap = 4.0; /* die durchschnittliche Anzahl sich uberlagernder grains. dieser 
			  parameter kann an die rechenkapazitaet der maschine angepasst
			  werden. */

float chromtable[500];

#define WINDOWSIZE 4096
float 	fwindow[WINDOWSIZE];

#define PI 3.1415927
void calcWindow() /* Hanning-Fenster */
{	int i;
	for (i = 0; i < WINDOWSIZE; i++) 
	{	fwindow[i] = .5 - .5 * cos ((float) i / (float) (WINDOWSIZE - 1) * 2. * PI);
	}
}


float 	*soundstart, *soundend;
int	fd;	
AFfilehandle file;
int	nsamps, nframes, nchannels;

/* Werte, Minimal-, Maximalwerte und Namen der Regler */
char 	*fader_name[32] = 
{"pos",	"dev",	"spd",	"stRG",	"stSP",	"l->s", "drFX",	"drRG",	"drSP",	"l->d",	"dtFX", "dtRG",	"dtSP",	"ptFX",	"ptRG",	"ptSP",	"novc", "fdbk", "tres",	"rtio", "amp",	"inrt", "slew"};
float 	fader_value[32] = /* 	Position der Fader auf dem Monitor 
 				= Zielwert der aktuellen Transition 	*/
{0.,	1.,	1., 	0.,	0.,	0.,	120,	.0,	0.,	0.,	0.,	0.,	0.,	1., 	0.,	0.,	1., 	0.,	0.3,	0.,	0.7,	0.,     170.};
float 	fader_min[32] = /* Minimaler Wert der Fader */
{0.,	0.,	-2.,	0.,	0.,	-50.,	57,	0,	0.,	-50.,	0,	0,	0.,	-4., 	0.,	0.,	0.,	-1.,	0,	-1.,	0.,	0.,     140.};
float 	fader_max[32] = /* Maximaler Wert der Fader */
{1.,	1.,	2., 	1.,	1.,	50.,	150,	1.0,	180.,	50.,	190,	190.,	180.,	4., 	1.,	4.,	10., 	1.,	1.,	1.,	4.,	1.,     300.};	
float 	fader_rnd[32] = /* Zufallsabweichung fuer Zufallsklaenge */
{0.,	0.,	0., 	0.,	0.,	0.,	0.,	0.,	0.,	0.,	0.,	0.,	0.,	0.,	0., 	0.,	0.,	0.,	0.,	0.,	0.,	0.,     0.};

float 	fader_prev_value[32]; /* Der vorhergehende Wert */
float 	fader_old_value[32]; /* Ausgangswert einer Transition */
float	fader_inc[32]; /* Veraenderung des Werts pro Outputframe */
float	fader_trans_beg[32]; /* Beginn der aktuellen Transition */ 
float	fader_trans_end[32]; /* Dauer der aktuellen Transition */
float   fader_last_rnd[32][32]; /* Letzter Zufallswert, der fuer den 
				   betreffenden Parameter in der betreffenden
				   Stimme verwendet wurde 
				   (also nur fuer RANGE-parameter) */


#define fader_now(faderno, now)\
((	(now < fader_trans_end[faderno]) \
	?	(fader_old_value[faderno] \
		+ (now - fader_trans_beg[faderno]) * fader_inc[faderno]) \
	:	fader_prev_value[faderno]\
))

float ilookup (float *table, float offset)
{	int idx = (int) offset;
	float remainder = offset - (float) idx;
	return table[idx] * (1. - remainder) + table[idx + 1] * remainder;
}

#define spread(faderno,t,v)\
(	fader_now(faderno,t) / fader_now(NVCS,t) * v\
)

#define POS 0
#define DEV 1
#define SPEED 2
#define STPTRNG 3
#define STPTSP 4
#define LTOSPEED 5
#define DUR 6
#define DURRNG 7
#define DURSP 8
#define LTODIST 9
#define DIST 10
#define DISTRNG 11
#define DISTSP 12
#define PITCH 13
#define PITCHRNG 14
#define PITCHSP 15
#define NVCS 16
#define FDBK 17
#define THRES 18
#define RATIO 19
#define AMP 20
#define INERTIA 21
#define SLEW 22

/* gibt den Faktor zur umrechnung von soundfilesr in systemsr */
#define SRCONVINV ((float) sfsr / (float) samplerate)

#define POSITIONNOW (fader_now(POS,t) * (float) nframes)
#define DEVIATIONNOW (fader_now(DEV,t) * (float) nframes)
#define SPEEDNOW (fader_now(SPEED,t))
#define STPTRANGENOW (fader_now(STPTRNG,t) * (float) nframes)
#define LTOSPEEDNOW (fader_now(LTOSPEED,t))
#define DURNOW (ilookup (chromtable, fader_now(DUR,t))) 
/* #define DURNOW (semitoneInHz (fader_now(DUR,t))) */
#define DURRANGENOW (ilookup (chromtable, fader_now(DURRNG,t)) - 1.)
#define DISTNOW (ilookup (chromtable, fader_now(DIST,t)))
#define DISTRANGENOW (ilookup (chromtable, fader_now(DISTRNG,t)) - 1.)
#define LTODISTNOW (fader_now(LTODIST,t))
#define PITCHNOW (fader_now(PITCH,t) - PITCHRANGENOW / 2.0)
#define PITCHRANGENOW ((float) fader_now(PITCHRNG,t))
#define FDBKNOW ((float) fader_now(FDBK,t))
#define THRESNOW ((float) fader_now(THRES,t))
#define RATIONOW ((float) fader_now(RATIO,t))
#define AMPNOW ((float) fader_now(AMP,t))
#define INERTNOW ((float) fader_now(INERTIA,t))


/* Liefert den Stand im Soundfile zum Zeitpunkt now; geht von konstanter 
Geschwindikeit zwischen und von konstanter Beschleunigung waehrend der 
Transitionen aus */
float sfnow(float now)
{	float dt = now - lastGrainTime;
	if (now <= fader_trans_end[SPEED])
	{	lastGrainSpeed = fader_now (SPEED,now) * speedMod;
		lastGrainSf += (lastGrainSpeed + .5 * SRCONVINV * 
				fader_inc[SPEED] * dt) * dt;	
		sfTransIsOver = 0;
	}
	else if (!(sfTransIsOver))
	/* erster Aufruf bei dem bemerkt wird dass Transition vorbei ist */
	{	lastGrainSf = sfnow (fader_trans_end[SPEED]);
		sfTransIsOver = 1;
	}
	else 
	{	lastGrainSpeed = fader_prev_value[SPEED] * SRCONVINV * speedMod;
		lastGrainSf += dt * lastGrainSpeed;
	}
	lastGrainTime = now;
	if (lastGrainSf < 0) lastGrainSf = nframes - 1;
	return lastGrainSf;	
}


/* Faltet den Soundfileindex fsf in den Bereich zwischen LOOP1 und LOOP2 */
float sfInLoop(float fsf, int t)
{	int sf = (int) fsf;
	float rem = fsf - (float) sf;
	int pos = POSITIONNOW;
	int dev = DEVIATIONNOW;
	if (dev == 0) return pos;
	if (lastGrainSpeed < 0) pos += dev;
	return (sf - pos) % dev + pos + rem;
}

void new_fader_trans(int faderno, int transDur)
{	float nowval = fader_now(faderno, timeNow);
	fader_inc[faderno] = (fader_value[faderno] - nowval) / transDur;
	fader_old_value[faderno] = nowval;
	fader_trans_beg[faderno] = timeNow;
	fader_trans_end[faderno] = timeNow + transDur;
	fader_prev_value[faderno] = fader_value[faderno];
}	

float drunkstep(faderno, voice) 
{
  return fader_last_rnd[faderno][voice] = (1. - INERTNOW) * fastrnd (fader_now (faderno,t)) + INERTNOW * fader_last_rnd[faderno][voice]; 
}

void resetf()
{	syncPending = 1;
}

/* Namen und Callback-Funktionen fuer Tasten */
char	*button_name[32] = 
{"resync"	};
void 	(*button_callback[32])() =
{resetf		};

void presetAction(int p)
{	int i;
	if (shiftKey()) 
	{	markPreset(p);
		for (i = 0; i < PARA_COUNT; i++) 
			preset[p][i] = fader_now(i, timeNow);
		preset[p][PARA_COUNT] = fader_value[PARA_COUNT];
	}
	else
	{	int empty = 1;
		float oldTime = fader_value[PARA_COUNT];
		for (i = 0; i < faders_count; i++) if (preset[p][i] != 0.)
			empty = 0;
		if (empty) 
		{	printf ("empty Preset - no update\n");	
			return;
		}

		for (i = 0; i < faders_count; i++) fader_value[i] = preset[p][i];
		if (altKey()) fader_value[PARA_COUNT] = oldTime;
		transPending = 1;
		init_faders();
	}
}

void mapping()
{	transPending = 1;	
}

void usage()
{       printf ("usage:\n");
        printf ("granular [options] aiff-soundfile\n");
        printf ("options: \n");
	printf ("-oOVERLAP set max grain density to OVERLAP \(defaults to 4.0\)\n");
	printf ("-cCHANNEL set MIDI receive channel to CHANNEL \(defaults to 0\)\n");
	printf ("-f enable fader animation \(use only with big computer\)\n");
}

/* liest soundfile in den Speicher. */
void init_synthesis()
{	int i;
	float f;
	float **s;
	char* arg_option;
	for (i = 0; i < BIGBUFSIZE; i++) bigbuf[i] = 0;
	calcWindow();
	if (argc < 2) 
	{	usage();
	        exit(-1);
	}
	if (argc > 2)
	  for (i = 1; i < (argc - 1); i++) {
	    if (argv[i][0] != '-') { usage(); exit (0); }
	    switch (argv[i][1]) {
	    case 'o' : arg_option=(&argv[i][2]); overlap = atoi(arg_option); break;
	    case 'c' : arg_option=(&argv[i][2]); MIDIreceiveChannel = atoi(arg_option); break;
	    case 'f' : arg_option=(&argv[i][2]); dispMode = 1;
	    }
	  }
	if (!(s = getsoundfile_deinterleaved (argv[argc - 1], &nframes, 
					      &nchannels, &sfsr))) {
	  printf ("error opening %s - exiting\n", argv[argc - 1]);
	  exit(0);
	}
	soundstart = s[0];
	soundend = soundstart + nframes;
	nframes -= 1;
	buildChromTable (chromtable, -1, 500);
	sfMax = 0.;
	for (i = 0; i < nframes; i++) 
	{	sfRms += soundstart[i] * soundstart[i];
		f = (soundstart[i] > 0) ? soundstart[i] : -soundstart[i];
		if (f > sfMax) sfMax = f;
	}
	sfRms = sqrt (sfRms / nframes);
	for (i = 0; i < 32; i++) 
		fader_prev_value[i] = fader_old_value[i] = fader_value[i];
	printf ("overlap set to: %f\nMIDI receive channel: %d\n", overlap, MIDIreceiveChannel);
	if (!dispMode) printf ("fader animation disabled.\n"); 
	else printf ("fader animation enabled.\n");
}	

/* schreibt ein grain und liefert den Zeitpunkt in der Mitte des Grains */
float grain (int vc)
{	float dur = (DURNOW + (drunkstep(DURRNG, vc) * DURNOW) 
			    + spread(DURSP,t,vc)) * durMod;
	float amp = AMPNOW;
	float sfinc = SRCONVINV * PITCHNOW 
		+ spread(PITCHSP,t,vc)
		+ PITCHNOW * drunkstep (PITCHRNG, vc); 
	float sfoffset = lastGrainSf 
		+ drunkstep (STPTRNG, vc) * DEVIATIONNOW 
		+ spread(STPTSP,t,vc) * nframes;
	float thres = sfMax * THRESNOW;
	float feedback = FDBKNOW;
	float winc = (float) WINDOWSIZE / dur;
	float woff, sfoff = sfoffset;
	float rmsratio, kneegain;
	int benchoff;
	int sfidx;
	float sffrc;
	float outfrc = t - (int) t;
	float outfrcrcp = 1. - outfrc;
	float val, valfrc, valfrcrcp, sum = 0.;
	int ch = vc % NOOUTPUTCHANNELS;
	int bufoffset = (((int) t) << OUTCHANNELSHIFT) + ch;
	
	if (nvoices == 1) amp *= 0.7;
	if (dur > MAX_DURATION) dur = MAX_DURATION;
	else if (dur < MIN_DURATION) dur = MIN_DURATION;
	for (benchoff = 0; benchoff < dur; benchoff++)
	{	sfidx = (int)sfoff;
		sffrc = sfoff - (float)sfidx;
		sfidx = (sfidx + nframes) % nframes;
		sfoff = (float) sfidx + sffrc;
		workbench[vc][benchoff] = val = 
			workbench[vc][benchoff] * feedback +
		    	( soundstart[sfidx] * (1. - sffrc) + 
			  soundstart[sfidx + 1] * sffrc
			);
		if (val < 0.0) val = -val;
		if (val > sum) sum = val;
		sfoff += sfinc;
	}
	kneegain = (thres + (sfMax - thres) * RATIONOW) / thres;
	if (sum <= thres) amp *= kneegain;
	else amp *= 1. + RATIONOW * (sfMax - sum) / sum;
	speedMod = dBtoFactor ((sum - thres) / sfMax * LTOSPEEDNOW);
	durMod =   dBtoFactor ((sum - thres) / sfMax * LTODISTNOW);
	benchoff = 0;
	for (woff = 0; woff < WINDOWSIZE; woff += winc)
	{	val = amp * fwindow[(int)woff] * workbench[vc][benchoff];
		valfrcrcp = outfrcrcp * val;
		valfrc = outfrc * val;
		bigbuf [bufoffset & BUFMASK] += valfrcrcp;
		bigbuf [(bufoffset + NOOUTPUTCHANNELS) & BUFMASK] += valfrc; 
		if (nvoices == 1) 
		{	bigbuf [(bufoffset + 1) & BUFMASK] += valfrcrcp;
		        bigbuf [(bufoffset + 3) & BUFMASK] += valfrc;
		}
		bufoffset += NOOUTPUTCHANNELS;
		benchoff++;
	}
	return t + dur * (float) nvoices / overlap;
}

void beforeWritesamps()
{
}

void afterWritesamps()
{	static int i, dur, nextVoice = 0, done = 0;
	static int endoff = TIMEPERBUF;
	nvoices = (int) fader_now(NVCS, timeNow);
	for (i = 0; i < BUFSIZE; i++) flbuf[i] = 0; 
	flbuf += BUFSIZE; 
	if (flbuf > (bigbuf + (BIGBUFSIZE - BUFSIZE))) flbuf = bigbuf;
	endoff += TIMEPERBUF; 
	done = 0;
	while (!(done))
	{	done = 1;
		for (i = 0; i < nvoices; i++)
			if (nextGrain[i] < endoff) 
			{	done = 0;
				if (nextGrain[i] < nextGrain[nextVoice]) 
					nextVoice = i;	
			}
		if (!(done))
		{	t = nextGrain[nextVoice];
			lastGrainSf = sfInLoop (sfnow(t), t);
			nextGrain[nextVoice] = grain (nextVoice)
				+ DISTNOW 
				+ ilookup (chromtable, drunkstep (DISTRNG, nextVoice))
				+ spread (DISTSP,t,nextVoice);
		}
	}
	if (transPending)
	{	dur = (int) chromtable[(int)fader_value[PARA_COUNT]];
		transPending = 0;
		if (fader_value[PARA_COUNT] != fader_prev_value[PARA_COUNT])
		{	for (i = 0; i < PARA_COUNT; i++) new_fader_trans(i, dur);
			fader_prev_value[PARA_COUNT] = fader_value[PARA_COUNT];
		}
		else 	for (i = 0; i < PARA_COUNT; i++) 
				if (fader_value[i] != fader_prev_value[i])
					new_fader_trans(i, dur);
	}
	timeNow += TIMEPERBUF;
	for (i = 0; i < 32; i++) 
		if (nextGrain[i] < timeNow) nextGrain[i] = timeNow;
	if (syncPending) for (i = 0; i < 32; i++) 
	{	nextGrain[i] = timeNow + 10000;
		syncPending = 0;
	}
	if (dispMode) {  
	  for (i = 0; i < PARA_COUNT; i++)
	    display_fader_value(i, fader_now(i, timeNow));
	  flushDisplay();
	}
}

