#include "phonemes.h"
#include "control.h"

extern int LastTarget[20];
extern int Frames[MAX_FRAMES][20];
extern float f0[2],f1[2],f2[2],f3[2],bw1[2],bw2[2],bw3[2],av[2];
extern float length,s_f0,s_f1,s_f2,s_f3,s_bw1,s_bw2,s_bw3,s_av,fnp,fnz;
extern float af,ab,a1,a2,a3,a4,a5,a6,asp;
extern int   total_frame_count;
extern long Features[ALL_END+1];

extern int Vowels[23][2][6];
extern int Nasals[5][9];
extern int Sonorants[10][8];

void gen_plosive(phone,segdur,prev_phone,next_phone)
int phone;
int segdur;
int prev_phone;
int next_phone;
{
  int j,features,next_feat=-1,prev_feat=-1,time_count,time_const,off;
  float prcnt,f0_temp,f1_temp,f2_temp,f3_temp,bw1_temp,bw2_temp,bw3_temp;
  float av_temp;

  features = Features[phone];
  if (prev_phone != -1)
    prev_feat = Features[prev_phone];
  if (next_phone != -1) 
    next_feat = Features[next_phone];
  if ((features & VOICE) && (!next_feat & VOWEL))
    av[0] -= 20;

  if (phone == GG || phone == GP)
    av[0] -= 10;

  if (next_feat != -1) {
    if (next_feat & VOWEL) {
      translate_phone(next_phone,&off);
      f1[1] = (float) Vowels[off][0][F1];
      f2[1] = (float) Vowels[off][0][F2];
      f3[1] = (float) Vowels[off][0][F3];
      bw1[1] = (float) Vowels[off][0][BW1];
      bw2[1] = (float) Vowels[off][0][BW2];
      bw3[1] = (float) Vowels[off][0][BW3];
    }
    else if (next_feat & SONOR) {
      translate_phone(next_phone,&off);
      f1[1] = (float) Sonorants[off][F1];
      f2[1] = (float) Sonorants[off][F2];
      f3[1] = (float) Sonorants[off][F3];
      bw1[1] = (float) Sonorants[off][BW1];
      bw2[1] = (float) Sonorants[off][BW2];
      bw3[1] = (float) Sonorants[off][BW3];
    }
  }
  if (prev_feat != -1)          /* voice onset time = 4 frames = 40 ms*/
    if (prev_feat & VOICE) {
      for (j=0;j < 4;j++) {
        Frames[total_frame_count][0] = LastTarget[0];
        Frames[total_frame_count][1] = LastTarget[1];
        Frames[total_frame_count][2] = LastTarget[2];
        Frames[total_frame_count][3] = LastTarget[3];
        Frames[total_frame_count][4] = LastTarget[4];
        Frames[total_frame_count][5] = LastTarget[5];
        Frames[total_frame_count][6] = LastTarget[6];
        Frames[total_frame_count][7] = LastTarget[7];
        Frames[total_frame_count][8] = LastTarget[8];;
        Frames[total_frame_count][9] = 0;
        Frames[total_frame_count][10] = 0;
        Frames[total_frame_count][11] = 0;
        Frames[total_frame_count][12] = 0;
        Frames[total_frame_count][13] = LastTarget[13];
        Frames[total_frame_count][14] = LastTarget[14];
        Frames[total_frame_count][15] = LastTarget[15];
        Frames[total_frame_count][16] = LastTarget[16];
        Frames[total_frame_count][17] = LastTarget[17];
        Frames[total_frame_count][18] = LastTarget[18];
        Frames[total_frame_count++][19] = LastTarget[19];
      }
    }

  if (phone == BB || phone == DD)
    time_const = segdur*2;
  else
    time_const = segdur;

  time_count = 0;
  f0_temp = f0[0]; 
  f1_temp = f1[0]; 
  f2_temp = f2[0]; 
  f3_temp = f3[0]; 
  bw1_temp = bw1[0];
  bw2_temp = bw2[0];
  bw3_temp = bw3[0];
  av_temp = av[0];

  for (j=0;j < segdur;j+=10) {
    Frames[total_frame_count][0] = (int)f0_temp; 
    Frames[total_frame_count][1] = (int)f1_temp; 
    Frames[total_frame_count][2] = (int)f2_temp; 
    Frames[total_frame_count][3] = (int)f3_temp; 
    Frames[total_frame_count][4] = (int)bw1_temp;
    Frames[total_frame_count][5] = (int)bw2_temp;
    Frames[total_frame_count][6] = (int)bw3_temp;
    Frames[total_frame_count][7] = (int)fnz;
    Frames[total_frame_count][8] = (int)fnp;
    Frames[total_frame_count][9] = (int)av_temp;
    Frames[total_frame_count][10] = 0;
    Frames[total_frame_count][11] = (int)asp;
    Frames[total_frame_count][12] = (int)af;
    Frames[total_frame_count][13] = (int)a1;
    Frames[total_frame_count][14] = (int)a2;
    Frames[total_frame_count][15] = (int)a3;
    Frames[total_frame_count][16] = (int)a4;
    Frames[total_frame_count][17] = (int)a5;
    Frames[total_frame_count][18] = (int)a6;
    Frames[total_frame_count][19] = (int)ab;

    if (next_feat != -1)
      if (next_feat & VOWEL || next_feat & SONOR) {
        if (phone == GP || phone == GG)
          av_temp -= 3;
        if (phone == BB || phone == DD) 
          av_temp -= 5;
        
        f0_temp = gen_curve(f0[0],f0[1],time_const/4,time_count); 
        f1_temp = gen_curve(f1[0],f1[1],time_const/4,time_count); 
        f2_temp = gen_curve(f2[0],f2[1],time_const/4,time_count); 
        f3_temp = gen_curve(f3[0],f3[1],time_const/4,time_count); 
        bw1_temp = gen_curve(bw1[0],bw1[1],time_const/4,time_count); 
        bw2_temp = gen_curve(bw2[0],bw2[1],time_const/4,time_count); 
        bw3_temp = gen_curve(bw3[0],bw3[1],time_const/4,time_count);
        time_count += 10;
      }

    if (phone == PP) {
      if (j == 20)
        Frames[total_frame_count][12] = 60;
      else if (j > 30 && j < 60)
        Frames[total_frame_count][11] = 60;
    }
    else if (phone == TT) {
      if (j == 10)
        Frames[total_frame_count][12] = 55;
      if (j >= 10)
        Frames[total_frame_count][11] = 45;
    }
    else if (phone == TQ) {
      if (j == 20)
        Frames[total_frame_count][12] = 51;
      if (j >= 20)
        Frames[total_frame_count][11] = 51;
    }
    else if (phone == KK) {
      if (j == 0)
        Frames[total_frame_count][12] = 45;
    }
    else if (phone == KP) {     /* voice onset for /Kh/ = 60ms */
      if (j == 0)
        Frames[total_frame_count][12] = 55;
      else
        Frames[total_frame_count][11] = 50;
    }
    else if (phone == GG) {     /* voice onset = 10ms */
      if (j >= (segdur -  10))
        Frames[total_frame_count][9] = 0;
    }   
    else if (phone == GP) {     /* voice onset = 10ms */
      if (j >= (segdur -  10)) {
        Frames[total_frame_count][9] = 0;
        Frames[total_frame_count][11] = 55;
      }
    }   
    else if (phone == BB) {
      if (j < 10 || j > 40)
        Frames[total_frame_count][9] = 0;
      if (j >= 20)
        Frames[total_frame_count][11] = 40;
    }
    else if (phone == DD) {
      if (j < 10) {
        Frames[total_frame_count][9] = 0;
      }
    }
    else if (phone == JJ) {
      if (j == 0 || j == 10) {
        Frames[total_frame_count][11] = 60;
      }
      if (j <= 40 && j > 0) {
        Frames[total_frame_count][9] = 60;
      }
    }    
    else if (phone == CH) {     /* voice onset for /Kh/ = 60ms */
      if (j == 0)
        Frames[total_frame_count][12] = 55;
      else
        Frames[total_frame_count][11] = 50;
    }
    total_frame_count++;
  }

  total_frame_count--;
  LastTarget[0] = Frames[total_frame_count][0];
  LastTarget[1] = Frames[total_frame_count][1];
  LastTarget[2] = Frames[total_frame_count][2];
  LastTarget[3] = Frames[total_frame_count][3];
  LastTarget[4] = Frames[total_frame_count][4];
  LastTarget[5] = Frames[total_frame_count][5];
  LastTarget[6] = Frames[total_frame_count][6];
  LastTarget[7] = Frames[total_frame_count][7];
  LastTarget[8] = Frames[total_frame_count][8];
  LastTarget[9] = Frames[total_frame_count][9];
  LastTarget[10] = Frames[total_frame_count][10];
  LastTarget[11] = Frames[total_frame_count][11];
  LastTarget[12] = Frames[total_frame_count][12];
  LastTarget[13] = Frames[total_frame_count][13];
  LastTarget[14] = Frames[total_frame_count][14];
  LastTarget[15] = Frames[total_frame_count][15];
  LastTarget[16] = Frames[total_frame_count][16];
  LastTarget[17] = Frames[total_frame_count][17];
  LastTarget[18] = Frames[total_frame_count][18];
  LastTarget[19] = Frames[total_frame_count][19];
  total_frame_count++;

}





