#include "phonemes.h"
#include "control.h"
#include <math.h>

extern int InhDur[ALL_END+1];
extern int MinDur[ALL_END+1];
extern long Features[ALL_END+1];

void segdur(seg_list,return_list,countptr)
int *seg_list;
int *return_list;
int *countptr;
{
  int i,type,num_syllables=1,syllable=1;
  int phone, phone_count,inhdur,mindur;
  int next_feature,prev_feature,off=0,count;

  count = *countptr;

  for (i=0;i < count;i++)
    return_list[i] = 100;

  phone_count = 0;
  num_syllables=1;
  for (i=0;i < count;i++) {
    phone = seg_list[i];
    if (phone == SYLLABLE_MARKER) {
      return_list[phone_count-1] += 20;
      syllable++;
      continue;
    }
    else if (phone == WORD_BREAK) {
      continue;
    }
    else if (phone == END_OF_LIST) {
      break;
    }
    type = Features[phone];
    if ((type & SYLLA) && (seg_list[i+1] != WORD_BREAK)){ /* rule 4 */
      return_list[phone_count] = (return_list[phone_count]*85)/100;
    }
    if ((type & SYLLABLE_MARKER) && num_syllables > 1) {
      return_list[phone_count] = (return_list[phone_count]*80)/100;/* rule 5 */
    }
    if ((!type & VOWEL) && i != 0) {
      return_list[phone_count] = (return_list[phone_count]*85)/100;/* rule 6 */
    }
    if (type & VOWEL) {         /* rule 9 */
      if (seg_list[i+1] >= 0)
        off = 1;
      else
        off = 2;
      if ((seg_list[off] & FRICA) && (seg_list[off] & VOICE)) {
        return_list[phone_count] = (return_list[phone_count]*160)/100;
      }
      if ((seg_list[off] & PLOSI) && (seg_list[off] & VOICE)) {
        return_list[phone_count] = (return_list[phone_count]*120)/100;
      }
      if (seg_list[off] & NASAL) {
        return_list[phone_count] = (return_list[phone_count]*85)/100;
      }
      if (seg_list[off] & PLOSI) {
        return_list[phone_count] = (return_list[phone_count]*70)/100;
      }
    }
                                /* rule 10 */
    if (seg_list[i+1] >= 0)
      off = 1;
    else
      off = 2;
    next_feature = Features[seg_list[off]];
    prev_feature = Features[seg_list[off]];
    if ((type & VOWEL) && (next_feature & VOWEL)) {
      return_list[phone_count] = (return_list[phone_count]*120)/100;
    }
    if ((type & VOWEL) && (prev_feature & VOWEL)) {
      return_list[phone_count] = (return_list[phone_count]*70)/100;
    }
    if ((!type & VOWEL) && (!next_feature & VOWEL) && (!prev_feature & VOWEL)) {
      return_list[phone_count] = (return_list[phone_count]*50)/100;
    }
    else if ((!type & VOWEL) && (!prev_feature & VOWEL)) {
      return_list[phone_count] = (return_list[phone_count]*70)/100;
    }
    else if ((!type & VOWEL) && (!next_feature & VOWEL)) {
      return_list[phone_count] = (return_list[phone_count]*70)/100;
    }
    phone_count++;
  }

  for (i=0;i < phone_count;i++) {
    phone = seg_list[i];
    mindur = MinDur[phone];
    inhdur = InhDur[phone];
    if (return_list >= 0)
      return_list[i] = ((inhdur-mindur)*return_list[i])/100+mindur;
    else 
      return_list[i] = 0;
    printf("Phone %d len: %d\n",i,return_list[i]);
  }
}

int gen_curve(Ai,Af,time_const,t)
float Ai;
float Af;
int time_const;
int t; 
{
  double temp1;

  if (time_const == 0)
	time_const = 1;
  temp1 = exp(-1*(double)t/(double)time_const);
  temp1 *= (Ai-Af)*(1.0+((double)t/(double)time_const));
    
  return (int)(temp1 + Af);
}

