/*             REAL TIME SPECTROGRAM                   */
/*             ---------------------                   */
/*
 * 
 
   People who have contributed to this code :
  
	David S. Maynard 	- ex of Silicon Graphics Computer Systems, USA
	Bruce Karsh		- Silicon Graphics Computer Systems, USA

	Paul Danset		- pdanset@hitl.washington.edu
	David Rossiter		- dpr@ohm.york.ac.uk


   See the README file for more information.

*/

#include <stdio.h>
#include <gl.h>
#include <device.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <sys/types.h>
#include <sys/dir.h>
#include <string.h>

#include <audio.h>

#define MAXCOLUMN 700


/* ORDER defines the number of frequency bands plotted */
/* ORDER is the number of points along the x-axis   */
#define ORDER 128

/* DURATION is the number of power spectrums plpotted  */
/* DURATION is the number of points along the y-axis  */
#define DURATION 25

/* BUFCHUNKSIZE is the default number of samples transformed per frame */
/* BUFCHUNKSIZE must be at least twice ORDER to avoid aliasing in the */
/* frequncy domain */
#define BUFCHUNKSIZE 256
int curfftsize = /*BUFCHUNKSIZE*/ 1024;

/* Basic program loop is as follows
    while (true)
	{
	read all waiting audio samples from input buffer
	perform an FFT on the last "curfftsize" samples
	calculate the power in each of the lowest "ORDER" frequency bands
	add this power spectrum to the front of the rolling carpet
	plot the rolling carpet of power spectrums
	}
*/
#define ON 1
#define OFF 0

#define RGBTIMEFACT 3.2
#define LMTIMEFACT 1.35
#define MMTIMEFACT 1.35

#define MAXBUFFERSIZE 60000
#define ABUFFERSIZE 40000

#define MAXDURATION (DURATION<<1)
#define TWOPI  6.2832
float amp[MAXDURATION][ORDER];	   /* independent variable */

float power[DURATION][ORDER];   /* vertices of rolling carpet */
float xlogpos[ORDER];     /* table to store pre-computed x coordinates log scale */

int column=0;

char	*myname;
ALport port;
ALconfig conf;
int curlinewidth = 1;
int candoRGB = 0;
int mono = 0;
int DB = 0;   /* if true use double buffering */
int framecount =0;
int zbuf = 0;  /* if true use zbuffering */

 /* use 16 bit audio samples ( no cheesy 8 bit mu-law please) */

typedef short SAMPLE; 

/* Daves new variables */
int curscrsize=2;
char show_freq_scale=TRUE, show_time_scale=TRUE;
#define START_COLUMN 80
long start_column=START_COLUMN;
float max_display_freq=0;
long y_offset_from_bottom=70, y_offset_from_top=23,
	x_offset_from_right=20;

SAMPLE tbuf[2*MAXBUFFERSIZE];

extern float spectrum( SAMPLE * , int , float *, int, float );


float dist=0.0, d_dist=0.0;
Angle azim=0, inc=700, twist=0;
Angle d_azim=0, d_inc=0;

short mx, my, omx, omy, nmx, nmy;
long origx, origy, sizex, sizey;

int y;
long mode, playmode, prevmode;
int active=TRUE;
long gid;
#define	TIMELINES	1
#define	FREQLINES	2
#define	AMPLINES	4

int low_res, low_tmp;

int function = 0;
#define REORIENT 1
#define REDISTANCE 2
#define PREPAREAIFF 3

#define DTHETA 0.6
#define PWRMAX 100.0

int idur=0;
float maxpwr = PWRMAX;  /* maxpwr used for automatic gain control */
float pwr = 1.0;
int facing = 0, facingz = 0, buggy = 0, buggyview = 0;

float p1[ 3], p2[ 3], tv1[ 3], tv2[ 3];
int dotmesh;

short	mute;		/* if TRUE then don't play sound out */
short logfreq = 0;		/* IF TRUE USE LOG SCALE FOR FREQUENCY AXIS */
short tmeshmode = 0;	/* IF TRUE USE Tmesh drawing mode */
#define	FIRSTTIME	1
#define	INPORT		2
#define	OUTPORT		4


/* pop-up menu id's */
long	mainmenu, linemenu, samplemenu, scrsizemenu, fftmenu;


static void drawpower();
static void mappower();


static void	generate(void)
{
	int id, io;
	for (id=0;id<MAXDURATION;id++)
	    for (io=0;io<ORDER;io++)
		    amp[id][io] =  0.0;
}

static void	place(void)
{
	int	nxt = idur, id, io;

	for (id=0;id<DURATION;id++) {
		for (io=0;io<ORDER;io++) {
			power[id][io] = amp[nxt][io];            /* y */
		}
		nxt--;
		if (nxt < 0 ) nxt = MAXDURATION-1;
	}
}


static void	draw_scene(void) 
{
    place();
    drawpower();

    if (DB) swapbuffers(); else gsync();
}


static void	drawpower() 
{
    float	dx,dz,xp,zp;
   int    vert[2];
    float  invmax, thresh;
    float *p;
    int	ORD2 = ORDER >> 1,
	bright,
	id,io,
	rc,gc,bc;

    int mag_inc=0; /* index variable for for loop */

    dx = 1.0;
    invmax = 1.0/maxpwr * 950;
    thresh = maxpwr/50.0;
    framecount++;
 
   if (mono) {
	rc = 0x80;
	gc = 0x80;
	bc = 0x80;
	cpack(0xffffff);
    }
    if (mode & FREQLINES) {
	dz = 1.0;
	zp = -DURATION+dz;
	cpack(0xffffff);

	    xp = -1.0;
	    p = &power[0][0];

            vert[0]=column++;
            if (column>MAXCOLUMN-1) column=start_column;
            bgnpoint();
            for (io=0;io<ORDER;io++,p++) {
                rc = (int) ((*p)*invmax);
                if (rc>255) rc=255;
                rc = 255-rc;
                RGBcolor(rc,rc,rc);

                vert[1]=(io*curscrsize)+y_offset_from_bottom+1; /* +1 for x axis line */
                v2i((const long *)vert); 

		if (curscrsize>1)
		for (mag_inc=2;mag_inc<=curscrsize;mag_inc++) {
                RGBcolor(rc,rc,rc);
                 	vert[1]=(io*curscrsize)+mag_inc-1+y_offset_from_bottom+1; /* +1 for x axis line */
                	v2i((const long *)vert);
		}

           }
            endpoint();
    }
}


static void	initialise(void)
{
    int i;
    float xscale ;
    /* Initialsize xlogpos table */
 
    tmeshmode = 0;
    logfreq = 0;
    xscale = ORDER*1.0 / flog(ORDER*1.0);
    for (i=0;i<ORDER;i++)
	xlogpos[i] = flog( (i+1)*1.0) * xscale;
    prefsize(MAXCOLUMN+x_offset_from_right,(ORDER*curscrsize)+y_offset_from_bottom+y_offset_from_top);
    gid = winopen("Real-time spectrogram");

    if (DB) doublebuffer();
    if(getgdesc(GD_BITS_NORM_SNG_RED) == 0) candoRGB = 0;
    else candoRGB = 1;
    if (!candoRGB) { 
	fprintf(stderr, " rtspect requires RGB mode to run \n"); 
	exit(1);
	}
    RGBmode();
    zbuffer(zbuf);
    gconfig();
    RGBcolor(255,255,255);
    clear();
    if(DB)  { 
	swapbuffers();
	clear(); 
	}  else gsync();
    if (zbuf) zclear();
    qdevice(INPUTCHANGE);
    qdevice(REDRAW);
    qdevice(ESCKEY);
    qdevice(WINQUIT);
    qdevice(WINSHUT);
    qdevice(WINFREEZE);
    qdevice(WINTHAW);
    qdevice(LEFTMOUSE);
    qdevice(MIDDLEMOUSE);
    qdevice(RIGHTMOUSE);
    qdevice(RKEY);			/* replay current sample */
    qdevice(LEFTARROWKEY);		/* following four move wheel */
    qdevice(RIGHTARROWKEY);
    qdevice(UPARROWKEY);
    qdevice(DOWNARROWKEY);
    qdevice(BKEY);			/* Toggle wheel on/off */
    qdevice(VKEY);			/* Toggle view from/of wheel */
    qdevice(SKEY);			/* Resynchronize without popup menu */
    qdevice(SPACEKEY);

    facingz = -DURATION/2+3;
    generate();
    dist = DURATION  + 70.0;


    qreset();
    qenter(REDRAW, (short)winget());
}


static void efunc( long num, const char * ch, ...)
{
}

/* func is given by logical or of FIRSTTIME, OUTPORT, and INPORT */
static void	open_audio(short func)
{
	ALerrfunc	origfunc;
	short		badopen = 0;

	origfunc = ALseterrorhandler(efunc);
	if (func & FIRSTTIME) {
	    conf = ALnewconfig();
	    ALsetwidth(conf, AL_SAMPLE_16);
	    ALsetchannels(conf, AL_MONO);
	    port = 0;
	}
	if (func & INPORT) badopen = badopen ||
		((port = ALopenport("audio_in", "r", conf)) == 0);
	if (badopen) {
	    fprintf(stderr, "%s: could not open the necessary audio ports\n",
		myname);
	    system("inform 'could not open the audio ports'");
	    exit(1);
	}
	ALseterrorhandler(origfunc);
}


/* func is given by a logical or of OUTPORT and INPORT */
static void	close_audio(short func)
{
	if ((func & INPORT) && port) { ALcloseport(port); port = 0; }
}




static void	remake_lmenu(void)
{
	long i;

	freepup(linemenu);
	linemenu = defpup("Line Widths %t| One %x11| Two %x12| Four %x14| Six %x16");
	for (i = 0; i < 4; i++)
	    setpup(linemenu, i+1, PUP_BOX);
	switch (curlinewidth) {
	    case 1: i = 1; break;
	    case 2: i = 2; break;
	    case 4: i = 3; break;
	    case 6: i = 4; break;
	    default: curlinewidth = 1; i = 1; break;
	}
	setpup(linemenu, i, PUP_CHECK);
}

static void	remake_fftmenu(void)
{
	long i;
	long buf [4] ;
	char menustr[400];
	char tmpstr[40];
	long inputfreq;
	float nyquistfreq;
	buf[0] = AL_INPUT_RATE;
	ALgetparams (AL_DEFAULT_DEVICE,buf,2);
	inputfreq = buf[1];
	freepup(fftmenu);

	max_display_freq = (float)(1.0*inputfreq*ORDER)/((float)curfftsize)/1000.0f;

	menustr[0] = '\0';
	strcat(menustr, "Frequency range %t |  0 to");


	nyquistfreq = 1.0*inputfreq*ORDER/256/1000;
	sprintf(tmpstr,"%5.1f KHz", nyquistfreq);
	strcat(menustr,tmpstr);
	strcat(menustr," %x42|  0 to");

	nyquistfreq = 1.0*inputfreq*ORDER/512/1000;
	sprintf(tmpstr,"%5.1f KHz", nyquistfreq);
	strcat(menustr,tmpstr);
	strcat(menustr," %x43|  0 to");

	nyquistfreq = 1.0*inputfreq*ORDER/1024/1000;
	sprintf(tmpstr,"%5.1f KHz", nyquistfreq);
	strcat(menustr,tmpstr);
	strcat(menustr," %x44");


	fftmenu = defpup(menustr); 
	for (i = 0; i < 3; i++)
	    setpup(fftmenu, i+1, PUP_BOX);
	switch (curfftsize) {
	    case 256: i = 1; break;
	    case 512: i = 2; break;
	    case 1024: i = 3; break;
	    default: curfftsize = 1024; i = 3; break;
	}
	setpup(fftmenu, i, PUP_CHECK);
}

static void	remake_scrsizemenu(void)
{
	long i;

	freepup(scrsizemenu);
	scrsizemenu = defpup("Screen size %t|Petite %x61|Comfy %x62|Medium %x63|Large %x64|Big & beefy %x65");
	for (i = 0; i < 5; i++)
	    setpup(scrsizemenu, i+1, PUP_BOX);
	setpup(scrsizemenu, curscrsize, PUP_CHECK);
}

static void	remake_mmenu(void)
{
/*	if (mono) setpup(mainmenu, 3, PUP_BOX);
	else setpup(mainmenu, 3, PUP_CHECK);*/
	
/*	if (logfreq) setpup(mainmenu, 4, PUP_CHECK);
	else setpup(mainmenu, 4, PUP_BOX);*/

	if (show_freq_scale) setpup(mainmenu,3,PUP_CHECK);
	else setpup(mainmenu, 3, PUP_BOX);    /* - put in for 'show freq axis' option */
}

static void	remake_menus(void)
{
	freepup(mainmenu);
  	mainmenu = defpup("Real-time spectrogram %t|Screen size %x0%m|Frequency range %x40%m|Show freq axis %x50|Quit %x1",scrsizemenu, fftmenu);
		/*|Show freq scale %x50 - for 'show freq axis' option */
	remake_mmenu();
	remake_fftmenu();
	}

static void	make_menus(void)
{
	remake_scrsizemenu();
	remake_fftmenu();
	remake_menus();
}

static int	wait_till_thawed(void)
{
	long	dev;
	short	val;

        close_audio(INPORT | OUTPORT);
	do {
		dev = qread(&val);
	} while (dev != WINQUIT && dev != WINSHUT && dev != WINTHAW);
	if (dev == WINQUIT || dev == WINSHUT) return TRUE;
	open_audio(INPORT | OUTPORT);
	qenter(REDRAW, (short)winget());
	return FALSE;
}


static void	usage(void)
{
	fprintf(stderr,"usage: %s  \n",myname);
	system("inform 'usage: rtspect  '");
	exit(1);
}


static void draw_freq_scale(void)
{
long tag_length=4; /* length of marker */
long total_pixels=0;
float kh_per_pixel=0.0f;
long accum_freq=0;
char buffer[20];
long line_start[2],
	line_end[2];
int xpos=0, ypos=0, old_ypos=-99;


	/*fprintf(stderr,"max freq on display is %f\n",max_display_freq);*/
	total_pixels=128*curscrsize;
	kh_per_pixel=max_display_freq/total_pixels;
	accum_freq=0;

	/* Clear space behind axis */
	RGBcolor(255,255,255);
	rectfi(0,0+y_offset_from_bottom,start_column-1,total_pixels+y_offset_from_bottom+y_offset_from_top);

	/* Draw main axis line */
	RGBcolor(0,0,0);
	line_start[0]=start_column-1;
	line_end[0]=start_column-1;
	line_start[1]=0+y_offset_from_bottom;
	line_end[1]=total_pixels+y_offset_from_bottom;
	bgnline();	
		v2i(line_start);
		v2i(line_end);
	endline();

	while (accum_freq<=max_display_freq) {
		ypos=(int)((float)accum_freq/kh_per_pixel);
		xpos=start_column-tag_length-22;

		if ((ypos-old_ypos)>17) {

		ypos-=4;
		sprintf(buffer,"%d",accum_freq);
		if (strlen(buffer)==1) xpos+=5;
		
		cmov2i(xpos,ypos+y_offset_from_bottom);
		RGBcolor(255,0,0); /* Red */
		charstr(buffer);
	
		/* Draw tag line */	
		line_start[0]=start_column-1;
		line_end[0]=(start_column-1)-tag_length;
		line_start[1]=(int)((float)accum_freq/kh_per_pixel)+y_offset_from_bottom;
		line_end[1]=line_start[1];
		RGBcolor(0,0,0);
		bgnline();
			v2i(line_start);
			v2i(line_end);
		endline();

		old_ypos=ypos;
		}
		accum_freq+=1; /* Move on to next KHz tag */
	}
	
	/* Draw axis label */
	cmov2i(10,(total_pixels/2)+y_offset_from_bottom);
	RGBcolor(0,0,0); /* Black */
	charstr("FX");
	cmov2i(0,(total_pixels/2)-12+y_offset_from_bottom);
	RGBcolor(128,128,128);
	charstr("(KHz)"); /* Grey */
	
}


static void draw_time_scale(void)
{
long line_start[2],
	line_end[2];
long max_display_time=10; /* 10 seconds on screen */
long tag_length=4; /* length of marker */
long total_pixels=0;
float secs_per_pixel=0.0f;
long accum_secs=0;
int xpos=0, ypos=0, old_xpos=-99;
char buffer[20];


	total_pixels=MAXCOLUMN-start_column;
	secs_per_pixel=(float)max_display_time/(float)total_pixels;
	accum_secs=0;

	/* Draw main axis line */
	RGBcolor(0,0,0);
	line_start[0]=start_column;
	line_end[0]=MAXCOLUMN-1;
	line_start[1]=y_offset_from_bottom;
	line_end[1]=y_offset_from_bottom;
	bgnline();	
		v2i(line_start);
		v2i(line_end);
	endline();
	
	
	while (accum_secs<=max_display_time) {
		xpos=start_column-1+(accum_secs==0?0:((float)accum_secs/secs_per_pixel));
		ypos=y_offset_from_bottom-tag_length-20;

		if ((xpos-old_xpos)>17) {

		xpos-=8;
		sprintf(buffer,"%d",accum_secs);
		if (strlen(buffer)==1) xpos+=5; /* Check for double digit */
		
		cmov2i(xpos,ypos/*+y_offset_from_bottom*/);
		RGBcolor(255,0,0); /* Red */
		charstr(buffer); /* Display axis number */
	
		/* Draw tag line */	
		line_start[1]=y_offset_from_bottom;
		line_end[1]=(y_offset_from_bottom)-tag_length;
		line_start[0]=(int)((float)accum_secs/secs_per_pixel)+start_column-1;
		line_end[0]=line_start[0];
		RGBcolor(0,0,0);
		bgnline();
			v2i(line_start);
			v2i(line_end);
		endline();

		old_xpos=xpos;
		}
		accum_secs+=1; /* Move on to next Seconds tag */
	}

	/* Draw axis label */
	cmov2i((MAXCOLUMN/2),y_offset_from_bottom-45);
	RGBcolor(0,0,0); /* Black */
	charstr("Time");
	cmov2i((MAXCOLUMN/2)+5,y_offset_from_bottom-60);
	RGBcolor(128,128,128);
	charstr("(s)"); /* Grey */

}


static void blank_screen_area(void)
{
int	total_y_pixels=128*curscrsize;

	/* Clear space behind axis */
	RGBcolor(255,255,255);
	rectfi(0,0,MAXCOLUMN+x_offset_from_right,total_y_pixels+y_offset_from_bottom+y_offset_from_top);

}

void main( int argc, char **argv) 
{
    long	xrot,yrot,zrot;
    long	i, ntoread, dev;
    int		nframe=0;
    short	done = FALSE, stowed = FALSE, val;
    long	nfilled;

    char 	pause=OFF;

    float	time_per_frame = 0.0, timefact = 1.0, basetime = 0.0;

	if (show_freq_scale) start_column=START_COLUMN;
	else start_column=0;

	column=start_column;


    for (i=0;i<8000;i++) tbuf[i] = (SAMPLE) ( (i*8)%256 - 128 );
    xrot = yrot = zrot = 0;
    dotmesh = 0;
   curfftsize = /*BUFCHUNKSIZE*/ 1024;
 
    open_audio(FIRSTTIME | INPORT /* | OUTPORT */);

    initialise();

  idur = 0;
 
    playmode = 1;
    mode = FREQLINES;
    prevmode = mode;
    make_menus();
   draw_freq_scale();
   draw_time_scale();



    while (!done) {
	if (!pause) draw_scene();
	idur++;
	if (idur >= MAXDURATION) idur = 0;

	
	nfilled = ALgetfilled(port);
	ntoread = nfilled > ABUFFERSIZE ? ABUFFERSIZE : nfilled;
	

	ALreadsamps(port, (void *) tbuf, ntoread);
	    pwr = spectrum(tbuf+(ntoread-curfftsize), 
			curfftsize, &amp[idur][0], ORDER, 0.0 );
	if (pwr < maxpwr) nframe++;
	if (nframe > DURATION) { nframe = 0; maxpwr *= 0.97;}
	if (pwr > maxpwr) { maxpwr = pwr; nframe = 0 ;}

	timefact = 1.0;

	    /* Thant's input code */
	while(qtest() /*  || (!function && low_tmp<2) */ ) {
	    dev=qread(&val);
	    switch(dev) {
		case INPUTCHANGE:
		    active = val;
		    break;
		case WINQUIT:
		case WINSHUT: done = TRUE; break;
		case WINFREEZE: stowed = TRUE; break;
		case ESCKEY :
		    if (!val) done = TRUE;
		    break;
		case SKEY:
		    break;
		case VKEY:
		    break;
		case LEFTMOUSE:
		    break;
		case MIDDLEMOUSE:
		    break;
		case RIGHTMOUSE:
		    if (val) {
			long menval;
			/* in case the input rate has changed */
			remake_fftmenu(); 
			menval = dopup(mainmenu);
			switch (menval) {
			    case -1: break;
			    case 1: /* quit */
				done = 1;
				break;
			    case 2: /* color */
				mono ^= 1;
				remake_mmenu();
				break;
			    case 5: /* wheel toggle */
				remake_menus();
				break;
			    case 6: /* wheel view toggle */
				remake_menus();
				break;
			    case 8: /* toggle time */
				mode ^= TIMELINES;
				goto fix_time_per_frame;
			    case 9: /* toggle frequency */
				mode ^= FREQLINES;
				goto fix_time_per_frame;
			    case 10: /* toggle amplitude */
				mode ^= AMPLINES;
				fix_time_per_frame:
				remake_scrsizemenu();	/* also fixup menu	*/
				remake_menus();
				/* nothing yet */
				break;
			    case 11: case 12: case 13: case 14:
			    case 15: case 16: case 17: case 18: case 19:
				curlinewidth = (int)(menval-10);
				remake_lmenu();
				remake_menus();
				break;
			    case 21:
			    case 22:
			    case 30: /* logfreq */
				logfreq ^= 1;
				remake_mmenu();
				break;
			    case 32: /* Tmesh */
				break;

			/* Set frequency range */
			    /*case 41: 
				curfftsize = 128;
				remake_fftmenu();
				break;*/
			    case 42: 
				curfftsize = 256;
				remake_fftmenu();
				column=start_column;
				if (show_freq_scale) draw_freq_scale();
				break;
			    case 43: 
				curfftsize = 512;
				remake_fftmenu();
				column=start_column;
				if (show_freq_scale) draw_freq_scale();
				break;
			    case 44: 
				curfftsize = 1024;
				remake_fftmenu();
				column=start_column;
				if (show_freq_scale) draw_freq_scale();
				break;

			/* Toggle for showing freq axis */
			case 50 : show_freq_scale ^=1;
				if (show_freq_scale) {
					start_column=START_COLUMN;
					blank_screen_area();
					if (show_time_scale) 
						draw_time_scale();
					draw_freq_scale();
					}
					else {
					start_column=0;
					column=0;
					blank_screen_area();
					if (show_time_scale) 
						draw_time_scale();
					}   
	     
				remake_mmenu();
				break;

			/* Set screen size */
			case 61: curscrsize=1;
				winclose(gid);
				initialise();
				remake_scrsizemenu();
				if (show_time_scale) draw_time_scale();
				if (show_freq_scale) draw_freq_scale();
				column=start_column;
				break;
			case 62: curscrsize=2;
				winclose(gid);
				initialise();
				remake_scrsizemenu();
				if (show_time_scale) draw_time_scale();
				if (show_freq_scale) draw_freq_scale();
				column=start_column;
				break;
			case 63: curscrsize=3;
				winclose(gid);
				initialise();
				remake_scrsizemenu();
				if (show_time_scale) draw_time_scale();
				if (show_freq_scale) draw_freq_scale();
				column=start_column;
				break;
			case 64: curscrsize=4;
				winclose(gid);
				initialise();
				remake_scrsizemenu();
				if (show_time_scale) draw_time_scale();
				if (show_freq_scale) draw_freq_scale();
				column=start_column;
				break;
			case 65: curscrsize=5;
				winclose(gid);
				initialise();
				remake_scrsizemenu();
				if (show_time_scale) draw_time_scale();
				if (show_freq_scale) draw_freq_scale();
				column=start_column;
				break;
			default:
				break;
			}
		    }
		    break;

		case SPACEKEY:
			if (pause) pause=OFF;
			else pause=ON;
			break; 

		case REDRAW:
		    /*reshapeviewport();
		    getorigin(&origx, &origy);
		    getsize(&sizex, &sizey);*/

			blank_screen_area();
				if (show_time_scale) draw_time_scale();
				if (show_freq_scale) draw_freq_scale();
		    break;
		case LEFTARROWKEY:
		    if ( val == 0) break;
		    facing += 1;
		    if ( facing + ORDER/2 >= ORDER) facing = -ORDER/2;
		    break;
		case RIGHTARROWKEY:
		    if ( val == 0) break;
		    facing -= 1;
		    if ( facing + ORDER/2 < 0) facing = ORDER/2 - 1;
		    break;
		case UPARROWKEY:
		    if ( val == 0) break;
		    facingz += 1;
		    if ( -DURATION/2 + facingz > 0) facingz = -DURATION/2 + 1;
		    break;
		case DOWNARROWKEY:
		    if ( val == 0) break;
		    facingz -= 1;
		    if ( -DURATION/2 + facingz <= -DURATION) facingz = DURATION/2 ;
		    break;
		case BKEY:
		    if ( val == 0) break;
		    break;
	    }
	}

	switch(function) {

	    case REORIENT:
		mx = (short)getvaluator(MOUSEX);
		my = (short)getvaluator(MOUSEY);
		d_azim = (short)((omx - mx) * 2 * XMAXSCREEN / sizex);
		d_inc = (short)((my - omy) * 2 * YMAXSCREEN / sizey);
		break;

	    case REDISTANCE:
		mx = (short)getvaluator(MOUSEX);
		my = (short)getvaluator(MOUSEY);
		d_dist = ((omx - mx) + (my - omy)) * XMAXSCREEN /sizex;
		break;
	}


	if (stowed) {
		done = wait_till_thawed();
		stowed = FALSE;
	}

    }
    close_audio(INPORT /* | OUTPORT */);
}

