/**************************************************************************
*
* FunktrackerGOLD - By Jason Nunn
*
* Swaptions (you WILL need to play with these settings to get Funktracker
*            working CORRECTLY on your machine. Follow the instructions)
*
**************************************************************************/

/*------------------------------------------------------------------------
Misc. Settings. Based on how big your system is.

If you system is tight for memory, you may like to reducing these values.
*/
#define MAXIMUM_PATTERNS 128
#define MAXIMUM_CHANNELS 16
#define MAX_DIR_ENTRIES 500

/*------------------------------------------------------------------------
this settings is basically the sound output quality of the music in Hz.
The greater the Hz, the better it will sound, and the more CPU required
to mix the output signal.

Values should range between 6000 being the very extreme lowest, and
the highest being 44100. Quality will very depending on whether you are
mixxing is stereo/mono, 8bit/16 bit.. but generally, anything below
11025hz is very poor. 22050hz is good output, and anything greater
than say 33000hz is very high finity output.

The following is a good general measure you can go by:

386-16..........8000-12000hz
486-33..........16000-22050hz
P90.............44100hz (will only _just_ work on my machine in console)
*/
#define DEFAULT_SAM_RATE  22050

/*------------------------------------------------------------------------
Do you have a fast machine?. Can it hack having it's math circuits pounded?.
If not then, it probably couldn't cope with the digital echoing code.

NB/ also that each channels echo buffer is 32k. So if you are tight for 
memory, disenable this option.
*/
#define DIGITAL_ECHOING

/*------------------------------------------------------------------------
This sets the precision of the output signal (in bits).

If you have a Soundblaster 1.0, 1.5, 2.0 or Soundblaster PRO card, then 
this should be set to 8. If you have a Sound Blaster 16, AWE32, PAS16, 
Soundblaster 32 card, then set this to 16. If you have a GUS card, then 
set it to 8.
*/
#define DEFAULT_PRECISION 16

/*---------------------------------------------------------------------
if you have a soundcard capable of stereo, then set this to 1.
*/
#define DEFAULT_STEREO    1

/*---------------------------------------------------------------------
IMPORTANT!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

The following settings are VERY important for synchronisation purposes.

Back in MessyDOS, DOS32 Funktracker implemented a mixxing technique known
as Double Buffered DMA looped paging. Basically, you set up the DMA
(Direct Memory Access - basically, it's a fancy chip on the PC used for
copying memory) to write data to your soundcard. The DMA page would be
divided into 2 halves. You would get the soundcard to IRQ (Interrupt
Request) whenever it reached the end of any of the two halves. As DMA
would simultaneously copy audio to the soundcard, your Interupt service
routine would be mixxing audio on the other half of the page. It was an
extremely clever way of doing it.  Not only that, the mixxing routines got
total PRIORITY over the CPU. Once the Soundcard chucked an IRQ, the
interrupt service routine would be executed. Under Linux, it's a different
story. Mixxing is performed under normal non-preemptive foreground process
conditions, and therefore, it relies on /dev/audio for smooth consistant
timing. 

In FunktrackerGOLD, Mixxing is a two stage process. First the channels are
mixxed together, then the output is written to the /dev/dsp device. It
needs to be able to squart sufficient audio to this device so that: 

a) There is a reasonable 0.02 tick delay for foreground display to look
timed

b) So that there is enough audio signal sent, so that the device won't 
starve (empty it's buffers) before the next lot of mixxed block of data 
can be written.

If your fragment size (FUNK_DSP_FRAGMENT) is too big, then display will
seem jagged, and very rough. If the fragment size is too small, then it
will require more internal processing for the /dev/dsp to send the data to
the soundcard. You will also need more fragments, as the smaller fragments
will empty out alot quickier. 

If the amount of fragments (FUNK_DSP_FRAMES) is too big, you will get a
delay between /dev/dsp playing the audio and the tracker
mixxing/displaying the data, as the device won't play any audio until it's
internal buffers have been filled. If you have a too smaller amount, then
there will not be enough audio buffered in time for the mixxing routines
to send the next buffer of mixxed audio to the device. Hence, the device
will starve inbetween tracker processing, and audio will momentarily halt
between mixx buffers. 

FUNK_DSP_FRAGMENT amount will depend on your system. You are advised to
experiment with this setting to get it right. The FUNK_DSP_FRAGMENT size,
we specify and indice. This indice will translate to the following values
(yes it's 2 << x): 

7  = 127 bytes in length
8  = 256 bytes in length
9  = 512 bytes in length
10 = 1k in length

etc

The values of these settings will vary according to sampling rate,
precision, and whether or not you have stereo set. A distinct combination
of these settings will produce a smooth audio signal, as well as
synchronised display.


For Example: I have a P90, 8 megs of ram, a SB16, running 1.2.13 (so be
upgrading), and i use 16bit, stereo output sampling at 44100hz. Therefore
i have the FUNK_DSP_FRAMES set to 32, and my FUNK_DSP_FRAGMENT to 9. 
*/
#define FUNK_DSP_FRAMES   32
#define FUNK_DSP_FRAGMENT 9
