#include "../PVLIB/pv.h"

/*
Modified by Lyon to interpolate between two given
functions. Bins will be unselected for synthesis
based on a threshold multiplication factor relative
to the highest amplitude
*/
/* oscillator bank resynthesizer for phase vocoder analyzer
  uses sum of N+1 cosinusoidal table lookup oscillators to 
  compute I (interpolation factor) samples of output O
  from N+1 amplitude and frequency value-pairs in C;
  frequencies are scaled by P */

red_oscbank( C, N, R, Nw, I, P, O, L, table1, table2, ifac, tmult )
float C[], O[], P; int N, Nw, R, I;
int L; /* LENGTH OF OSC TABLE FUNCTIONS   */
float table1[], table2[], ifac, tmult;
{

  static int 	NP,
		first = 1;
  static float	Iinv,
		*lastamp,
		*lastfreq,
		*index,
		*table;
  static float	Pinc,
		ffac;
  int 		amp,
		freq,
		n,
		chan;
  float		a0;
  char		*space(); 
  float maxampval, thresh ; /* FOR ADAPTIVE RESYNTHESIS THRESHOLD   */
  float ifac2 ; /* second function multiplier = 1.0 - ifac   */
  int i;
  float tabscale;
  /* INITIALIZE, ALLOCATE MEMORY   */
  if ( first ) {
  float TWOPIoL = TWOPI/L;
	first = 0;
	lastamp = (float *) space( N+1, sizeof(float) );
	lastfreq = (float *) space( N+1, sizeof(float) );
	index = (float *) space( N+1, sizeof(float) );
	table = (float *) space( L, sizeof(float) );
	tabscale = (float) N ;
	Iinv = 1./I;
	Pinc = P*L/R;
	ffac = P*PI/N;
       for( n = 0 ; n < L ; n++ ){
          table1[n] *= tabscale;
	  table2[n] *= tabscale;
       }
	if ( P > 1. )
	    NP = N/P;
	else
	    NP = N;
    } /* END INITIALIZE
 /* catch maxamp for each frame - generate threshold */
 maxampval = 0.0;
 for(i = 0; i < N; i += 2)
    if( C[i] > maxampval ) 
       maxampval = C[i];
 thresh = maxampval*tmult;
/*  fprintf(stderr,"maxamp %.10f, thresh %.10f\n",maxampval,thresh); */

/* generate resynthesis table as an interpolation
   between the two source waveforms */
ifac2 = 1.0 - ifac;
for( i = 0; i < L; i++ ){
   table[i] = ((table1[i]*ifac2) + (table2[i]*ifac)) ;
}
/* for each channel, compute I samples using linear
   interpolation on the amplitude and frequency
   control values */

    for ( chan = 0; chan < NP; chan++ ) {

      register float 	a,
			ainc,
			f,
			finc,
			address;

	freq = ( amp = ( chan << 1 ) ) + 1;

	if ( C[amp] < thresh ) /* skip the little ones */
	    continue;

	C[freq] *= Pinc;
	finc = ( C[freq] - ( f = lastfreq[chan] ) )*Iinv;
	ainc = ( C[amp] - ( a = lastamp[chan] ) )*Iinv;
	address = index[chan];

/* accumulate the I samples from each oscillator into
   output array O (initially assumed to be zero);
   f is frequency in Hz scaled by oscillator increment
   factor and pitch (Pinc); a is amplitude; */

	for ( n = 0; n < I; n++ ) {
	    O[n] += a*table[ (int) address ];

	    address += f;

	    while ( address >= L )
		address -= L;

	    while ( address < 0 )
		address += L;

	    a += ainc;
	    f += finc;
	} 

/* save current values for next iteration */

	lastfreq[chan] = C[freq];
	lastamp[chan] = C[amp];
	index[chan] = address;
    }
}

