#include <stdlib.h>
#include <stdio.h>
#include "../PVLIB/pv.h"
#define THRESH (.00000001)
#define GAIN (20000.)
#define debug (0)
complex zero = { 0., 0. };
complex one = { 1., 0. };
float IPI;
float TWOPI;
float synt = 0.;
extern char *arg_option;
/*  
*   IDENTICAL TO SMITH WITH SPECTRUM MULTIPLIED
*   BY INPUT SOUNDFILE
*/
/* 1st WORKING COPY    */
main(argc, argv)
    int argc; char *argv[];
{
    int 	R=44100,
		N=1024,
		N2,
		Nw = 8192,
		Nw2, 
		D = 1024, 
		I = 1024,
		i,
		in,
		on,
		eof = 0,
		obank = 0,
		aflag = 0,
		sflag = 0;
    float 	P = 0.,
		*Hwin,
		*Wanal,
		*Wsyn,
		*input,
		*winput,
		*buffer,
		*sf_buffer,
		*channel,
		*sf_channel,
		*output;
    char	ch,
		*dbuf;
		int first = 1;
		float odds = .95;
float FDEVmax;
float FDEVmin;
FILE  *openfile();
float randf();
int j;
int multflag = 0;
int freqflag = 0;
float freqdevo=0.01 ;
float duration=0.0, realtime, tadv;
float ampsum1, ampsum2, amp_rescale;
int Seed = 0;
int midflag=0, fflag=0, dflag=0, Aflag=0, Fflag=0;
int sfspectflag = 0;
char fname[128];
float *filt1, *filt2, *nowfilt;
float *multfilt;
float minseg=.1, maxseg=1.;
int Nframes, framecount, minframe=5, maxframe=70;
float phaseinc, freq, finescale=.1;
FILE *fp, *fopen();
int flen, ipos;
int count = 0;
int hoop;
if( isatty(1) )
   usage(1);
    while( (ch= crack( argc, argv, "R|N|M|D|I|d|u|l|s|h|o|f|m|x|", 0  )) != NULL ) {
	switch(ch) {
	    case 'R':	R = atoi(arg_option);
			break;
	    case 'N':	N = atoi(arg_option);
			break;
	    case 'M':	Nw = atoi(arg_option);
			break;
	    case 'D':	D = atoi(arg_option);
			break;
	    case 'I':	I = atoi(arg_option);
			break;
	    case 'u':	minseg = atof(arg_option);
	                 break;
	    case 'l':	maxseg = atof(arg_option);
	                 break;
	    case 'o':	odds = atof(arg_option);
	                 break;
	    case 'f':	finescale = atof(arg_option);
	                 break;
	    case 'm':	multflag = 1;
	                strcpy(fname, arg_option);
	                break;
	    case 'x':	 freqdevo = atof(arg_option);
	                 break;
	    case 's':	Seed = atoi(arg_option);
	                 break;
	    case 'h':	usage(1);
	}
    }
    if( freqdevo != 0.0 ){
	FDEVmax = 1.0 + freqdevo;
	FDEVmin = 1.0 / FDEVmax ;
	freqflag = 1;
    }
    tadv = (float)I/(float)R ;
    duration += tadv;
    framecount = Nframes = 0;
    if( Seed == 0 )
       Seed = time( 0 );
    srandom( Seed );
    fprintf(stderr,"seed is %d\n",Seed);
    if (Nw == 0)
	Nw = N;
    minframe = sec2frame( minseg, I, R );
    if( minframe < 1 ){
       minframe = 1;
       fprintf(stderr,"minimum frame set to 1\n");
    }
    maxframe = sec2frame( maxseg, I, R );
    if (aflag && sflag) {
	fprintf(stderr,"specify either -a or -s not both\n");
	exit(1);
    }
    if (aflag)
	I = 0;
    else
	if (I == 0)
	    I = D;

    if (sflag)
      D = 0;

    IPI = 4.*atan(1.);
    TWOPI = 8.*atan(1.);
    obank = P != 0.;
    N2 = N>>1;
    Nw2 = Nw>>1;
    if( multflag ){
       fp = openfile( fname, "r" );
       flen = readin( fp, &multfilt ); 
       if( flen != N2 ){
          fprintf(stderr,"filter function must be of length %d\n",N2);
	  exit(-1);
	  }
    }
    Wanal = (float *) space( Nw, sizeof(float) );	
    Wsyn = (float *) space( Nw, sizeof(float) );
    input = (float *) space( Nw, sizeof(float) );
    Hwin = (float *) space( Nw, sizeof(float) );
    winput = (float *) space( Nw, sizeof(float) );
    buffer = (float *) space( N, sizeof(float) );
    sf_buffer = (float *) space( N, sizeof(float) );
    channel = (float *) space( N+2, sizeof(float) );
    sf_channel = (float *) space( N+2, sizeof(float) );
    output = (float *) space( Nw, sizeof(float) );
    filt1 = (float *) space(N2, sizeof(float) );
    filt2 = (float *) space(N2, sizeof(float) );
    nowfilt = (float *) space(N2, sizeof(float) );
    phaseinc = (float) R/(float) N ;
    phaseinc *= 2.0;
    freq = phaseinc;
    channel[i] = 0.0;
    for( i = 3; i < N ; i+= 2 ){
       channel[i] = freqflag ? freq * (randf(FDEVmin, FDEVmax)) : freq;
       freq += phaseinc;
    }
    makewindows( Hwin, Wanal, Wsyn, Nw, N, I, obank );
    in = -Nw;
    if ( D )
	on = (in*I)/D;
    else
	on = in;
if( !multflag ){
   genfunc( filt1, N2, odds, finescale );
   genfunc( filt2, N2, odds, finescale ); 
}
else{
   mgenfunc( filt1, N2, odds, finescale, multfilt );
   mgenfunc( filt2, N2, odds, finescale, multfilt ); 
}
Nframes = randi( minframe, maxframe );
framecount = 0;
    while ( !eof ) {
      in += D ;
      on += I ;
      /* READ ANALYSIS DATA    */
      if ( D == 0 ) {
        for ( hoop=0; hoop < N+2; hoop++ ) {
	   if (fread(sf_channel+hoop,sizeof(float),1,stdin) <= 0 )
	      eof = 1;
	  }  
	} 
	/* OR PERFORM ANALYSIS   */
	else {
	   eof = shiftin( input, Nw, D ) ;
	   fold( input, Wanal, Nw, buffer, N, in ) ;
	   rfft( buffer, N2, FORWARD ) ;
	   leanconvert( buffer, sf_channel, N2, D, R ) ;
	}
      /* RESET FREQUENCY VALUES   */
      if( freqflag ){
         freq = phaseinc;
         for( i = 3; i < N ; i+= 2 ){
            channel[i] = freq * (randf(FDEVmin, FDEVmax));
            freq += phaseinc;
         }
   }
   if( framecount == Nframes ){
      framecount = 0;
      Nframes = randi( minframe, maxframe );
      cpyfunc( filt1, filt2, N2 ); /* copies filt2 to filt1    */
      if( multflag )
         mgenfunc( filt2, N2, odds, finescale, multfilt );
      else genfunc( filt2, N2, odds, finescale ); 
   }
   interpfunc( nowfilt, filt1, filt2, N2, Nframes, framecount );
   setamp( channel, nowfilt, N2 );
   /* MULTIPLY SPECTRA HERE     */
      for(i = 0; i < N/2 ; i+= 2 )
          channel[i] = sf_channel[i] * channel[i];
       

   if(debug)
   for(i = 1; i < N/2 ; i += 2 )
     fprintf(stderr,"amp %.15f  freq %f\n", channel[i-1],channel[i] ); 
 
      leanunconvert( channel, buffer, N2, I, R );
      rfft( buffer, N2, INVERSE );
      overlapadd( buffer, N, Wsyn, output, Nw, on );
      shiftout( output, Nw, I, on );
      ++framecount;
    }
    fprintf(stderr,"WESSON: CROSS SYNTHESIS COMPLETED\n");
    exit(0);
}



cpyfunc( dest, src, N )
float dest[], src[];
int N;
{
int i;
   for(i = 0; i < N; i++ )
      dest[i] = src[i];
}

genfunc( func, N, odds, fine )
float func[];
int N;
float odds, fine;
{
float randf();
int i;
float val;
static float scale;
static float finescale;
static int first = 1;
static int fineflag = 1;
if(first){
   scale = GAIN / (((float) N) * 8.0);
   if( fine < THRESH ){
      fineflag = 0;  
      fprintf(stderr,"WESSON: Not making fine spectrum\n");
      }
   else finescale = scale * fine ;
   first = 0;

}
   for( i = 0; i < N; i++ ){
      val = randf(0.0, 1.0 );
      if( val > odds )
         func[i] = randf( 0.,scale );
      else if( fineflag )
         func[i] = randf( 0., finescale ) ;
      else func[i] = 0.0 ;
   }
}
mgenfunc( func, N, odds, fine, filt )
float func[]; float filt[];
int N;
float odds, fine;
{
float randf();
int i;
float val;
static float scale;
static float finescale;
static int fineflag = 1;
static int first = 1;
if(first){
   scale = GAIN / (((float) N) * 8.0);
   if( fine < THRESH ){
      fineflag = 0;  
         fprintf(stderr,"WESSON: Not making fine spectrum\n");
   }
   else finescale = scale * fine ;
   first = 0;
}
   for( i = 0; i < N; i++ ){
      if( filt[i] < THRESH )
         func[i] = 0.0 ;
      else{
      val = randf(0.0, 1.0 );
      if( val > odds )
         func[i] = (randf( 0.,scale )) * filt[i];
      else if( fineflag )
         func[i] = (randf( 0., finescale )) * filt[i] ;
      else func[i] = 0.0 ;
      }
   }
}

interpfunc( dest, a, b, dimen, N, count )
float dest[], a[], b[];
int dimen, N, count;
{
int i;
float amult, bmult;
   if( count == 0 )
      for( i = 0; i < dimen; i++ )
         dest[i] = a[i];
   else{
      bmult = (float) count/ (float) N;
      amult = 1.0 - bmult;
      for(i = 0; i< dimen; i++)
         dest[i] = a[i]*amult + b[i]*bmult;
   }
}

setamp( chan, filt, N2 )
float chan[], filt[];
int N2;
{
   int i, j;
   for( i = 0, j = 0; i < N2; i += 2, j++ )
      chan[i] = filt[j];
}
int sec2frame( sec, I, R )
float sec; int I, R ;
{
float Itime;
   Itime = (float) I / (float) R ;
   return( sec / Itime ) ;
}

float randf( min, max ) float min, max;
{
return( ((float)(random()/(float)0x7fffffff)*(max-min))+min );
}
int randi( min, max ) int min, max;
{
return( ((random()%(max-min))+min ));
}
usage(woof)
{
    fprintf(stderr, "%s",
	"wesson:  cross synthesis with random spectra\n"
	"wesson   [flags] < floatsams > floatsams\n"
	"	R:	sampling rate [44100]\n"
	"	N:	fft length [1024]\n"
	"	M:	window size in samples [8192]\n"
	"	D:	decimation factor in samples [1024]\n"
	"	I:	interpolation factor in samples [1024]\n"
	"	l:	minimum duration[secs.] to interpolate filter [.1]\n"
	"	u:	maximum duration[secs.] to interpolate filter [1.0]\n"
	"	o:	odds against amplitude appearing [.95]\n"
	"	f:	scaling for fine components[.1]\n"
	"	m:	optional function[N/2] for rescaling spectrum\n"
	"	x:	bin frequency deviation percentage [0.01]\n"
	"	s:	optional seed\n"
	);
    exit(woof);
}
