
#include <stdio.h>
#include <fcntl.h>
#include <linux/soundcard.h>
#include <malloc.h>
#include <math.h>
#include <stdlib.h>

#include "play.h"
#include "xplay.h"

char * sin_wave(char *edit_buf, char * temp_buf,Marker mark)
{
wave_header head;
int  headsize;
    unsigned long   samples,samplesize,
                    n;
    int             i,j;
float          pi = 3.14159265,periods;
float    TWOPI = pi*2;
    float arg;
   char    d;

memcpy(&head, edit_buf, sizeof(head));
headsize = sizeof(head);
    samples = (mark.x2 - mark.x1);    
periods=(float)(samples/head.sample_fq);
      arg = (mark.freq*TWOPI) / head.sample_fq;
if (mark.mod==1){
   for (i = 0  ; i <= samples; i++){
   d =(char)floor((float)(edit_buf[headsize+mark.x1+i] *(sin(i*arg))));
        edit_buf[headsize+mark.x1+i]=d;
}
}
else {
/* Loop over the length of the array */
        for (i = 0  ; i <= samples; i++){
          d =(char)floor((float)(mark.amplitude *(sin(i*arg))));
        edit_buf[headsize+mark.x1+i]=d;
}
}
return(edit_buf);
}



char * sqr_wave(char *edit_buf,char *temp_buf,Marker mark)
{
    unsigned long   samples,
                    n,j;
int  headsize;
wave_header head;
float  periods;

memcpy(&head, edit_buf, sizeof(head));
headsize = sizeof(head);
samples = (mark.x2 - mark.x1);
periods=(float)((samples)/(mark.freq*head.sample_fq));
if (mark.mod==1){
}

for(n=0 ; n<mark.freq ; n++){
for(j=0 ; j<(samples/(mark.freq*2)) ; j++){
edit_buf[headsize+mark.x1+j]=0;
     }

for(j=(samples/(mark.freq*2)) ; j<samples ; j++){
edit_buf[headsize+mark.x1+j]=mark.amplitude;
    }
}

    for (n = 0; n < samples; ++n)
edit_buf[headsize+n+20] = temp_buf[samples - n -1 ];
return(edit_buf);
}

char * tri_wave(char *edit_buf,char *temp_buf,Marker mark)
{
    unsigned long   samples,
                    n;
int  headsize;
wave_header head;

memcpy(&head, edit_buf, sizeof(head));
headsize = sizeof(head);
    samples = head.data_length-(headsize+20);
    for (n = 0; n < samples; ++n)
edit_buf[headsize+n+20] = temp_buf[samples - n -1 ];
return(edit_buf);
}

char * saw_wave(char *edit_buf,char *temp_buf, int period,int amplitude,int mod, Marker mark)
{
    unsigned long   samples,
                    n;
int  headsize;
wave_header head;

memcpy(&head, edit_buf, sizeof(head));
headsize = sizeof(head);
    samples = head.data_length-(headsize+20);
    for (n = 0; n < samples; ++n)
edit_buf[headsize+n+20] = temp_buf[samples - n -1 ];
return(edit_buf);
}

char *  changeWave_envelope( char *edit_buf,char *temp_buf,int wave_envelope[500][2], Marker mark )
{
    int                tsmp;
    unsigned long   samples,
                    n;
    int             i;
    float           multfactor,
                    xmult;
int  headsize;
wave_header head;

memcpy(&head, edit_buf, sizeof(head));
headsize = sizeof(head);
    samples = head.data_length-(headsize+20);

    xmult = (samples / 500);
    (wave_envelope[0][1]) = 0;
    (wave_envelope[0][2]) = 110;
    multfactor = ((float) ((wave_envelope[0][2]) - 40) / 70);
    for (n = 0L; n < samples; n++) {
        i = (int) ((n / xmult));
         if ((wave_envelope[i][1]) == i) {
            multfactor = ((float) ((wave_envelope[i][2]) - 40) / (float) 70);
           tsmp = (int) (multfactor * temp_buf[n]);
            edit_buf[n] = tsmp;
        } else {

            tsmp = (int) (multfactor * temp_buf[n]);
            edit_buf[n] = tsmp;

        }
    }

}

char * changeWave_filter( char *edit_buf,char *temp_buf,
int wave_envelope_filter[500][2],Marker mark)
{
    int          smp[2 * 100 + 1],
                    tsmp;
    unsigned long   samples,
                    n;
    int             i,
                    cutoff,
                    k;
    float           multfactor,
                    xmult;

int  headsize;
wave_header head;

memcpy(&head, edit_buf, sizeof(head));
headsize = sizeof(head);
    samples = head.data_length-(headsize+20);

    xmult = (samples / 500);

    (wave_envelope_filter[0][1]) = 0;
    (wave_envelope_filter[0][2]) = 110;
    multfactor = ((float) ((wave_envelope_filter[0][2]) - 40) / 5);
    for (i = 0; i < cutoff; ++i)
        smp[i] = 128;
    for (n = 0L; n < samples; n++) {
        k = (int) ((n / xmult));
        if ((wave_envelope_filter[k][1]) == k) {
            multfactor = (float) ((float) ((wave_envelope_filter[k][2]) - 40) / 5);
            cutoff = (int)(multfactor);

        }
        for (i = cutoff - 1; i > 0; --i)
            smp[i] = smp[i - 1];
        smp[0] = (temp_buf[n]);

        for (tsmp = 0, i = 0; i < cutoff; ++i) {
            tsmp += smp[i];
        }
        tsmp = (tsmp / cutoff);
        edit_buf[n] = (char) max(min(tsmp, 255), 0);
     }   
}

