/* creates the widget hierarchy of xplay */

#include <stdio.h>
#include "xplay.h"

void create_widget_hierarchy(Widget top_level, 
                             char *speed_buf, char *limit_buf,char *iface_name[20], 
                             char *song_name_buf1, char *song_name_buf2,
			     graph_ctx *g_ctx,
			     graph_ctx *g_ctx1 )
{
   Arg args[3];
   Pixmap play_btn_pixmap, record_btn_pixmap, stop_btn_pixmap,ffwd_btn_pixmap,rwnd_btn_pixmap;
   Pixmap zoom_in_btn_pixmap, zoom_out_btn_pixmap;
   Display *dpy;
   Widget w;


   dpy = XtDisplay(top_level);






   play_btn_pixmap = XCreateBitmapFromData(dpy, DefaultRootWindow(dpy), 
   				play_bits, play_width, play_height);
   record_btn_pixmap = XCreateBitmapFromData(dpy, DefaultRootWindow(dpy), 
   				record_bits, record_width, record_height);
   stop_btn_pixmap = XCreateBitmapFromData(dpy, DefaultRootWindow(dpy), 
   				stop_bits, stop_width, stop_height);
   ffwd_btn_pixmap = XCreateBitmapFromData(dpy, DefaultRootWindow(dpy),
                                ffwd_bits, ffwd_width, ffwd_height);
   rwnd_btn_pixmap = XCreateBitmapFromData(dpy, DefaultRootWindow(dpy),
                                rwnd_bits, rwnd_width, rwnd_height);
   zoom_in_btn_pixmap = XCreateBitmapFromData(dpy, DefaultRootWindow(dpy), 
   				zoom_in_bits, zoom_in_width, zoom_in_height);
   zoom_out_btn_pixmap = XCreateBitmapFromData(dpy, DefaultRootWindow(dpy), 
   				zoom_out_bits, zoom_out_width, zoom_out_height);

   ww.main_form = MW ("main", formWidgetClass, top_level, NULL);/* main form */
   
   ww.menu_box = MW ("menu_box", boxWidgetClass, ww.main_form, 
      XtNborderWidth, 0, 
      XtNvertDistance, 0,
      XtNhorizDistance, 0,
      XtNorientation, XtorientHorizontal,
      NULL); 							/* menu */

   ww.graph1 = MW ("graph", simpleWidgetClass, ww.main_form, 
      XtNfromVert, ww.menu_box, 
      XtNvertDistance, 0,
      XtNheight, GRAPH_HEIGHT, 
      XtNwidth, GRAPH_WIDTH,
      XtNborderWidth, 1, 
      XtNsensitive, True, NULL);
/*
   create_GC(g_ctx1);			/* create graphics context */

   ww.graph2 = MW ("graph", simpleWidgetClass, ww.main_form,
      XtNfromVert, ww.graph1,
      XtNheight, GRAPH_HEIGHT,
      XtNwidth, GRAPH_WIDTH,
      XtNborderWidth, 1,
      XtNsensitive, True, NULL);

   create_GC(g_ctx,g_ctx1);                    /* create graphics context */

   ww.stop_btn = MW ("stop_btn", commandWidgetClass, ww.main_form, 
      XtNfromVert, ww.graph2, 
      XtNwidth, 40, 
      XtNbitmap, stop_btn_pixmap, 
      XtNsensitive, False, 
      NULL);

   ww.rwnd_btn = MW ("rwnd_btn", commandWidgetClass, ww.main_form,
      XtNfromVert, ww.graph2,
      XtNfromHoriz, ww.stop_btn,
      XtNwidth, 40,
      XtNbitmap, rwnd_btn_pixmap,
      NULL);

   ww.play_btn = MW ("play_btn", commandWidgetClass, ww.main_form, 
      XtNfromVert, ww.graph2, 
      XtNfromHoriz, ww.rwnd_btn, 
      XtNwidth, 40,
      XtNbitmap, play_btn_pixmap, 
      NULL);

   ww.ffwd_btn = MW ("ffwd_btn", commandWidgetClass, ww.main_form,
      XtNfromVert, ww.graph2,
      XtNfromHoriz, ww.play_btn,
      XtNwidth, 40,
      XtNbitmap, ffwd_btn_pixmap,
      NULL);

   ww.record_btn = MW ("record_btn", commandWidgetClass, ww.main_form,
      XtNfromVert, ww.graph2,
      XtNfromHoriz, ww.ffwd_btn,
      XtNwidth, 40,
      XtNbitmap, record_btn_pixmap,
      NULL);

   ww.zoom_out_btn = MW ("zoom_out_btn", commandWidgetClass, ww.main_form, 
      XtNfromVert, ww.graph2, 
      XtNfromHoriz, ww.record_btn, 
      XtNhorizDistance, 40, 
      XtNwidth, 40,
      XtNbitmap, zoom_out_btn_pixmap, 
      NULL);

   ww.zoom_in_btn = MW ("zoom_in_btn", commandWidgetClass, ww.main_form, 
      XtNfromVert, ww.graph2, 
      XtNfromHoriz, ww.zoom_out_btn, 
      XtNwidth, 40,
      XtNbitmap, zoom_in_btn_pixmap, 
      NULL);

   ww.radio_box2 = MW ("radio_box2", boxWidgetClass, ww.main_form, 
      XtNfromVert, ww.stop_btn, 
      XtNvertDistance, 0,
      XtNborderWidth, 0, 
      XtNorientation, XtorientVertical, NULL);

   ww.stereo_btn = MW ("stereo_btn", toggleWidgetClass, ww.radio_box2, 
      XtNstate, False,
      XtNwidth, 40, 
      XtNradioData, "STE",
      XtNlabel, "Stereo", NULL);   

   ww.mono_btn = MW ("mono_btn", toggleWidgetClass, ww.radio_box2, 
      XtNstate, True, 
      XtNwidth, 40,   
      XtNradioGroup, ww.stereo_btn,
      XtNradioData, "MON", 
      XtNlabel, "Mono", NULL);

   XtOverrideTranslations(ww.stereo_btn, XtParseTranslationTable
     		  	     ("<Btn1Down>,<Btn1Up>: set() notify()"));
   XtOverrideTranslations(ww.mono_btn, XtParseTranslationTable
      		  	     ("<Btn1Down>,<Btn1Up>: set() notify()"));


    ww.radio_box3 = MW ("radio_box3", boxWidgetClass, ww.main_form,
      XtNfromVert, ww.ffwd_btn,
      XtNvertDistance, 0,
      XtNfromHoriz, ww.radio_box2, 
      XtNborderWidth, 0,
      XtNorientation, XtorientVertical, NULL);


   ww.graph_1 = MW ("graph_1", toggleWidgetClass, ww.radio_box3,
      XtNstate, False,
      XtNwidth, 40,
      XtNradioData, "buf",
      XtNlabel, "buf1", NULL);

   ww.graph_2 = MW ("graph_2", toggleWidgetClass, ww.radio_box3,
      XtNstate, True,
      XtNwidth, 40,
      XtNradioGroup, ww.graph_1,
      XtNradioData, "GR2",
      XtNlabel, "buf2", NULL);

   XtOverrideTranslations(ww.graph_1, XtParseTranslationTable
                             ("<Btn1Down>,<Btn1Up>: set() notify()"));
   XtOverrideTranslations(ww.graph_2, XtParseTranslationTable
                             ("<Btn1Down>,<Btn1Up>: set() notify()"));

   ww.song_title1 = MW ("song_title1", asciiTextWidgetClass, ww.main_form,
      XtNfromVert, ww.zoom_in_btn,
      XtNvertDistance, 5,    
      XtNfromHoriz, ww.radio_box3,
      XtNstring, song_name_buf1,
      XtNuseStringInPlace, True,
      XtNlength, 30,
      XtNwidth, 160,
      XtNeditType, XawtextRead, NULL);

   ww.song_title2 = MW ("song_title2", asciiTextWidgetClass, ww.main_form,
      XtNfromVert, ww.song_title1,
      XtNfromHoriz, ww.radio_box3,
      XtNstring, song_name_buf2,
      XtNuseStringInPlace, True,
      XtNlength, 30,
      XtNwidth, 160,
      XtNeditType, XawtextRead, NULL);



   ww.speed_label = MW ("speed_label", labelWidgetClass, ww.main_form, 
      XtNfromVert, ww.zoom_in_btn, 
      XtNfromHoriz, ww.song_title2, 
      XtNborderWidth, 0, 
      XtNlabel, "Speed [Hz]: ", NULL);

   ww.speed = MW ("speed", asciiTextWidgetClass, ww.main_form, 
      XtNfromVert, ww.zoom_in_btn, 
      XtNfromHoriz, ww.speed_label, 
      XtNlength, 5, 
      XtNstring, speed_buf, 
      XtNuseStringInPlace, True, 
      XtNwidth, 50, 
      XtNeditType, XawtextEdit, NULL);

   ww.limit_label = MW ("limit_label", labelWidgetClass, ww.main_form, 
      XtNfromVert, ww.speed_label, 
      XtNfromHoriz, ww.song_title2, 
      XtNborderWidth, 0, 
      XtNlabel, "Time [s]: ", NULL);

   ww.limit = MW ("limit", asciiTextWidgetClass, ww.main_form, 
      XtNfromVert, ww.speed, 
      XtNfromHoriz, ww.speed_label, 
      XtNlength, 5, 
      XtNstring, limit_buf, 
      XtNuseStringInPlace, True, 
      XtNwidth, 50, 
      XtNeditType, XawtextEdit, NULL);

   ww.bit_label = MW ("bit_label", labelWidgetClass, ww.main_form, 
      XtNfromVert, ww.zoom_in_btn, 
/*      XtNvertDistance, 10,   */
      XtNfromHoriz, ww.speed, 
      XtNborderWidth, 0, 
      XtNlabel, "Bit/sample: ", NULL);

   ww.radio_box4 = MW ("radio_box4", boxWidgetClass, ww.main_form, 
      XtNfromVert, ww.bit_label, 
      XtNvertDistance, 0,
      XtNfromHoriz, ww.limit,
      XtNborderWidth, 0, 
      XtNorientation, XtorientHorizontal, NULL);

   ww.eight_bit_btn = MW ("eight_bit_btn", toggleWidgetClass, ww.radio_box4, 
      XtNstate, True, 
      XtNwidth, 20,   
      XtNradioData, "08", 
      XtNlabel, "8", NULL);

   ww.twelve_bit_btn = MW ("twelve_bit_btn", toggleWidgetClass, ww.radio_box4, 
      XtNstate, False, 
      XtNwidth, 20,    
      XtNradioData, "12", 
      XtNradioGroup, ww.eight_bit_btn, 
      XtNlabel, "12", NULL);

   ww.sixteen_bit_btn = MW ("sixteen_bit_btn", toggleWidgetClass, ww.radio_box4, 
      XtNstate, False, 
      XtNwidth, 20,   
      XtNradioData, "16", 
      XtNradioGroup, ww.eight_bit_btn, 
      XtNlabel, "16", NULL);

   XtOverrideTranslations(ww.eight_bit_btn, XtParseTranslationTable
      		  	     ("<Btn1Down>,<Btn1Up>: set() notify()"));
   XtOverrideTranslations(ww.twelve_bit_btn, XtParseTranslationTable
      		  	     ("<Btn1Down>,<Btn1Up>: set() notify()"));
   XtOverrideTranslations(ww.sixteen_bit_btn, XtParseTranslationTable
      		  	     ("<Btn1Down>,<Btn1Up>: set() notify()"));

   ww.quit_btn = MW ("quit_btn", commandWidgetClass, ww.main_form, 
      XtNfromVert, ww.graph2, 
      XtNvertDistance, 5, 
      XtNfromHoriz, ww.zoom_in_btn, 
      XtNhorizDistance, 30, 
/*      XtNwidth, 45,
      XtNheight, 25, */
      XtNlabel, "Quit", NULL);

   /* now the menus */

   ww.file_menu_btn = MW ("file_menu_btn", menuButtonWidgetClass, ww.menu_box, 
/*      XtNfromVert, 0, */
      XtNvertDistance, 0, 
      XtNhorizDistance, 0,
      XtNlabel, "File", 
      XtNmenuName, "file_menu", NULL);

   ww.file_menu = XtCreatePopupShell ("file_menu", simpleMenuWidgetClass, 
      ww.file_menu_btn, NULL, 0);

   ww.load_btn = MW ("load_btn", smeBSBObjectClass, ww.file_menu, 
      XtNlabel, "Load...", NULL);
   ww.save_btn = MW ("save_btn", smeBSBObjectClass, ww.file_menu, 
      XtNlabel, "Save...", NULL);
   ww.nothing = MW ("nothing", smeLineObjectClass, ww.file_menu, NULL);
   ww.quit_menu_btn = MW ("quit_menu_btn", smeBSBObjectClass, ww.file_menu, 
      XtNlabel, "Quit", NULL);

   ww.effects_menu_btn = MW ("effects_menu_btn", menuButtonWidgetClass, 
      ww.menu_box, 
      XtNfromVert, 0, 
      XtNvertDistance, 0, XtNlabel, "Effects", 
      XtNmenuName, "effects_menu", NULL);

   ww.effects_menu = XtCreatePopupShell ("effects_menu", simpleMenuWidgetClass, 
      ww.effects_menu_btn, NULL, 0);

   ww.echo_btn = MW ("echo_btn", smeBSBObjectClass, ww.effects_menu, 
      XtNlabel, "Echo...", NULL);
   ww.reverse_btn = MW ("reverse_btn", smeBSBObjectClass, ww.effects_menu,
      XtNlabel, "Reverse...", NULL);
   ww.synthesis_btn = MW ("synthesis_btn", smeBSBObjectClass, ww.effects_menu,
      XtNlabel, "Synth...", NULL);
   ww.lowpass_btn = MW ("lowpass_btn", smeBSBObjectClass, ww.effects_menu,
      XtNlabel, "Filter...", NULL);

ww.interface_menu_btn = MW ("interface_menu_btn", menuButtonWidgetClass,
      ww.menu_box, XtNlabel, "Interface",
      XtNmenuName, "interface_menu", NULL);

   ww.interface_menu = XtCreatePopupShell ("interface_menu", simpleMenuWidgetClass,
      ww.interface_menu_btn, NULL, 0);

   ww.setup_btn = MW ("setup_btn", smeBSBObjectClass, ww.interface_menu,
      XtNlabel, "Setup interface...", NULL);

   ww.run_btn = MW ("run_btn", smeBSBObjectClass, ww.interface_menu,
      XtNlabel, iface_name[0], NULL);

   ww.run_btn1 = MW ("run_btn1", smeBSBObjectClass, ww.interface_menu,
      XtNlabel, iface_name[1], NULL);

   ww.run_btn2 = MW ("run_btn2", smeBSBObjectClass, ww.interface_menu,
      XtNlabel, iface_name[2], NULL);

   ww.run_btn3 = MW ("run_btn3", smeBSBObjectClass, ww.interface_menu,
      XtNlabel, iface_name[3], NULL);

   ww.run_btn4 = MW ("run_btn4", smeBSBObjectClass, ww.interface_menu,
      XtNlabel, iface_name[4], NULL);

   ww.run_btn5 = MW ("run_btn5", smeBSBObjectClass, ww.interface_menu,
      XtNlabel, iface_name[5], NULL);

   ww.run_btn6 = MW ("run_btn6", smeBSBObjectClass, ww.interface_menu,
      XtNlabel, iface_name[6], NULL);


   ww.edit_menu_btn = MW ("edit_menu_btn", menuButtonWidgetClass,
      ww.menu_box, XtNlabel, "Edit",
      XtNmenuName, "edit_menu", NULL);

   ww.edit_menu = XtCreatePopupShell ("edit_menu", simpleMenuWidgetClass,
      ww.edit_menu_btn, NULL, 0);

   ww.cut_btn = MW ("cut_btn", smeBSBObjectClass, ww.edit_menu,
      XtNlabel, "Cut...", NULL);
   ww.copy_btn = MW ("copy_btn", smeBSBObjectClass, ww.edit_menu,
      XtNlabel, "Copy...", NULL);
   ww.paste_btn = MW ("paste_btn", smeBSBObjectClass, ww.edit_menu,
      XtNlabel, "Paste...", NULL);

   /* add the callbacks */

   XtAddCallback (ww.quit_btn, XtNcallback, quit_question, 0);
   XtAddCallback (ww.quit_menu_btn, XtNcallback, quit_question, 0);
   XtAddCallback (ww.stop_btn, XtNcallback, stop_playing, 0);
   XtAddCallback (ww.play_btn, XtNcallback, play_sample, 0);
   XtAddCallback (ww.record_btn, XtNcallback, record_question, 0);
   XtAddCallback (ww.rwnd_btn, XtNcallback, rwnd, 0);
   XtAddCallback (ww.ffwd_btn, XtNcallback, ffwd, 0);
   XtAddCallback (ww.zoom_out_btn, XtNcallback, zoom_out, 0);
   XtAddCallback (ww.zoom_in_btn, XtNcallback, zoom_in, 0);
   XtAddCallback (ww.load_btn, XtNcallback, open_dialog, 0);
   XtAddCallback (ww.save_btn, XtNcallback, open_dialog, 0);
   XtAddCallback (ww.echo_btn, XtNcallback, calculate_echo, 0);
   XtAddCallback (ww.reverse_btn, XtNcallback, calculate_reverse, 0);
   XtAddCallback (ww.synthesis_btn, XtNcallback, calculate_synthesis, 0);
   XtAddCallback (ww.lowpass_btn, XtNcallback, Lowpass, 0);
   XtAddCallback (ww.setup_btn, XtNcallback, interface_dialog, 0);
   XtAddCallback (ww.run_btn, XtNcallback, iface1, 0);
   XtAddCallback (ww.run_btn1, XtNcallback, iface1, 0);
   XtAddCallback (ww.run_btn2, XtNcallback, iface1, 0);
   XtAddCallback (ww.run_btn3, XtNcallback, iface1, 0);
   XtAddCallback (ww.run_btn4, XtNcallback, iface1, 0);
   XtAddCallback (ww.run_btn5, XtNcallback, iface1, 0);
   XtAddCallback (ww.run_btn6, XtNcallback, iface1, 0);
   XtAddCallback (ww.cut_btn, XtNcallback, cut, 0);
   XtAddCallback (ww.copy_btn, XtNcallback, copy, 0);
   XtAddCallback (ww.paste_btn, XtNcallback, paste, 0);
   /* change text in limit widget -> callback */
   XtSetArg(args[0], XtNtextSource, &w);
   XtGetValues(ww.limit, args, 1);
   XtAddCallback (w, XtNcallback, calculate_limit_borders, 0);
}

void create_GC(graph_ctx *g_ctx, graph_ctx *g_ctx1)
{
   XGCValues xgcv;
   XGCValues xgcv1;

   /* GC for green amplitude */
   xgcv.foreground = define_color(ww.main_form, "green");
   xgcv.background = define_color(ww.main_form, "black");
   xgcv.line_width = 1;

   /* GC for green amplitude */
   xgcv1.foreground = define_color(ww.main_form, "green");
   xgcv1.background = define_color(ww.main_form, "black");
   xgcv1.line_width = 1;


   g_ctx1->graph_GC = XtGetGC(ww.graph1, GCForeground | GCBackground | GCLineWidth, &xgcv1);
   g_ctx->graph_GC = XtGetGC(ww.graph2, GCForeground | GCBackground | GCLineWidth, &xgcv);

   /* GC for border lines */
   xgcv.foreground = define_color(ww.main_form, "red");
   xgcv.background = define_color(ww.main_form, "black");
   xgcv.line_width = 1;
   xgcv.line_style = LineOnOffDash;

   /* GC for border lines */
   xgcv1.foreground = define_color(ww.main_form, "red");
   xgcv1.background = define_color(ww.main_form, "black");
   xgcv1.line_width = 1;
   xgcv1.line_style = LineOnOffDash;


   g_ctx1->line_GC = XtGetGC(ww.graph1, GCForeground | GCBackground | GCLineWidth |
                     GCLineStyle, &xgcv1);
   g_ctx->line_GC = XtGetGC(ww.graph2, GCForeground | GCBackground | GCLineWidth |
                     GCLineStyle, &xgcv);

   /* GC for deleting border lines */
   xgcv.foreground = define_color(ww.main_form, "black");
   xgcv.background = define_color(ww.main_form, "black");
   xgcv.line_width = 1;

   /* GC for deleting border lines */
   xgcv1.foreground = define_color(ww.main_form, "black");
   xgcv1.background = define_color(ww.main_form, "black");
   xgcv1.line_width = 1;


   g_ctx1->delete_line_GC = XtGetGC(ww.graph1, GCForeground | GCBackground | GCLineWidth,  
                     &xgcv1);
   g_ctx->delete_line_GC = XtGetGC(ww.graph2, GCForeground | GCBackground | GCLineWidth,
                     &xgcv);

}

int define_color(Widget w, char *color)
{
   XColor exact_color, screen_color;
   Screen *screen;
   Display *dpy;

   dpy = XtDisplay(w);
   screen = XDefaultScreenOfDisplay(dpy);

   if ((XDefaultVisualOfScreen(screen))->class == TrueColor 
        ||  (XDefaultVisualOfScreen(screen))->class == PseudoColor
        ||  (XDefaultVisualOfScreen(screen))->class == DirectColor
        ||  (XDefaultVisualOfScreen(screen))->class == StaticColor)

      if (XAllocNamedColor(dpy, XDefaultColormapOfScreen(screen),
          color, &screen_color, &exact_color))
         return screen_color.pixel; 
      else
         fprintf(stderr, "Color not allocated!\n");
   else 
      if (!strcmp(color, "black")) 
         return XBlackPixelOfScreen(screen);
      else
         return XWhitePixelOfScreen(screen);
}

