#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "lxt.h"

XImage *
image_create(dpy, fg_pixel, bg_pixel, bits, width, height, depth)
/*
   User-callable function.
   Create an XImage from data
   written by the X11R3 bitmap program.
*/
Display *dpy;
unsigned long fg_pixel, bg_pixel;
char *bits;
int width, height, depth;
{
	XImage *im;
	Visual *v;
	int col, line, i, format;
	char *c, copy;
	char mask;
#ifdef sun
	char *pix, fg, bg;
#endif

	v= DefaultVisual(dpy, DefaultScreen(dpy));
	switch (depth) {
	case 1:
		if ((im= XCreateImage(dpy, v, depth, XYPixmap, 0, bits, width, height, 8, 0)) == (XImage *) NULL) {
			(void) fprintf(stderr, "image_create: image creation error\n");
			return((XImage *) NULL);
		}
		im->byte_order= im->bitmap_bit_order= LSBFirst;
		for (line= 0; line < height; line++) {
			for (col= 0; col < width; col++) {
				if (XGetPixel(im, col, line) == (unsigned long) 1)
					XPutPixel(im, col, line, fg_pixel);
				else
					XPutPixel(im, col, line, bg_pixel);
			}
		}
		break;

	case 2:
		format= ZPixmap;
		if ((im= XCreateImage(dpy, v, depth, format, 0, (char *) NULL, width, height, 8, 0)) == (XImage *) NULL) {
			(void) fprintf(stderr, "image_create: image creation error\n");
			return((XImage *) NULL);
		}
		if ((im->data= calloc((unsigned) (im->bytes_per_line*height), sizeof(char))) == (char *) NULL) {
			(void) fprintf(stderr, "image_create: memory allocation error\n");
			XDestroyImage(im);
			return((XImage *) NULL);
		}
		c= bits;
		mask= 0x01;
		copy= *c;
		for (line= 0; line < height; line++) {
			i= 8;
			for (col= 0; col < width; col++) {
				if (mask & copy)
					XPutPixel(im, col, line, fg_pixel);
				else
					XPutPixel(im, col, line, bg_pixel);
				copy= copy >> 1;
				i--;
				if ((i == 0) && (col < width-1)) {
					c++;
					copy= *c;
					i= 8;
				}
			}
			c++;
			copy= *c;
		}
		break;

	case 8:
		format= ZPixmap;
		if ((im= XCreateImage(dpy, v, depth, format, 0, (char *) NULL, width, height, 8, 0)) == (XImage *) NULL) {
			(void) fprintf(stderr, "image_create: image creation error\n");
			return((XImage *) NULL);
		}
		if ((im->data= calloc((unsigned) (im->bytes_per_line*height), sizeof(char))) == (char *) NULL) {
			(void) fprintf(stderr, "image_create: memory allocation error\n");
			XDestroyImage(im);
			return((XImage *) NULL);
		}
#ifdef sun
		fg= (char) fg_pixel;
		bg= (char) bg_pixel;
#endif
		c= bits;
		mask= 0x01;
		copy= *c;
		for (line= 0; line < height; line++) {
#ifdef sun
			pix= im->data+(line*im->bytes_per_line);
#endif
			i= 8;
			for (col= 0; col < width; col++) {
				if (mask & copy) {
#ifdef sun
					*pix= fg;
					pix++;
#else
					XPutPixel(im, col, line, fg_pixel);
#endif
				}
				else {
#ifdef sun
					*pix= bg;
					pix++;
#else
					XPutPixel(im, col, line, bg_pixel);
#endif
				}
				copy= copy >> 1;
				i--;
				if ((i == 0) && (col < width-1)) {
					c++;
					copy= *c;
					i= 8;
				}
			}
			c++;
			copy= *c;
		}
		break;
	default:
		(void) fprintf(stderr, "image_create: depth must be 1, 2 or 8\n");
		return((XImage *) NULL);
		break;
	}
	return(im);
}
