#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "lxt.h"

extern boolean xp_fullredraw;
extern Panel_item *xpenum_selpanelitem;

int
xpcycle_idef_proc(p, pi)
/*
   Internal function.
   Initialize defaults for a cycle item.
*/
Panel *p;
Panel_item *pi;
{
	pi->xpi_item.xpi_enum.xpenum_val= (0x1 << LXPDEF_ENUMVAL);
	pi->xpi_item.xpi_enum.xpenum_sel= (xp_esel *) NULL;
	pi->xpi_item.xpi_enum.xpenum_list= (xp_esel *) NULL;
	pi->xpi_item.xpi_enum.xpenum_flags= LXPENUM_DISPCURRSEL;
	return(LX_SUCCESS);
}

int
xpcycle_sz_proc(p, pi)
/*
   Internal function.
   Sizes a cycle item.
*/
Panel *p;
Panel_item *pi;
{
	int font_ht, w, h, maxw, maxh, cw;
	xp_esel *es;
	XImage *cycle;

	pi->xpi_w= pi->xpi_h= 0;
	font_ht= pi->xpi_font->max_bounds.ascent+pi->xpi_font->max_bounds.descent;
	cycle= pi->xpi_item.xpi_enum.xpenum_cycle;
	if (pi->xpi_image != (XImage *) NULL) {
		pi->xpi_w= pi->xpi_image->width;
		pi->xpi_h= pi->xpi_image->height;
	}
	else if (pi->xpi_str != (char *) NULL) {
		pi->xpi_w= XTextWidth(pi->xpi_font, pi->xpi_str, strlen(pi->xpi_str));
		pi->xpi_h= font_ht;
	}
	cw= XTextWidth(pi->xpi_font, "X", strlen("x"));
	pi->xpi_w+= cycle->width+(2*cw);

	/* get maximum size of all value strings and images */
	maxw= maxh= 0;
	for (es= pi->xpi_item.xpi_enum.xpenum_list; es != (xp_esel *) NULL; es= es->xpesel_next) {
		if (es->xpesel_image != (XImage *) NULL) {
			w= es->xpesel_image->width;
			h= es->xpesel_image->height;
		}
		else if (es->xpesel_str != (char *) NULL) {
			w= XTextWidth(pi->xpi_font, es->xpesel_str, strlen(es->xpesel_str));
			h= font_ht;
		}
		if (maxw < w)
			maxw= w;
		if (maxh < h)
			maxh= h;
	}

	pi->xpi_w+= maxw;
	if (pi->xpi_h < maxh)
		pi->xpi_h= maxh;
	if (pi->xpi_h < cycle->height)
		pi->xpi_h= cycle->height;

	return(LX_SUCCESS);
}

void
xpcycle_drw_proc(p, pi)
/*
   Internal function.
   Plots a cycle item onto the backing store.
*/
Panel *p;
Panel_item *pi;
{
	int ty, my, iy, x, y, font_ht, cw;
	xp_enum *xpe;
	XImage *cycle;

	if (!xp_fullredraw)
		XFillRectangle(p->xp_dpy, p->xp_ppm, pi->xpi_cgc, pi->xpi_x, pi->xpi_y, pi->xpi_w, pi->xpi_h);
	if (pi->xpi_state == LXPI_INACTIVE)
		return;

	xpe= (xp_enum *) &(pi->xpi_item.xpi_enum);
	cycle= xpe->xpenum_cycle;
	if (pi->xpi_h > cycle->height)
		my= (pi->xpi_h/2)-(cycle->height/2);
	else
		my= 0;
	font_ht= pi->xpi_font->max_bounds.ascent+pi->xpi_font->max_bounds.descent;
	cw= XTextWidth(pi->xpi_font, "X", strlen("x"));
	ty= my+(cycle->height/2)-(font_ht/2)+pi->xpi_font->max_bounds.ascent;
	x= pi->xpi_x;
	y= pi->xpi_y;

	/* attempt to draw xpi_image */
	if (pi->xpi_image != (XImage *) NULL) {
		iy= my+(cycle->height/2)-(pi->xpi_image->height/2);
		XPutImage(p->xp_dpy, p->xp_ppm, pi->xpi_gc, pi->xpi_image, 0, 0, x, y+iy, pi->xpi_image->width, pi->xpi_image->height);
		x+= pi->xpi_image->width+cw;
	}

	/* else attempt to draw xpi_str */
	else if (pi->xpi_str != (char *) NULL) {
		if (strlen(pi->xpi_str) > 0) {
			XDrawString(p->xp_dpy, p->xp_ppm, pi->xpi_gc, x, y+ty, pi->xpi_str, strlen(pi->xpi_str));
			x+= XTextWidth(pi->xpi_font, pi->xpi_str, strlen(pi->xpi_str))+cw;
		}
	}

	/* draw cycle mark */
	XPutImage(p->xp_dpy, p->xp_ppm, pi->xpi_gc, cycle, 0, 0, x, y+my, cycle->width, cycle->height);
	x+= cycle->width+cw;

	if (xpe->xpenum_sel == (xp_esel *) NULL)
		return;

	/* attempt to draw value image */
	if (xpe->xpenum_sel->xpesel_image != (XImage *) NULL) {
		iy= my+(cycle->height/2)-(xpe->xpenum_sel->xpesel_image->height/2);
		XPutImage(p->xp_dpy, p->xp_ppm, pi->xpi_gc, pi->xpi_image, 0, 0, x, y+iy, pi->xpi_image->width, pi->xpi_image->height);
	}

	/* else attempt to draw value str */
	else if (xpe->xpenum_sel->xpesel_str != (char *) NULL) {
		if (strlen(xpe->xpenum_sel->xpesel_str) > 0)
			XDrawString(p->xp_dpy, p->xp_ppm, pi->xpi_gc, x, y+ty, xpe->xpenum_sel->xpesel_str, strlen(xpe->xpenum_sel->xpesel_str));
	}
}

void
xpcycle_bp_proc(p, pi, evt)
/*
   Internal function.
   Process button press on cycle item.
*/
Panel *p;
Panel_item *pi;
XButtonPressedEvent *evt;
{
	xp_enum *xpe;
	int old, new;
	int xpenum_value();
	void xpcycle_drw_proc(), xpi_std_dsp_proc();
	void xpenum_adj_menu();

	xpe= (xp_enum *) &(pi->xpi_item.xpi_enum);
	if (xpe->xpenum_sel == (xp_esel *) NULL)
		return;

	switch (evt->button) {
	case Button1:
	case Button2:
		if (xpe->xpenum_sel->xpesel_next != (xp_esel *) NULL)
			xpe->xpenum_sel= xpe->xpenum_sel->xpesel_next;
		else
			xpe->xpenum_sel= xpe->xpenum_list;
		xpe->xpenum_val= (0x1 << xpe->xpenum_sel->xpesel_ord);
		xpenum_adj_menu(pi);
		xpcycle_drw_proc(p, pi);
		xpi_std_dsp_proc(p, pi);
		break;
	case Button3:
		if (pi->xpi_menu == (Menu *) NULL)
			return;
		if (pi->xpi_menu->xm_items == (Menu_itemptr *) NULL)
			return;
		old= xpenum_value(pi);
		xpenum_selpanelitem= pi;
		menu_show(pi->xpi_menu, evt);
		new= xpenum_value(pi);
		if (old != new) {
			xpcycle_drw_proc(p, pi);
			xpi_std_dsp_proc(p, pi);
		}
		break;
	default:
		break;
	}
	return;
}
