#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "lxt.h"

Panel_item *xpenum_selpanelitem;

int
xpenum_idef_proc(p, pi)
/*
   Internal function.
   Initialize defaults for an enum item.
*/
Panel *p;
Panel_item *pi;
{
	int xpchoice_idef_proc(), xpcycle_idef_proc(), xptoggle_idef_proc();

	pi->xpi_item.xpi_enum.xpenum_choicemark= (XImage *) NULL;
	pi->xpi_item.xpi_enum.xpenum_choicenomark= (XImage *) NULL;
	pi->xpi_item.xpi_enum.xpenum_cycle= (XImage *) NULL;
	pi->xpi_item.xpi_enum.xpenum_togglemark= (XImage *) NULL;
	pi->xpi_item.xpi_enum.xpenum_togglenomark= (XImage *) NULL;

	switch (pi->xpi_type) {
	case LXPI_CHOICE:
		return(xpchoice_idef_proc(p, pi));
		break;
	case LXPI_CYCLE:
		return(xpcycle_idef_proc(p, pi));
		break;
	case LXPI_TOGGLE:
		return(xptoggle_idef_proc(p, pi));
		break;
	default:
		break;
	}
	return(LX_ERROR);
}

int
xpenum_dst_proc(pi)
/*
   Internal function.
   Destroys an enum item.
*/
Panel_item *pi;
{
	xp_esel *es, *fs;
	Menu_itemptr *mip;

	/* destroy menu and its items */
	if (pi->xpi_menu != (Menu *) NULL) {
		for (mip= pi->xpi_menu->xm_items; mip != (Menu_itemptr *) NULL; mip= mip->xmip_next)
			(void) menuitem_destroy(mip->xmip_item);
		(void) menu_destroy(pi->xpi_menu);
	}

	if (pi->xpi_item.xpi_enum.xpenum_choicemark != (XImage *) NULL)
		XDestroyImage(pi->xpi_item.xpi_enum.xpenum_choicemark);
	if (pi->xpi_item.xpi_enum.xpenum_choicenomark != (XImage *) NULL)
		XDestroyImage(pi->xpi_item.xpi_enum.xpenum_choicenomark);
	if (pi->xpi_item.xpi_enum.xpenum_cycle != (XImage *) NULL)
		XDestroyImage(pi->xpi_item.xpi_enum.xpenum_cycle);
	if (pi->xpi_item.xpi_enum.xpenum_togglemark != (XImage *) NULL)
		XDestroyImage(pi->xpi_item.xpi_enum.xpenum_togglemark);
	if (pi->xpi_item.xpi_enum.xpenum_togglenomark != (XImage *) NULL)
		XDestroyImage(pi->xpi_item.xpi_enum.xpenum_togglenomark);

	for (es= pi->xpi_item.xpi_enum.xpenum_list; es != (xp_esel *) NULL; es= fs) {
		if (es->xpesel_str != (char *) NULL)
			cfree(es->xpesel_str);
		fs= es->xpesel_next;
		cfree((char *) es);
	}
	return(LX_SUCCESS);
}

int
xpenum_sz_proc(p, pi)
/*
   Internal function.
   Sizes an enum item.
*/
Panel *p;
Panel_item *pi;
{
	int xpchoice_sz_proc(), xpcycle_sz_proc(), xptoggle_sz_proc();

	if (p == (Panel *) NULL) {
		(void) fprintf(stderr, "xpenum_sz_proc: null panel\n");
		return(LX_ERROR);
	}
	if (pi == (Panel_item *) NULL) {
		(void) fprintf(stderr, "xpenum_sz_proc: null item\n");
		return(LX_ERROR);
	}
	switch (pi->xpi_type) {
	case LXPI_CHOICE:
		return(xpchoice_sz_proc(p, pi));
		break;
	case LXPI_CYCLE:
		return(xpcycle_sz_proc(p, pi));
		break;
	case LXPI_TOGGLE:
		return(xptoggle_sz_proc(p, pi));
		break;
	default:
		break;
	}
	return(LX_ERROR);
}

void
xpenum_drw_proc(p, pi)
/*
   Internal function.
   Plots an enum item onto the backing store.
*/
Panel *p;
Panel_item *pi;
{
	void xpchoice_drw_proc(), xpcycle_drw_proc(), xptoggle_drw_proc();

	switch (pi->xpi_type) {
	case LXPI_CHOICE:
		xpchoice_drw_proc(p, pi);
		break;
	case LXPI_CYCLE:
		xpcycle_drw_proc(p, pi);
		break;
	case LXPI_TOGGLE:
		xptoggle_drw_proc(p, pi);
		break;
	default:
		break;
	}
}

void
xpenum_bp_proc(p, pi, evt)
/*
   Internal function.
   Process button press on enum item.
*/
Panel *p;
Panel_item *pi;
XButtonPressedEvent *evt;
{
	void xpchoice_bp_proc(), xpcycle_bp_proc(), xptoggle_bp_proc();

	switch (pi->xpi_type) {
	case LXPI_CHOICE:
		xpchoice_bp_proc(p, pi, evt);
		break;
	case LXPI_CYCLE:
		xpcycle_bp_proc(p, pi, evt);
		break;
	case LXPI_TOGGLE:
		xptoggle_bp_proc(p, pi, evt);
		break;
	default:
		break;
	}

	/* set timestamp and call application-defined procedure */
	bcopy((char *) &(evt->time), (char *) &(pi->xpi_timestamp), sizeof(Time));
	if (pi->xpi_proc != (void (*)()) NULL)
		(*(pi->xpi_proc))(p, pi);

	return;
}

xp_esel *
xpesel_alloc(pi)
/*
   Internal function.
   Allocate a new xp_esel struct.
*/
Panel_item *pi;
{
	xp_esel *e, *f;

	if ((f= (xp_esel *) calloc(1, sizeof(xp_esel))) == (xp_esel *) NULL)
		return((xp_esel *) NULL);

	f->xpesel_str= (char *) NULL;
	f->xpesel_image= (XImage *) NULL;
	f->xpesel_ord= 0;
	f->xpesel_lx= f->xpesel_ly= 0;
	f->xpesel_mx= f->xpesel_my= 0;
	f->xpesel_sel= FALSE;
	f->xpesel_mimage= (XImage *) NULL;
	f->xpesel_nmimage= (XImage *) NULL;
	f->xpesel_next= (xp_esel *) NULL;

	if (pi->xpi_item.xpi_enum.xpenum_list == (xp_esel *) NULL)
		pi->xpi_item.xpi_enum.xpenum_list= f;
	else {
		for (e= pi->xpi_item.xpi_enum.xpenum_list; e->xpesel_next != (xp_esel *) NULL; e= e->xpesel_next);
		e->xpesel_next= f;
		if (e->xpesel_str != (char *) NULL) {
			if (strlen(e->xpesel_str) != 0) {
				if ((f->xpesel_str= calloc((unsigned) (strlen(e->xpesel_str)+1), sizeof(char))) == (char *) NULL) {
					e->xpesel_next= (xp_esel *) NULL;
					cfree((char *) f);
					return((xp_esel *) NULL);
				}
				(void) strcpy(f->xpesel_str, e->xpesel_str);
			}
		}
		f->xpesel_image= e->xpesel_image;
		f->xpesel_ord= e->xpesel_ord+1;
		f->xpesel_lx= e->xpesel_lx;
		f->xpesel_ly= e->xpesel_ly;
		f->xpesel_mx= e->xpesel_mx;
		f->xpesel_my= e->xpesel_my;
		f->xpesel_mimage= e->xpesel_mimage;
		f->xpesel_nmimage= e->xpesel_nmimage;
	}
	return(f);
}

int
xpenum_value(pi)
/*
   Internal function.
   Returns the ordinal value of the first
   selected xp_esel struct of the enum item.
*/
Panel_item *pi;
{
	int i;

	for (i= 0; i < LXPENUM_MAXESELS; i++) {
		if (pi->xpi_item.xpi_enum.xpenum_val & (0x1 << i))
			return(i);
	}
	return(-1);
}

void
xpenum_bld_menu(p, pi)
/*
   Internal function.
   Builds a menu containing a menu item for each xp_esel struct.
*/
Panel *p;
Panel_item *pi;
{
	Menu_item *mi;
	xp_esel *es;
	void xpenum_menu_proc();

	if ((pi->xpi_menu= menu_create(p->xp_name, p->xp_dpy, p->xp_pwin,
				LXM_FONT, p->xp_fontnm,
				LXM_FOREGROUND, pi->xpi_fg,
				LXM_BACKGROUND, pi->xpi_bg,
				LXM_NULL)) == (Menu *) NULL)
		return;

	for (es= pi->xpi_item.xpi_enum.xpenum_list; es != (xp_esel *) NULL; es= es->xpesel_next) {
		if ((mi= menuitem_create(LXMI_STRING, es->xpesel_str,
					LXMI_IMAGE, es->xpesel_image,
					LXMI_PROC, xpenum_menu_proc,
					LXMI_NULL)) == (Menu_item *) NULL) {
			pi->xpi_menu= (Menu *) NULL;
			return;
		}
		(void) menuitem_insert(pi->xpi_menu, mi);
	}
}

void
xpenum_adj_menu(pi)
/*
   Internal function.
   Adjust state of menu items to correspond to the panel item's current value.
*/
Panel_item *pi;
{
	Menu_itemptr *mip;
	int val, i;

	val= xpenum_value(pi);
	for (mip= pi->xpi_menu->xm_items, i= 0; mip != (Menu_itemptr *) NULL; mip= mip->xmip_next, i++) {
		if (val == i)
			mip->xmip_item->xmi_state= LXMI_INACTIVE;
		else
			mip->xmip_item->xmi_state= LXMI_ACTIVE;
	}
}

void
xpenum_menu_proc(m, mi)
Menu *m;
Menu_item *mi;
{
	int ord;
	Menu_itemptr *mip;
	int menuitem_getord();
	void xpenum_setval(), xpenum_changeval();

	ord= menuitem_getord(m, mi);
	switch (xpenum_selpanelitem->xpi_type) {
	case LXPI_CHOICE:
	case LXPI_CYCLE:
		xpenum_setval(xpenum_selpanelitem, ord);
		for (mip= m->xm_items; mip != (Menu_itemptr *) NULL; mip= mip->xmip_next) {
			if (mip->xmip_item == mi)
				mip->xmip_item->xmi_state= LXMI_INACTIVE;
			else
				mip->xmip_item->xmi_state= LXMI_ACTIVE;
		}
		break;
	case LXPI_TOGGLE:
		xpenum_changeval(xpenum_selpanelitem, ord);
		break;
	default:
		break;
	}
}

void
xpenum_setval(pi, val)
/*
   Internal routine.
   Change the enum value of pi to val.
*/
Panel_item *pi;
int val;
{
	int i;
	xp_enum *xpe;
	xp_esel *es;

	xpe= (xp_enum *) &(pi->xpi_item.xpi_enum);
	for (es= xpe->xpenum_list, i= 0; i <= val; es= es->xpesel_next, i++) {
		if (es == (xp_esel *) NULL)
			break;
		else if (i == val)
			break;
	}
	if (es == (xp_esel *) NULL) {
		if (xpe->xpenum_list == (xp_esel *) NULL) {
			xpe->xpenum_val= 0;
			xpe->xpenum_sel= (xp_esel *) NULL;
		}
		else {
			xpe->xpenum_val= 0x1;
			xpe->xpenum_sel= xpe->xpenum_list;
		}
	}
	else {
		xpe->xpenum_val= (0x1 << val);
		xpe->xpenum_sel= es;
	}
}

void
xpenum_changeval(pi, val)
/*
   Internal routine.
   Invert the enum value of a particular xp_esel in pi.
*/
Panel_item *pi;
int val;
{
	int i;
	xp_enum *xpe;
	xp_esel *es;

	xpe= (xp_enum *) &(pi->xpi_item.xpi_enum);
	for (es= xpe->xpenum_list, i= 0; i <= val; es= es->xpesel_next, i++) {
		if (es == (xp_esel *) NULL)
			break;
		else if (i == val)
			break;
	}
	if (es != (xp_esel *) NULL) {
		if (xpe->xpenum_val & (0x1 << val))
			xpe->xpenum_val&= ~(0x1 << val);
		else
			xpe->xpenum_val|= (0x1 << val);
	}
}

boolean
xpenum_ordsel(pi, ord)
/*
   Internal routine.
   Returns TRUE if ord is among
   the selected xp_esel structs of pi.
*/
Panel_item *pi;
int ord;
{
	if (pi->xpi_item.xpi_enum.xpenum_val & (0x1 << ord))
		return(TRUE);
	else
		return(FALSE);
}

xp_esel *
xpenum_findesel(pi, x, y)
/*
   Internal routine.
   Returns the xp_esel (if any) at the specified location.
*/
Panel_item *pi;
int x, y;
{
	xp_esel *es;

	for (es= pi->xpi_item.xpi_enum.xpenum_list; es != (xp_esel *) NULL; es= es->xpesel_next) {
		if ((x >= es->xpesel_x) && (x <= es->xpesel_x+es->xpesel_w) &&
		    (y >= es->xpesel_y) && (y <= es->xpesel_y+es->xpesel_h))
			return(es);
	}
	return((xp_esel *) NULL);
}

void
xpenum_elocinit(pi)
/*
   Internal function.
   Initialize the location and size of all
   xp_esel structs to a default horizontal layout.
*/
Panel_item *pi;
{
	int x, font_ht, w, h, maxh, cw;
	xp_esel *es;

	pi->xpi_item.xpi_enum.xpenum_lx= 0;
	pi->xpi_w= pi->xpi_h= 0;
	font_ht= pi->xpi_font->max_bounds.ascent+pi->xpi_font->max_bounds.descent;
	cw= XTextWidth(pi->xpi_font, "X", strlen("x"));
	if (pi->xpi_image != (XImage *) NULL) {
		x= pi->xpi_w= pi->xpi_image->width+(2*cw);
		maxh= pi->xpi_h= pi->xpi_image->height;
	}
	else if (pi->xpi_str != (char *) NULL) {
		x= pi->xpi_w= XTextWidth(pi->xpi_font, pi->xpi_str, strlen(pi->xpi_str))+(2*cw);
		maxh= pi->xpi_h= font_ht+2;
	}
	else {
		x= pi->xpi_w= 0;
		maxh= pi->xpi_h= 0;
	}

	/* set x locations of all strings and images */
	for (es= pi->xpi_item.xpi_enum.xpenum_list; es != (xp_esel *) NULL; es= es->xpesel_next) {
		es->xpesel_x= x;
		w= h= 0;
		if (!(pi->xpi_item.xpi_enum.xpenum_flags & LXPENUM_INVERTLABEL)) {
			es->xpesel_mx= x;
			if (es->xpesel_mimage != (XImage *) NULL) {
				w= es->xpesel_mimage->width+cw;
				h= es->xpesel_mimage->height;
			}
			if (es->xpesel_nmimage != (XImage *) NULL) {
				if (w < es->xpesel_nmimage->width+cw)
					w= es->xpesel_nmimage->width+cw;
				if (h < es->xpesel_nmimage->height)
					h= es->xpesel_nmimage->height;
			}
		}
		x+= w;
		es->xpesel_lx= x;
		if (es->xpesel_image != (XImage *) NULL) {
			w+= es->xpesel_image->width+cw;
			x+= es->xpesel_image->width+cw;
			if (h < es->xpesel_image->height)
				h= es->xpesel_image->height;
		}
		else if (es->xpesel_str != (char *) NULL) {
			w+= XTextWidth(pi->xpi_font, es->xpesel_str, strlen(es->xpesel_str))+cw;
			x+= XTextWidth(pi->xpi_font, es->xpesel_str, strlen(es->xpesel_str))+cw;
			if (h < font_ht+2)
				h= font_ht+2;
		}
		es->xpesel_w= w;
		if (maxh < h)
			maxh= h;
		pi->xpi_w= es->xpesel_x+es->xpesel_w;
	}
	pi->xpi_h= maxh;

	/* set y locations of all strings and images */
	if (pi->xpi_image != (XImage *) NULL)
		pi->xpi_item.xpi_enum.xpenum_ly= (maxh/2)-(pi->xpi_image->height/2);
	else if (pi->xpi_str != (char *) NULL)
		pi->xpi_item.xpi_enum.xpenum_ly= (maxh/2)-((font_ht+2)/2);

	for (es= pi->xpi_item.xpi_enum.xpenum_list; es != (xp_esel *) NULL; es= es->xpesel_next) {
		es->xpesel_h= maxh;
		es->xpesel_y= 0;
		h= 0;
		if (!(pi->xpi_item.xpi_enum.xpenum_flags & LXPENUM_INVERTLABEL)) {
			if (es->xpesel_mimage != (XImage *) NULL)
				h= es->xpesel_mimage->height;
			if (es->xpesel_nmimage != (XImage *) NULL)
				if (h < es->xpesel_nmimage->height)
					h= es->xpesel_nmimage->height;
			es->xpesel_my= (maxh/2)-(h/2);
		}
		if (es->xpesel_image != (XImage *) NULL)
			es->xpesel_ly= (maxh/2)-(es->xpesel_image->height/2);
		else if (es->xpesel_str != (char *) NULL)
			es->xpesel_ly= (maxh/2)-((font_ht+2)/2);
	}

	return;
}

void
xpenum_eszinit(pi)
/*
   Internal function.
   Initialize the size of all xp_esel structs.
*/
Panel_item *pi;
{
	int maxx, maxy, font_ht, w;
	xp_esel *es;

	font_ht= pi->xpi_font->max_bounds.ascent+pi->xpi_font->max_bounds.descent;

	for (es= pi->xpi_item.xpi_enum.xpenum_list; es != (xp_esel *) NULL; es= es->xpesel_next) {
		if (es->xpesel_lx < es->xpesel_mx)
			es->xpesel_x= es->xpesel_lx;
		else
			es->xpesel_x= es->xpesel_mx;
		if (es->xpesel_ly < es->xpesel_my)
			es->xpesel_y= es->xpesel_ly;
		else
			es->xpesel_y= es->xpesel_my;
		maxx= es->xpesel_x;
		maxy= es->xpesel_y;
		if (!(pi->xpi_item.xpi_enum.xpenum_flags & LXPENUM_INVERTLABEL)) {
			if (es->xpesel_mimage != (XImage *) NULL) {
				if (maxx < es->xpesel_x+(es->xpesel_mx-es->xpesel_x)+es->xpesel_mimage->width)
					maxx= es->xpesel_x+(es->xpesel_mx-es->xpesel_x)+es->xpesel_mimage->width;
				if (maxy < es->xpesel_y+(es->xpesel_my-es->xpesel_y)+es->xpesel_mimage->height)
					maxy= es->xpesel_y+(es->xpesel_my-es->xpesel_y)+es->xpesel_mimage->height;
			}
			if (es->xpesel_nmimage != (XImage *) NULL) {
				if (maxx < es->xpesel_x+(es->xpesel_mx-es->xpesel_x)+es->xpesel_nmimage->width)
					maxx= es->xpesel_x+(es->xpesel_mx-es->xpesel_x)+es->xpesel_nmimage->width;
				if (maxy < es->xpesel_y+(es->xpesel_my-es->xpesel_y)+es->xpesel_nmimage->height)
					maxy= es->xpesel_y+(es->xpesel_my-es->xpesel_y)+es->xpesel_nmimage->height;
			}
		}
		if (es->xpesel_image != (XImage *) NULL) {
			if (maxx < es->xpesel_x+(es->xpesel_lx-es->xpesel_x)+es->xpesel_image->width)
				maxx= es->xpesel_x+(es->xpesel_lx-es->xpesel_x)+es->xpesel_image->width;
			if (maxy < es->xpesel_y+(es->xpesel_ly-es->xpesel_y)+es->xpesel_image->height)
				maxy= es->xpesel_y+(es->xpesel_ly-es->xpesel_y)+es->xpesel_image->height;
		}
		else if (es->xpesel_str != (char *) NULL) {
			w= XTextWidth(pi->xpi_font, es->xpesel_str, strlen(es->xpesel_str));
			if (maxx < es->xpesel_x+(es->xpesel_lx-es->xpesel_x)+w)
				maxx= es->xpesel_x+(es->xpesel_lx-es->xpesel_x)+w;
			if (maxy < es->xpesel_y+(es->xpesel_ly-es->xpesel_y)+font_ht+2)
				maxy= es->xpesel_y+(es->xpesel_ly-es->xpesel_y)+font_ht+2;
		}
		es->xpesel_w= maxx-es->xpesel_x;
		es->xpesel_h= maxy-es->xpesel_y;
	}
}
