#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "lxt.h"

extern boolean xp_fullredraw;

int
xpslider_idef_proc(p, pi)
/*
   Internal function.
   Initialize defaults for a slider item.
*/
Panel *p;
Panel_item *pi;
{
	pi->xpi_item.xpi_slider.xpslider_minval= LXPDEF_SLIDERMINVAL;
	pi->xpi_item.xpi_slider.xpslider_maxval= LXPDEF_SLIDERMAXVAL;
	pi->xpi_item.xpi_slider.xpslider_val= LXPDEF_SLIDERVAL;
	pi->xpi_item.xpi_slider.xpslider_barh= LXPDEF_SLIDERBARHEIGHT;
	pi->xpi_item.xpi_slider.xpslider_barl= LXPDEF_SLIDERBARLENGTH;
	return(LX_SUCCESS);
}

int
xpslider_dst_proc(pi)
/*
   Internal function.
   Destroys a slider item.
*/
Panel_item *pi;
{
	if (pi->xpi_item.xpi_slider.xpslider_bpm != None)
		XFreePixmap(pi->xpi_dpy, pi->xpi_item.xpi_slider.xpslider_bpm);
	if (pi->xpi_item.xpi_slider.xpslider_bgc != None)
		XFreeGC(pi->xpi_dpy, pi->xpi_item.xpi_slider.xpslider_bgc);
	return(LX_SUCCESS);
}

int
xpslider_sz_proc(p, pi)
/*
   Internal function.
   Sizes a slider item.
*/
Panel *p;
Panel_item *pi;
{
	xp_slider *xps;
	char buf[20];

	if (p == (Panel *) NULL) {
		(void) fprintf(stderr, "xpslider_sz_proc: null panel\n");
		return(LX_ERROR);
	}
	if (pi == (Panel_item *) NULL) {
		(void) fprintf(stderr, "xpslider_sz_proc: null item\n");
		return(LX_ERROR);
	}

	pi->xpi_w= pi->xpi_h= 0;
	xps= (xp_slider *) &(pi->xpi_item.xpi_slider);

	(void) sprintf(buf, " %1d", xps->xpslider_maxval);
	pi->xpi_w= xps->xpslider_barx+xps->xpslider_barl+LXPDEF_SLIDERCAPWIDTH+1+XTextWidth(pi->xpi_font, buf, strlen(buf));
	pi->xpi_h= xps->xpslider_valy+pi->xpi_font->max_bounds.descent;
	if (pi->xpi_image != (XImage *) NULL) {
		if (pi->xpi_w < pi->xpi_image->width)
			pi->xpi_w= pi->xpi_image->width;
		if (pi->xpi_h < pi->xpi_image->height)
			pi->xpi_h= pi->xpi_image->height;
	}
	if (pi->xpi_h < xps->xpslider_bary+xps->xpslider_barh)
		pi->xpi_h= xps->xpslider_bary+xps->xpslider_barh;
	return(LX_SUCCESS);
}

void
xpslider_drw_proc(p, pi)
/*
   Internal function.
   Plots a slider item onto the backing store.
*/
Panel *p;
Panel_item *pi;
{
	xp_slider *xps;
	int x, y, i, bubblelen;
	float vdiff, vmaxdiff;
	char buf[20];

	if (!xp_fullredraw)
		XFillRectangle(p->xp_dpy, p->xp_ppm, pi->xpi_cgc, pi->xpi_x, pi->xpi_y, pi->xpi_w, pi->xpi_h);
	if (pi->xpi_state == LXPI_INACTIVE)
		return;

	xps= (xp_slider *) &(pi->xpi_item.xpi_slider);

	/* attempt to draw xpi_image */
	if (pi->xpi_image != (XImage *) NULL)
		XPutImage(p->xp_dpy, p->xp_ppm, pi->xpi_gc, pi->xpi_image, 0, 0, pi->xpi_x, pi->xpi_y, pi->xpi_image->width, pi->xpi_image->height);


	/* draw slider label if no image present */
	else if (pi->xpi_str != (char *) NULL) {
		if (strlen(pi->xpi_str) != 0)
			y= pi->xpi_y+xps->xpslider_valy;
			XDrawString(p->xp_dpy, p->xp_ppm, pi->xpi_gc, pi->xpi_x, y, pi->xpi_str, strlen(pi->xpi_str));
	}

	/* draw value string */
	x= pi->xpi_x+xps->xpslider_valx;
	y= pi->xpi_y+xps->xpslider_valy;
	(void) sprintf(buf, "[%1d]", xps->xpslider_val);
	XDrawString(p->xp_dpy, p->xp_ppm, pi->xpi_gc, x, y, buf, strlen(buf));

	/* draw minimum value */
	(void) sprintf(buf, "%1d ", xps->xpslider_minval);
	x= pi->xpi_x+xps->xpslider_barx-XTextWidth(pi->xpi_font, buf, strlen(buf));
	XDrawString(p->xp_dpy, p->xp_ppm, pi->xpi_gc, x, y, buf, strlen(buf));

	/* draw bar */
	x= pi->xpi_x+xps->xpslider_barx;
	y= pi->xpi_y+xps->xpslider_bary;
	XDrawLine(p->xp_dpy, p->xp_ppm, pi->xpi_gc, x, y, x+xps->xpslider_barl+LXPDEF_SLIDERCAPWIDTH+1, y);
	XDrawLine(p->xp_dpy, p->xp_ppm, pi->xpi_gc, x+xps->xpslider_barl+LXPDEF_SLIDERCAPWIDTH+1, y, x+xps->xpslider_barl+LXPDEF_SLIDERCAPWIDTH+1, y+xps->xpslider_barh);
	XDrawLine(p->xp_dpy, p->xp_ppm, pi->xpi_gc, x, y+xps->xpslider_barh, x+xps->xpslider_barl+LXPDEF_SLIDERCAPWIDTH+1, y+xps->xpslider_barh);
	XDrawLine(p->xp_dpy, p->xp_ppm, pi->xpi_gc, x, y, x, y+xps->xpslider_barh);

	/* draw bubble and bubble cap */
	vdiff= (float) (xps->xpslider_val-xps->xpslider_minval);
	vmaxdiff= (float) (xps->xpslider_maxval-xps->xpslider_minval);
	if (vmaxdiff == 0.)
		bubblelen= xps->xpslider_barl;
	else
		bubblelen= (int) ((float) ((vdiff/vmaxdiff)*((float) xps->xpslider_barl)));
	x= pi->xpi_x+xps->xpslider_barx+1;
	y= pi->xpi_y+xps->xpslider_bary+1;
	XFillRectangle(p->xp_dpy, p->xp_ppm, xps->xpslider_bgc, x, y, bubblelen, xps->xpslider_barh-1);
	x= pi->xpi_x+xps->xpslider_barx+1+bubblelen;
	y= pi->xpi_y+xps->xpslider_bary;
	for (i= 0; i < LXPDEF_SLIDERCAPWIDTH; i++)
		XDrawLine(p->xp_dpy, p->xp_ppm, pi->xpi_gc, x+i, y, x+i, y+xps->xpslider_barh);

	/* draw maximum value */
	(void) sprintf(buf, " %1d", xps->xpslider_maxval);
	x= pi->xpi_x+xps->xpslider_barx+xps->xpslider_barl+LXPDEF_SLIDERCAPWIDTH+1;
	y= pi->xpi_y+xps->xpslider_valy;
	XDrawString(p->xp_dpy, p->xp_ppm, pi->xpi_gc, x, y, buf, strlen(buf));
	return;
}

void
xpslider_bp_proc(p, pi, evt)
/*
   Internal function.
   Process button press on slider item.
*/
Panel *p;
Panel_item *pi;
XButtonPressedEvent *evt;
{
	int prev;
	void xpslider_setval();
	void xpslider_drw_proc(), xpi_std_dsp_proc();

	p->xp_selitem= pi;
	p->xp_flags|= LXP_SELACTIVE;
	prev= p->xp_selitem->xpi_item.xpi_slider.xpslider_val;
	xpslider_setval(p, pi, evt->x, evt->y);
	if (prev != p->xp_selitem->xpi_item.xpi_slider.xpslider_val) {
		xpslider_drw_proc(p, pi);
		xpi_std_dsp_proc(p, pi);
	}
	return;
}

void
xpslider_br_proc(p, pi, evt)
/*
   Internal function.
   Process button release while a slider item is selected.
*/
Panel *p;
Panel_item *pi;
XButtonReleasedEvent *evt;
{
	/* set timestamp and call application-defined procedure */
	bcopy((char *) &(evt->time), (char *) &(p->xp_selitem->xpi_timestamp), sizeof(Time));
	if (p->xp_selitem->xpi_proc != (void (*)()) NULL)
		(*(p->xp_selitem->xpi_proc))(p, p->xp_selitem);

	xpslider_drw_proc(p, p->xp_selitem);
	xpi_std_dsp_proc(p, p->xp_selitem);
	p->xp_selitem= (Panel_item *) NULL;
	p->xp_flags&= ~LXP_SELACTIVE;
	return;
}

void
xpslider_pm_proc(p, pi, evt)
/*
   Internal function.
   Process pointer motion while a slider item is selected.
*/
Panel *p;
Panel_item *pi;
XPointerMovedEvent *evt;
{
	int prev;

	if (pi == p->xp_selitem) {
		prev= p->xp_selitem->xpi_item.xpi_slider.xpslider_val;
		xpslider_setval(p, pi, evt->x, evt->y);
		if (prev != p->xp_selitem->xpi_item.xpi_slider.xpslider_val) {
			xpslider_drw_proc(p, pi);
			xpi_std_dsp_proc(p, pi);
		}
	}
	return;
}

void
xpslider_setval(p, pi, x, y)
Panel *p;
Panel_item *pi;
int x, y;
{
	xp_slider *xps;
	int bx, by, n;
	float vmaxdiff, factor;

	xps= (xp_slider *) &(pi->xpi_item.xpi_slider);
	bx= pi->xpi_x+xps->xpslider_barx;
	by= pi->xpi_y+xps->xpslider_bary;
	if ((x+p->xp_vx < bx) || (x+p->xp_vx > bx+xps->xpslider_barl+LXPDEF_SLIDERCAPWIDTH+1) ||
	    (y+p->xp_vy < by) || (y+p->xp_vy > by+xps->xpslider_barh))
		return;
	vmaxdiff= (float) (xps->xpslider_maxval-xps->xpslider_minval);
	factor= ((float) x+p->xp_vx-bx)/((float) xps->xpslider_barl);
	n= (int) (vmaxdiff*factor);
	if (vmaxdiff*factor >= ((float) n)+0.5)
		n++;
	xps->xpslider_val= xps->xpslider_minval+n;
	if (xps->xpslider_val > xps->xpslider_maxval)
		xps->xpslider_val= xps->xpslider_maxval;
}
