#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <ctype.h>
#include <varargs.h>
#include <math.h>

#include "lxt.h"

extern Textsw *xt_textsws;
extern char *xvt_pastebuf;
extern int xvt_pastebufsz;

extern Void *lxt_selsrc;

int 
textsw_set(va_alist)
/*
   User-callable.
   Changes an attribute of a previously created textsw.
*/
va_dcl
{
	va_list varg_ptr;
	Textsw *t, *current;
	int i, j, k, attr, nargs, length;
	int line_number, real_chars;
	int old_top_line, old_left_pix;
	int lines_scrolled, columns_scrolled;
	int map[512], new_length, loop_start;
	char a, c, *s;
	char *expanded_string, *temp_str;
	unsigned long plane_mask;
	boolean found, readfile, grabsel;
	boolean visible, redisplay, reconfig;
	XFontStruct *test_font;
	void lxt_clearsel();
	void textsw_draw(), textsw_display();
	void textsw_drawscrolls();
	void textsw_unmapsubwins();
	void textsw_grabsel();

	redisplay= readfile= reconfig= grabsel= FALSE;

	va_start(varg_ptr);
	for (nargs= 0; ; nargs ++) {

		if (nargs == 0) {
			t= va_arg(varg_ptr, Textsw *);
			if (t == (Textsw *) NULL) {
				(void) fprintf(stderr, "textsw_set: null text window\n");
				return(LX_ERROR);
			}
			if (t->xt_magic != LX_TEXTSW) {
				(void) fprintf(stderr, "textsw_set: object is not a textsw\n");
				return(LX_ERROR);
			}
			found= FALSE;	
			current= xt_textsws;
			while (current != (Textsw *) NULL) {
				if (current == t) {
					found= TRUE;
					break;
				}
				current= current->xt_next;
			}
			if (!found) {
				(void) fprintf(stderr, "textsw_set: no such text window\n");
				return(LX_ERROR);
			}
			if (t->xt_flags & LXT_FRAMEMAPPED)
				visible= TRUE;
			else
				visible= FALSE;
		}

		/* get attribute */
		else {
			int n;

			attr= va_arg(varg_ptr, int);
			if (attr == LXT_NULL)
				break;

			switch (attr) {
		
			case LXT_INPUTFILE:
				s= va_arg(varg_ptr, char *);
				if (s == (char *) NULL)
					break;
				(void) strncpy(t->xt_rdfilenm, s, LXT_MAXFILENM);
				readfile= TRUE;
				if (visible)
					redisplay= TRUE;
				break;
		
			case LXT_OUTPUTFILE:
				s= va_arg(varg_ptr, char *);
				(void) strncpy(t->xt_wrfilenm, s, LXT_MAXFILENM);
				if (t->xt_wrfilenm[0] == '\0')
					(void) menuitem_set(t->xt_smenuitem, LXMI_STRING, "Untitled", LXMI_NULL);
				else 
					(void) menuitem_set(t->xt_smenuitem, LXMI_STRING, t->xt_wrfilenm,
							 LXMI_STATE, LXMI_ACTIVE,
							 LXMI_NULL);
				break;

			case LXT_FOREGROUND:
				t->xt_fg= va_arg(varg_ptr, unsigned long);
				XSetForeground(t->xt_dpy, t->xt_gc, t->xt_fg);
				XSetForeground(t->xt_dpy, t->xt_igc, t->xt_fg);
				XSetBackground(t->xt_dpy, t->xt_cgc, t->xt_fg);
				XSetForeground(t->xt_dpy, t->xt_sgc, t->xt_fg);
				XSetForeground(t->xt_dpy, t->xt_xgc, t->xt_fg);
				plane_mask= t->xt_fg ^ t->xt_bg;
				XSetPlaneMask(t->xt_dpy, t->xt_igc, plane_mask);
				if (visible)
					redisplay= TRUE;
				break;

			case LXT_BACKGROUND:
				t->xt_bg= va_arg(varg_ptr, unsigned long);
				XSetBackground(t->xt_dpy, t->xt_gc, t->xt_bg);
				XSetBackground(t->xt_dpy, t->xt_igc, t->xt_bg);
				XSetForeground(t->xt_dpy, t->xt_cgc, t->xt_bg);
				XSetBackground(t->xt_dpy, t->xt_sgc, t->xt_bg);
				XSetBackground(t->xt_dpy, t->xt_xgc, t->xt_bg);
				plane_mask= t->xt_fg ^ t->xt_bg;
				XSetPlaneMask(t->xt_dpy, t->xt_igc, plane_mask);
				if (visible)
					redisplay= TRUE;
				break;

			case LXT_FONT:
				s= va_arg(varg_ptr, char *);
				if (s == (char *) NULL)	
					(void) fprintf(stderr, "textsw_set: null fontname\n");
				else if ((test_font= XLoadQueryFont(t->xt_dpy, s)) == NULL)
					(void) fprintf(stderr, "textsw_set: cannot load font %s\n", s);
				else {
					t->xt_font= test_font;
					XSetFont(t->xt_dpy, t->xt_gc, t->xt_font->fid);
					XSetFont(t->xt_dpy, t->xt_cgc, t->xt_font->fid);
					XSetFont(t->xt_dpy, t->xt_sgc, t->xt_font->fid);
					XSetFont(t->xt_dpy, t->xt_igc, t->xt_font->fid);
					XSetFont(t->xt_dpy, t->xt_xgc, t->xt_font->fid);

					t->xt_cheight= (int) (t->xt_font->max_bounds.ascent + t->xt_font->max_bounds.descent) + 2;

					t->xt_cdescent= (int) t->xt_font->max_bounds.descent;

					t->xt_cwidth=  (int) (t->xt_font->max_bounds.rbearing - t->xt_font->min_bounds.lbearing);

					t->xt_clbearing= (int) t->xt_font->min_bounds.lbearing;

					t->xt_drawhlt= FALSE;
					if (t == (Textsw *) lxt_selsrc)
						lxt_clearsel(FALSE);
					t->xt_drawcursor= FALSE;
					if (visible) {
						t->xt_wcw=  (int) t->xt_w/t->xt_cwidth;
						t->xt_wch= (int) t->xt_h/t->xt_cheight;
						redisplay= TRUE;
					}
				}
				break;

			case LXT_ALLOWINPUT:
				n= va_arg(varg_ptr, int);
				if ((n != TRUE) && (n != FALSE)) {
					(void) fprintf(stderr, "textsw_set: ignoring bad allow input state\n");
					break;
				}
				else
					t->xt_allowinput= n;

				break;

			case LXT_PASTEBUFFER:
				s= va_arg(varg_ptr, char *);
				if (xvt_pastebuf != NULL)
					free(xvt_pastebuf);
				length= strlen(s);
				xvt_pastebuf= calloc((unsigned) (length+1), sizeof(char));
				(void) strcpy(xvt_pastebuf, s);
				xvt_pastebufsz= length;
				break;

			case LXT_CHARPROC:
				t->xt_charproc= (int (*)()) va_arg(varg_ptr, int);
				break;

			case LXT_EXITPROC:
				t->xt_exitproc= (int (*)()) va_arg(varg_ptr, int);
				break;

			case LXT_TCURSOR:
				t->xt_tcursor= va_arg(varg_ptr, Cursor);
				XDefineCursor(t->xt_dpy, t->xt_twin, t->xt_tcursor);
				break;

			case LXT_VSCURSOR:
				t->xt_vscursor= va_arg(varg_ptr, Cursor);
				XDefineCursor(t->xt_dpy, t->xt_vswin, t->xt_vscursor);
				break;

			case LXT_HSCURSOR:
				t->xt_hscursor= va_arg(varg_ptr, Cursor);
				XDefineCursor(t->xt_dpy, t->xt_hswin, t->xt_hscursor);
				break;

			case LXT_BARWIDTH:
				t->xt_vscroll->xs_barwidth= t->xt_hscroll->xs_barwidth= va_arg(varg_ptr, int);
				if (visible) {
					reconfig= TRUE;
					redisplay= TRUE;
				}
				break;

			case LXT_BUBBLEMARGIN:
				t->xt_vscroll->xs_bubblemargin= t->xt_hscroll->xs_bubblemargin= va_arg(varg_ptr, int);
				if (visible) {
					reconfig= TRUE;
					redisplay= TRUE;
				}
				break;

			case LXT_BUTTONLEN:
				t->xt_vscroll->xs_buttonlen= t->xt_hscroll->xs_buttonlen= va_arg(varg_ptr, int);
				if (visible) {
					reconfig= TRUE;
					redisplay= TRUE;
				}
				break;

			case LXT_DRAWCURSOR:
				n= va_arg(varg_ptr, int);
				if ((n != TRUE) && (n != FALSE)) {
					(void) fprintf(stderr, "textsw_set: ignoring bad cursor state\n");
					break;
				}
				if (n != t->xt_drawcursor) {	
					textsw_drawcaret(t);
					if (t->xt_drawcursor)
						t->xt_drawcursor= FALSE;
					else
						t->xt_drawcursor= TRUE;
				}
				break;

			case LXT_DRAWHIGHLIGHT:
				n= va_arg(varg_ptr, int);
				if ((n != TRUE) && (n != FALSE)) {
					(void) fprintf(stderr, "textsw_set: ignoring bad highlight state\n");
					break;
				}
				if (n != t->xt_drawhlt) {	
					textsw_drawhlt(t, TRUE, (boolean *) NULL);
					if (t->xt_drawhlt) {
						t->xt_drawhlt= FALSE;
						grabsel= FALSE;
						if (t == (Textsw *) lxt_selsrc)
							lxt_clearsel(FALSE);
					}
					else {
						t->xt_drawhlt= TRUE;
						grabsel= TRUE;
					}
				}
				break;

			case LXT_CURSORLINE:
				n= va_arg(varg_ptr, int);
				if ((n == 0) && (t->xt_nbuflines == 0))
					;
				else if ((n < 0) || (n > t->xt_nbuflines-1)) {
					(void) fprintf(stderr, "textsw_set: bad cursor line number %d\n", n);
					break;
				}
				if (t->xt_drawcursor) {
					textsw_drawcaret(t);
					t->xt_drawcursor= FALSE;
				}

				t->xt_cursorpy= n * t->xt_cheight;
				t->xt_cursorpx= -t->xt_leftpix;
				t->xt_irow= n;
				t->xt_icol= 0;
				t->xt_ichar= t->xt_linestarts[t->xt_irow] + t->xt_icol;

				textsw_drawcaret(t);
				t->xt_drawcursor= TRUE;

				break;

			case LXT_CURSORCOLUMN:
				n= va_arg(varg_ptr, int);
				if (n < 0 ) {
					(void) fprintf(stderr, "textsw_set: ignoring bad cursor column\n");
					break;
				}

				if (n == 0) {
					/* undraw old caret */
					textsw_drawcaret(t);
					t->xt_drawcursor= FALSE;

					t->xt_cursorpx= -t->xt_leftpix;
					t->xt_icol= 0;
					t->xt_ichar= t->xt_linestarts[t->xt_irow] + t->xt_icol;

					/* draw new caret */
					textsw_drawcaret(t);
					t->xt_drawcursor= TRUE;

					break;
				}

				/* count non space holding characters */
				length= t->xt_linestarts[t->xt_irow + 1] - t->xt_linestarts[t->xt_irow];
				loop_start= t->xt_linestarts[t->xt_irow];

				real_chars= 0;
				j= 0;
				for (i= loop_start; (i < loop_start+length) && (j != n); i++) {
					if (t->xt_text[i] != LXT_SPHOLDER)
						++j;
					++real_chars;
				}

				temp_str= calloc((unsigned) (real_chars+10), sizeof(char));
				expanded_string= calloc((unsigned) 512, sizeof(char));

				(void) strncpy(temp_str, &(t->xt_text[t->xt_linestarts[t->xt_irow]]), real_chars);
				temp_str[real_chars]= '\0';
				textsw_expand_string(temp_str, expanded_string, map, strlen(temp_str), &new_length);

				/* undraw old caret */
				textsw_drawcaret(t);
				t->xt_drawcursor= FALSE;

				t->xt_cursorpx= XTextWidth(t->xt_font, expanded_string, new_length)-t->xt_leftpix;
				t->xt_icol= real_chars;
				t->xt_ichar= t->xt_linestarts[t->xt_irow] + t->xt_icol;

				/* draw new caret */
				textsw_drawcaret(t);
				t->xt_drawcursor= TRUE;

				cfree(temp_str);
				cfree(expanded_string);
				temp_str= (char *) NULL;
				expanded_string= (char *) NULL;
				
				break;
				
			case LXT_INSERTTEXT:
				s= va_arg(varg_ptr, char *);
				length= strlen(s);

				for (i= 0; i < length; i++) {
					c= s[i];

					/* check that user wants to
					   process this character */
					if (t->xt_charproc != NULL)
						if (!(t->xt_charproc)(t, c))
							continue;

					if (c >= ' ' && c <= '~')
						a= 'a';
					else if (c == '\t')
						a= 'a';
					else if (c == '\r') {
						a= '\n';
						c= '\n';
					}
					else
						a= c;

	 				switch (a) {
					case 'a':
						if (t->xt_drawhlt) {
							textsw_drawhlt(t, TRUE, (boolean *) NULL);
							t->xt_drawhlt= FALSE;
						}
						if (t == (Textsw *) lxt_selsrc)
							lxt_clearsel(FALSE);
						textsw_insprint(t, c);
						t->xt_textedited= TRUE;
						break;

					case '\b':
					case 0177:
						if (t->xt_drawhlt) {
							textsw_drawhlt(t, TRUE, (boolean *) NULL);
							t->xt_drawhlt= FALSE;
						}
						if (t == (Textsw *) lxt_selsrc)
							lxt_clearsel(FALSE);
						textsw_delchar(t);
						t->xt_textedited= TRUE;
						break;

					case '\n':
						if (t->xt_drawhlt) {
							textsw_drawhlt(t, TRUE, (boolean *) NULL);
							t->xt_drawhlt= FALSE;
						}
						if (t == (Textsw *) lxt_selsrc)
							lxt_clearsel(FALSE);
						textsw_insnewline(t);
						t->xt_textedited= TRUE;
						break;
					default:
						break;
					}
				}
				break;
			case LXT_HIGHLIGHTENDLINE:
				n= va_arg(varg_ptr, int);
				if (t->xt_drawhlt)
					break;

				if (n < 0 )
					n= 0;
				if (n > t->xt_nbuflines - 1)
					n= t->xt_nbuflines - 1;

				t->xt_hltcursorx= t->xt_cursorpx;
				t->xt_hltcursory= t->xt_cursorpy;

				t->xt_hltorigin.x= t->xt_leftpix;
				t->xt_hltorigin.y= t->xt_topline*t->xt_cheight;

				t->xt_hltstarty= (n-t->xt_topline)*t->xt_cheight;
				t->xt_hltstartx= -t->xt_leftpix;
				break;
				
			case LXT_HIGHLIGHTENDCOLUMN:
				n= va_arg(varg_ptr, int);
				if (t->xt_drawhlt)
					break;

				k= (t->xt_hltstarty+t->xt_hltorigin.y)/t->xt_cheight;
				loop_start= t->xt_linestarts[k];
				length= t->xt_linestarts[k+1]-t->xt_linestarts[k];

				t->xt_hltcursorx= t->xt_cursorpx;
				t->xt_hltcursory= t->xt_cursorpy;
				t->xt_hltorigin.x= t->xt_leftpix;
				t->xt_hltorigin.y= t->xt_topline*t->xt_cheight;

				if (n == 0) {
					t->xt_hltstartx= -t->xt_leftpix;
					break;
				}

				/* count non-space holding characters	*/
				real_chars= 0;
				j= 0;
				for (i= loop_start; (i < loop_start+length) && (j != n); i++) {
					if(t->xt_text[i] != LXT_SPHOLDER)
						++j;
					++real_chars;
				}
				
				temp_str= calloc((unsigned) (real_chars+10), sizeof(char));
				expanded_string= calloc((unsigned) 512, sizeof(char));

				(void) strncpy(temp_str, &(t->xt_text[t->xt_linestarts[k]]), real_chars);
				temp_str[real_chars]= '\0';

				textsw_expand_string(temp_str, expanded_string, map, strlen(temp_str), &new_length);

				t->xt_hltstartx= XTextWidth(t->xt_font, expanded_string, new_length)
					 - t->xt_leftpix;

				cfree(temp_str);
				cfree(expanded_string);

				break;
		
			case LXT_CURSORVIEWABLE:
				if (!t->xt_drawcursor)
					break;

				if (t->xt_cursorpy < 0 || t->xt_cursorpy > t->xt_ath) {
					line_number= (t->xt_cursorpy / t->xt_cheight) + t->xt_topline;
					if (line_number > t->xt_wch) {
						old_top_line= t->xt_topline;
						t->xt_topline= line_number - t->xt_wch + 1;
						lines_scrolled= t->xt_topline - old_top_line;
						t->xt_cursorpy+= lines_scrolled * t->xt_cheight;
					}
					else {
						old_top_line= t->xt_topline;
						t->xt_topline= 0;
						lines_scrolled= t->xt_topline - old_top_line;
						t->xt_cursorpy+= lines_scrolled * t->xt_cheight;
					}
					if (visible)
						redisplay= TRUE;
				}
	
				if (t->xt_cursorpx < 0 || t->xt_cursorpx > t->xt_atw) {
					old_left_pix= t->xt_leftpix;
					if (t->xt_cursorpx+t->xt_leftpix < t->xt_atw)
						t->xt_leftpix= 0;
					else
						t->xt_leftpix+= t->xt_cursorpx - t->xt_atw/2;
					columns_scrolled= t->xt_leftpix-old_left_pix;
					t->xt_cursorpx+= columns_scrolled;
					if (visible)
						redisplay= TRUE;
				}
				break;

			case LXT_TOPLINE:
				n= va_arg(varg_ptr, int);
				if ((n < 0) || (n > t->xt_nbuflines-1)) {
					(void) fprintf(stderr, "textsw_set: ignoring bad top line request\n");
					break;
				}
				t->xt_topline= n;
				if (visible)
					redisplay= TRUE;
				break;
		
			case LXT_CLIENTDATA:
				t->xt_clientdata= va_arg(varg_ptr, char *);
				break;
		
			case LXT_NUMLINES:
			case LXT_MENU:
				(void) fprintf(stderr, "textsw_set: attribute is query-only\n");
				break;
			default:
				(void) fprintf(stderr, "textsw_set: ignoring unrecognizable attribute\n");
				break;
			}	
		}
	}

	va_end(varg_ptr);

	if (readfile) {
		if (textsw_readfile(t, t->xt_rdfilenm, FALSE) != LX_SUCCESS) {
			(void) fprintf(stderr, "textsw_set: cannot read file '%s'\n", t->xt_rdfilenm);
			return(LX_ERROR);
		}
		t->xt_topline= 0;
		t->xt_leftpix= 0;
		t->xt_nspholders= 0;
		t->xt_drawhlt= FALSE;
		if (t == (Textsw *) lxt_selsrc)
			lxt_clearsel(FALSE);
		t->xt_textedited= FALSE;
		t->xt_drawcursor= FALSE;
		t->xt_updatescroll= FALSE;
		t->xt_allowinput= TRUE;
		(void) strcpy(t->xt_wrfilenm, t->xt_rdfilenm);
		(void) menuitem_set(t->xt_smenuitem, LXMI_STRING, t->xt_wrfilenm, LXMI_STATE, LXMI_ACTIVE, LXMI_NULL);
	}

	if (visible && (t->xt_drawhlt == TRUE) && grabsel)
		textsw_grabsel(t, CurrentTime);

	if (reconfig) {
		if (visible)
#ifdef PRE_R3
			/* this causes a server crash under X.V11R3/SunOS3.4! */
			XUnmapSubwindows(t->xt_dpy, t->xt_win);
#else
			textsw_unmapsubwins(t);
#endif PRE_R3
		(void) textsw_config(t);
	}

	if (redisplay) {
		XMapWindow(t->xt_dpy, t->xt_twin);
		XMapWindow(t->xt_dpy, t->xt_hswin);
		XMapWindow(t->xt_dpy, t->xt_vswin);
		textsw_draw(t);
		textsw_display(t);
		textsw_drawscrolls(t);
	}

	return(LX_SUCCESS);
}
