#!/bin/sh
#  xwd_to_ps.sh from ObjectProDSP 0.2
#  Copyright (C) 1994 1995, Mountain Math Software. All rights reserved.
#  
#  This file is part of ObjectProDSP, a tool for Digital Signal
#  Processing design, development and implementation. It is free
#  software provided you use and distribute it under the terms of
#  version 2 of the GNU General Public License as published
#  by the Free Software Foundation. You may NOT distribute it or
#  works derived from it or code that it generates under ANY
#  OTHER terms.  In particular NONE of the ObjectProDSP system is
#  licensed for use under the GNU General Public LIBRARY License.
#  Mountain Math Software plans to offer a commercial version of
#  ObjectProDSP for a fee. That version will allow redistribution
#  of generated code under standard commercial terms.
#  
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#  GNU General Public License for more details.
#  
#  You should have received a copy of version 2 of the GNU General
#  Public License along with this program. See file COPYING. If not
#  or if you wish information on commercial versions and licensing
#  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
#  USA, or send us e-mail at: support@mtnmath.com.
#  
#  You may also obtain the GNU General Public License by writing the
#  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
#  USA.  However if you received a copy of this program without the
#  file COPYING or without a copyright notice attached to all text
#  files, libraries and executables please inform Mountain Math Software.
#  
#  ObjectProDSP is a trademark of Mountain Math Software.
#  
# Search for `Figure' to find the figures that must be updated manually

OPD_XWD_SOURCE=$OPD_ROOT/doc/xwd/auto
OPD_XWD_SOURCE_HAND=$OPD_ROOT/doc/xwd/hand
OPD_TO_PS="xpr -psfig -portrait -device ps -scale 4 -psfig -gray 4"
OPD_TO_PS3="xpr -psfig -portrait -device ps -scale 3 -psfig -gray 3"
OPD_PSFIG_DEST="$OPD_ROOT/doc/psfig"
OPD_FLT="$OPD_ROOT/bin/remove_orig"
OPD_TST_RUN=$OPD_ROOT/tst/xwd

function xwd_to_ps_hand() {
	echo $1
	$OPD_TO_PS $OPD_XWD_SOURCE_HAND/${1%%#*} | \
		$OPD_FLT > $OPD_PSFIG_DEST/${1##*#}.ps
}

function xwd_to_ps3() {
	echo $1
	$OPD_TO_PS3 $OPD_XWD_SOURCE/${1%%#*} \
		| $OPD_FLT > $OPD_PSFIG_DEST/${1##*#}.ps
}

function xwd_to_ps() {
	echo $1
	$OPD_TO_PS $OPD_XWD_SOURCE/${1%%#*} | $OPD_FLT > \
		$OPD_PSFIG_DEST/${1##*#}.ps
}

function set_env() { # $1 = PS directory, $2 = XWD auto directory
					 # $3 = XWD hand directory 
	OPD_XWD_AUTO=
	OPD_XWD_HAND=
	OPD_PS_AUTO=
	OPD_PS_HAND=

	for i in $OPD_AUTO_PSFIG $OPD_AUTO_PSFIG3 ;do
		OPD_ADD=${i%%#*}
		# eliminate duplicate names
		for j in $OPD_XWD_AUTO ;do 
			if [ "$j" = "$OPD_ADD" ] ;then OPD_ADD= ;fi
		done
		OPD_XWD_AUTO="$OPD_XWD_AUTO $2/$OPD_ADD"
		OPD_PS_AUTO="$OPD_PS_AUTO $1/${i##*#}.ps"
	done

	for i in $OPD_HAND_PSFIG ;do
		OPD_XWD_HAND="$OPD_XWD_HAND $3/${i%%#*}"
		OPD_PS_HAND="$OPD_PS_HAND $1/${i##*#}.ps"
	done
}

# First are the windows generated automatically by `overview_make_fig.rec'

OPD_AUTO_PSFIG="ObjectProDSP_information.xwd#help \
	ObjectProDSP_0.1_for_float_arithmetic.xwd#main \
	FFT_Net.xwd#FFT_Net_no \
	FFT_Plt_plot_of_FFT_FFT.xwd#ex1_fft \
	Power_view_of_FFT_Plt_plot_of_FFT_FFT.xwd#ex1_fft_p \
	Decibel_power_view_of_FFT_Plt_plot_of_FFT_FFT.xwd#ex1_fft_d \
	menu_FFT_Sig.xwd#ex1_menu \
	Fir_resp_net.xwd#Fir_resp_net \
	Fir_resp_fft_plot_plot_of_Fir_resp_fft.xwd#ex2_fft \
	Power_view_of_Fir_resp_fft_plot_plot_of_Fir_resp_fft.xwd#ex2_fft_p \
	Decibel_power_view_of_Fir_resp_fft_plot_plot_of_Fir_resp_fft#ex2_fft_d \
	menu_Fir_resp_cximp.xwd#ex2_menu \
	Fir_net.xwd#Fir_net \
	Decibel_power_view_of_Plot_fft_1024_plot_of_FFT_1024.xwd#ex3_fft_1024_d \
	Decibel_power_view_of_Plot_fft_256_plot_of_FFT_256.xwd#ex3_fft_256_d \
	menu_Fir_net.xwd#ex3_net_menu \
	FFT_Net_edit_1.xwd#edit_net_1 \
	FFT_Net_edit_2.xwd#edit_net_2 \
	FFT_Net_edit_3.xwd#edit_net_3 \
	menu_FFT_Net.xwd#edit_net_menu \
	Plot_11_plot_of_CxFFT_5.xwd#edit_net_plt_1 \
	Decibel_power_view_of_Plot_11_plot_of_CxFFT_5.xwd#edit_net_plt_2" 
	
# figures that must be generated manually
OPD_HAND_PSFIG=

# Figure 5 Expanded spectral plot
OPD_HAND_PSFIG="$OPD_HAND_PSFIG FFT_Plt_plot_of_FFT_FFT_exp.xwd#ex1_fft_exp"

# Figure 8 Program for spectral analysis example
OPD_HAND_PSFIG="$OPD_HAND_PSFIG help_fft.xwd#ex1_desc"

# Figure 10 Description of FFT_Sig object
OPD_HAND_PSFIG="$OPD_HAND_PSFIG \
	ObjectProDSP_information_FFT_sig.xwd#ex1_men_help"

# Figure 16 Description of Fir_resp_cximp object
OPD_HAND_PSFIG="$OPD_HAND_PSFIG ObjectProDSP_information_Fir_resp_cximp.xwd#ex2_men_help"

# Figure 17 Program for FIR filter response
OPD_HAND_PSFIG="$OPD_HAND_PSFIG help_fir_resp.xwd#ex2_desc"

# Figure 22 Target code generation with large buffers
OPD_HAND_PSFIG="$OPD_HAND_PSFIG \
	ObjectProDSP_information_Fir_net_target.xwd#ex3_tar_big"

OPD_AUTO_PSFIG3="FFT_Net.xwd#FFT_Net"

case $1 in
SET_ENV)
	set_env $OPD_PSFIG_DEST
	export OPD_XWD_SOURCE OPD_XWD_SOURCE_HAND OPD_PSFIG_DEST 
	export OPD_XWD_AUTO OPD_XWD_HAND OPD_PS_AUTO OPD_PS_HAND
	;;
SET_ENV_FULL)
	set_env $OPD_PSFIG_DEST $OPD_XWD_SOURCE $OPD_XWD_SOURCE_HAND
	export OPD_XWD_SOURCE OPD_XWD_SOURCE_HAND OPD_PSFIG_DEST 
	export OPD_XWD_AUTO OPD_XWD_HAND OPD_PS_AUTO OPD_PS_HAND
	;;
MAKE_PS)
	for i in $OPD_AUTO_PSFIG3 ;do xwd_to_ps3 $i ;done
	for i in $OPD_AUTO_PSFIG ;do xwd_to_ps $i ;done
	for i in $OPD_HAND_PSFIG ;do xwd_to_ps_hand $i ;done
	;; 
ECHO_PS)
	set_env $OPD_PSFIG_DEST $OPD_XWD_SOURCE $OPD_XWD_SOURCE_HAND
	echo $OPD_PS_AUTO $OPD_PS_HAND
	;;
MAKEFILE)
	XWD_AUTO=
	for i in $OPD_AUTO_PSFIG  ;do
		XWD=$OPD_XWD_SOURCE/${i%%#*}
		OPD_ADD=$XWD
		# eliminate duplicate names
		for j in $XWD_AUTO ;do 
			if [ "$j" = "$OPD_ADD" ] ;then OPD_ADD= ;fi
		done
		XWD_AUTO="$XWD_AUTO $OPD_ADD"
		PS=$OPD_PSFIG_DEST/${i##*#}.ps
		echo "$PS: $XWD"
		echo "	$OPD_TO_PS $< | $OPD_FLT > \$@"
	done
	for i in $OPD_AUTO_PSFIG3  ;do
		XWD=$OPD_XWD_SOURCE/${i%%#*}
		OPD_ADD=$XWD
		# eliminate duplicate names
		for j in $XWD_AUTO ;do 
			if [ "$j" = "$OPD_ADD" ] ;then OPD_ADD= ;fi
		done
		XWD_AUTO="$XWD_AUTO $OPD_ADD"
		PS=$OPD_PSFIG_DEST/${i##*#}.ps
		echo "$PS: $XWD"
		echo "	$OPD_TO_PS3 $< | $OPD_FLT > \$@"
	done
	for i in $OPD_HAND_PSFIG ;do
		XWD=$OPD_XWD_SOURCE_HAND/${i%%#*}
		PS=$OPD_PSFIG_DEST/${i##*#}.ps
		echo "$PS: $XWD"
		echo "	$OPD_TO_PS $< | $OPD_FLT > \$@"
	done
	FIRST="1" ;
	for i in $XWD_AUTO ;do 
		if [ -z "$FIRST" ] ;then echo "\\" ;fi
		FIRST=
		echo -n "$i " 
	done
	echo ":"
	cat $OPD_ROOT/doc/mac/Makefile_xwd
	for i in $XWD_AUTO ;do echo "	mv \${OPD_TST_RUN}/${i##/*/} $i" ;done
;;
*)
	echo "xwd_to_ps bad option \`$1'" >&2
	echo 'Usage: xwd_to_ps ( SET_ENV | MAKE_PS | ECHO_PS )' >&2
	/bin/FORCE_ERROR#####@@@@@@@
esac




