/*  hrdarth.c   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
#include <float.h>
#include "tmpglob.h"
#include "yacintfc.h"
#ifdef INTERACTIVE
#include "dspe_app.h"
#include "cgidbg.h"
#endif
#include "hrdcmp.h"

const char * ArithTypeName = "float" ;
const char * ArithFormat = "%16.9e" ;
const char * ArithBinaryFormat = "0x%08x" ;

const float MachWord::max_positive = FLT_MAX ; ;
const float MachWord::min_negative = -FLT_MAX ;
const int32 MachWord::max_int_positive =  0x7fffffff ;
const int32 MachWord::min_int_negative =  0x80000000 ;
const uint32 MachWord::max_unsigned_int = 0x80000000 ;

const double AccMachWord::max_positive = DBL_MAX ;
const double AccMachWord::min_negative = -DBL_MAX ;



AccMachWord check_overflow_acc(double test_val,int32& number_overflows)
{
	return test_val ;
}

MachWord check_overflow(double test_val,int32& number_overflows)
{
    number_overflows += ArithCheckOverflow(test_val);
	return test_val ;
}


CxAccMachWord::operator complex() const
{
#ifdef __NT_VC__
	complex x ;
	x.x = Real ;
	x.y = Imag ;
	return x ;
#else
	return complex(Real,Imag);
#endif
}

CxMachWord::operator complex() const
{
#ifdef __NT_VC__
	complex x ;
	x.x = rl ;
	x.y = ig ;
	return x ;
#else
	return complex(rl,ig);
#endif
}

CxMachWord::CxMachWord(MachWord r, MachWord i)
{
	rl =r ;
	ig = i;
}

CxMachWord::CxMachWord(MachWord r)
{
	rl = r;
	ig = (float) 0;
}

CxMachWord::CxMachWord(float r,float i)
{
	rl=MachWord(r);
	ig=MachWord(i);
}


CxMachWord::CxMachWord(const CxMachWord& x)
{
	rl = MachReal(x);
	ig = MachImag(x);
}

CxMachWord::CxMachWord(const complex& cx)
{
	rl =real(cx);
	ig =imag(cx);
}

CxAccMachWord::CxAccMachWord(float r,float i)
{
	Real=r;
	Imag=i;
}

CxAccMachWord::CxAccMachWord(const CxMachWord& W)
{
	Real = MachReal(W) ;
	Imag = MachImag(W);
}

CxAccMachWord::CxAccMachWord(const CxAccMachWord& W)
{
	Real = MachReal(W) ;
	Imag = MachImag(W);
}

CxAccMachWord::CxAccMachWord(AccMachWord R, AccMachWord I)
{
	Real = R ;
	Imag = I ;
}

CxAccMachWord::CxAccMachWord(MachWord R,MachWord I)
{
	Real = R ;
	Imag = I ;
}

MachWord::MachWord(double v)
{
	int warn = 0 ;
	if (v < 0) {
        if (v < MachWord::min_negative) v = MachWord::min_negative,warn=1 ;
    } else {
        if (v > MachWord::max_positive) v = MachWord::max_positive,warn=1 ;
    }
    if (warn) hard_limit_warn();
	value = v;
}

MachWord AccScale(AccMachWord word, int )
{
	float x = word ;
	return x ;
}

CxMachWord AccScale(CxAccMachWord word, int )
{
	return AccScale(word);
}

CxMachWord AccScale(CxAccMachWord word)
{
	float x = MachReal(word);
	float y = MachImag(word);
	return CxMachWord(x,y);
}

MachWord FullScale(double Val, int )
{
	return Val ;
}

CxMachWord FullScale(complex Val)
{
	float x = real(Val) ;
	float y = imag(Val) ;
	return CxMachWord(x,y);
}

CxMachWord FullScale(complex Val, int )
{
	return FullScale(Val);
}

void Normalize(MachWord * , int32 , enum NormalizeOption )
{
}

void Normalize(CxMachWord * , int32 , NormalizeOption )
{
}


CxMachWord RoundDouble(complex Val)
{
	return CxMachWord(RoundDouble(real(Val)),RoundDouble(imag(Val)));
}

MachWord RoundDouble(double Val)
{
	float v = Val ;
	return v ;
}



MachWord FullScale(double Val)
{
	float v = Val ;
	return v ;
}


double NormFromMachWord(double val) {return val ;}

double NormFromAccMachWord(double val) {return val;}

