/*  hrdcmp.c   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
#include <complex.h>
#include <math.h>
#include "portable.h"
#include "newaloc.h"
#include "cgidbg.h"
#include "hrdarth.h"
#include "arthfnc.h"
#include "hrdcmp.h"

#include "artherr.h"
#include "debug.h"
#include <float.h>


AccMachWord operator*(AccMachWord a,AccMachWord b)
{
	return (float) ((float) a * (float) b);
}
/***************
 * #define rel_oper(operation,type) \
 * int type::operator##operation(type tst) const  \
 * { \
 *	 return value operation tst.value ; \
 * }
 * 
 * #define all_rel(type) \
 * rel_oper(<,type) \
 * rel_oper(<=,type) \
 * rel_oper(>,type) \
 * rel_oper(>=,type) \
 * rel_oper(==,type) \
 * rel_oper(!=,type) 
 * 
 * all_rel(MachWord)
 * all_rel(AccMachWord)
 ***********/


MachWord operator*(MachWord a,MachWord b)
{
	return (float) ((float) a * (float) b);
}

int ArithAccCheckOverflow(AccOverflowCheck& Val)
{
	// LogMsg("Enter Check overflow");
	int Return = 0 ;
	if (Val > MachWord::max_positive) {
		Val = MachWord::max_positive ;
		Return = 1;
	} else if (Val < MachWord::min_negative) {
		Val = MachWord::min_negative ;
		Return = 1;
	}
	// LogMsg("Exit Acc Check overflow");
	return Return ;
}

int ArithCheckOverflow(OverflowCheck& Val)
{
	// LogMsg("Enter Check overflow");
	int Return = 0 ;
	if (Val > MachWord::max_positive) {
		Val = MachWord::max_positive ;
		Return = 1;
	} else if (Val < MachWord::min_negative) {
		Val = MachWord::min_negative ;
		Return = 1;
	}
	// LogMsg("Exit Check overflow");
	return Return ;
}

static int32 SaveOverflows = 0;


complex GetComplexFromPtr(AccMachWord * v)
{
#ifdef __NT_VC__
	complex x ;
	x.x = (float) *v ;
	x.y = 0 ;
	return x ;
#else
	return complex((double)*v);
#endif
}

complex GetComplexFromPtr(MachWord * v)
{
#ifdef __NT_VC__
	complex x ;
	x.x = (float) *v;
	x.y = 0 ;
	return x ;
#else
	return complex((double)*v);
#endif
}

complex GetComplexFromPtr(CxMachWord * v)
{
#ifdef __NT_VC__
	complex x ;
	x.x = (double)v->rl.value ;
	x.y = (double)v->ig.value ;
	return x ;
#else
	return complex((double)v->rl.value,(double)v->ig.value);
#endif
}

complex GetComplexFromPtr(CxAccMachWord * v)
{
#ifdef __NT_VC__
	complex x ;
	x.x = (double)v->Real.value ;
	x.y = (double)v->Imag.value ;
	return x ;
#else
	return complex((double)v->Real.value,(double)v->Imag.value);
#endif
}

CxMachWord operator/(const CxMachWord& a,MachWord& b)	
{							
 	complex C = ((complex) a)/((double) b) ;
	return CxMachWord((float)real(C),(float)imag(C));
}							
