/*  typout.c   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
#include "typout.h"
#include <strstream.h>
#ifndef OVERFLOW
#include <complex.h>
#endif
#include <stdio.h>
#include <mkstr.h>

#ifndef TI_C30
const TypeBufSize = 128 ;
static char TypeBuf[TypeBufSize]; 

#define CONVERT_TO_STRING(x)		\
	ostrstream Temp(TypeBuf,TypeBufSize-1);	\
	for (int i = 0 ; i < TypeBufSize;i++) TypeBuf[i] = '\0' ;			\
	Temp <<  x ;			\
	return TypeBuf 				\


const char * TypeToString(MachWord x)
{
	CONVERT_TO_STRING(x) ;
}

const char * TypeToString(AccMachWord x)
{
	CONVERT_TO_STRING(x) ;
}

const char * TypeToString(CxMachWord& x)
{
#ifndef __NT_VC__
	complex z((double) MachReal(x),(double) MachImag(x)) ;
	CONVERT_TO_STRING(z) ;
#else
	char bufx[32] ;
	char bufy[32] ;
	sprintf(bufx,"%e",(double) MachReal(x));
	sprintf(bufy,"%e",(double) MachImag(x));
	return Concatenate("(",bufx,",","bufy",")");
#endif
}

const char * TypeToString(CxAccMachWord& x)
{
#ifndef __NT_VC__
	complex z((double) MachReal(x),(double) MachImag(x)) ;
	CONVERT_TO_STRING(z) ;
#else
	char bufx[32] ;
	char bufy[32] ;
	sprintf(bufx,"%e",(double) MachReal(x));
	sprintf(bufy,"%e",(double) MachImag(x));
	return Concatenate("(",bufx,",","bufy",")");
#endif
}

const char * TypeToString(int16 x)
{
	CONVERT_TO_STRING(x) ;
}

const char * TypeToString(int32 x)
{
	CONVERT_TO_STRING(x) ;
}

const char * TypeToString(double x)
{
	CONVERT_TO_STRING(x) ;
}

const char * TypeToString(class complex& x)
{
#ifndef __NT_VC__
	CONVERT_TO_STRING(x) ;
#else
	char bufx[32] ;
	char bufy[32] ;
	sprintf(bufx,"%e",(double) x.x);
	sprintf(bufy,"%e",(double) x.y);
	return Concatenate("(",bufx,",","bufy",")");
#endif
}

#endif
