/*  dspsig.c   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
#ifdef __NT_VC__
#include <process.h>
#endif
#include <signal.h>
#include <stdlib.h>
#include <unistd.h>
#include "sysintfc.h"
#include "shared.h"
#include "cgidbg.h"
#include "syssig.h"
#include "ques.h"
#include "dsp.h"
#include "dspsig.h"
#include "yacintfc.h"


static void SigTerminate(int)
{
	ExitCleanUp();
	exit(1);
}

static int Sleeping = 0 ;

const TheSleepOfTheDead = 60000 ;

static int ResumeSleep ;

static void DumpState()
{
/*
 *	LogOut << "Sleeping = " << Sleeping << ", ResumeSleep = " <<
 *		ResumeSleep << "\n" ;
 *	LogOut << "IsBusy = " << DspExecState->IsBusy() << "\n" ;
 */
}
// NO IO IN SIGNAL PROCESSING

static void SigQuiet(int)
{
	SetDspSignals();
	// LogOut << "SigQuiet signal\n" ;
	// DumpState();
	if (Sleeping) {
		Sleeping = 0 ;
		return ;
	}
	ResumeSleep = 1 ;
	while (ResumeSleep) {
		ResumeSleep = 0 ;
		Sleeping = 1 ;
		sleep (TheSleepOfTheDead);
	}
}


static void SigAbortExecution(int)
{
	SetDspSignals();
	// LogOut << "SigAbort signal\n" ;
	// DumpState();
	if (DspExecState->IsBusy()) State.Error("user termination");
	if (Sleeping) ResumeSleep= 1;
}

extern void linux_core_dump();

static void SigHandle(int Signal)
{
	if (Signal ==2) {
		TheLog << "Signal 2 caught. Exiting.\n" ;
		ExitOneWayOrAnother();
	}
	TheLog << "Signal " << Signal << " caught, forcing core dump.\n" ;
#ifndef __NT_VC__
#ifdef __linux__
    linux_core_dump();
#else
	kill(getpid(),3);
#endif
	ExitOneWayOrAnother();
#endif
}


void SetDspSignals()
{
	SetCatchSignals(SigHandle,SigTerminate,SigAbortExecution,SigQuiet);
}

