/*
 *  optab.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
/*  optab.h   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
/* This file defines the tables used in decoding operators
 *	on all types of objects
 */

#include "decptr.h"

class ValueType ;

typedef ValueType * (*BinarySemanticRoutine) (ValueType*,ValueType*);

enum OperandType {OperandEnd, OperandBasic, OperandIntEnt,
	OperandIntEntList } ;

struct Operand {
	enum OperandType Type;
	union DeclarationPtr * Op ;
	void Dump();
} ;

struct OperandAndSemant {
	struct Operand Op2 ;
	BinarySemanticRoutine BinOp ; 
	BinarySemanticRoutine CheckOperand(ValueType* Opnd2) ;
	void Dump();
} ;

struct OperandOpt {
	struct Operand Op1 ;		/* type of first operand             */
	struct OperandAndSemant * Op2;	/* table of types for second operand */
					/* and semantic routinew             */
	BinarySemanticRoutine CheckOperands(ValueType*,ValueType*);
	void Dump();
} ;

struct ClassOp {
	int Operator ;			/* Yacc code for the operator       */
	struct OperandOpt * Operands ;	/* Table of allowable first operands*/ 
	void Dump();
} ;

extern struct ClassOp AllClassBinaryOps[] ;
