/*  optabs.c   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
#include "portable.h"
#include "y.tab.h"

#include "optab.h"
#include "opsemant.h"

DeclarationPtr UnTheNodes ;
DeclarationPtr UnTheCmpdNodes ;
DeclarationPtr UnTheDisplays ;
DeclarationPtr UnTheSignals ;
DeclarationPtr UnTheNets ;

static struct OperandAndSemant ShiftRightNodes[] = {
	{{OperandIntEntList,&UnTheNodes},ConnectNodes},
	{{OperandEnd}}
};

static struct OperandAndSemant ShiftRightDisplays[] = {
	{{OperandIntEntList,&UnTheDisplays},ConnectNodes},
	{{OperandEnd}}
};

static struct OperandAndSemant PlusSignals[] = {
	{{OperandIntEntList,&UnTheSignals},ConnectSignalSource},
	{{OperandEnd}}
};

static struct OperandOpt ShiftRightOperands[] =
{
	{{OperandIntEntList,&UnTheNets}, ShiftRightNodes},
	{{OperandIntEntList,&UnTheNets}, ShiftRightDisplays},
	{{OperandEnd}}
};

static struct OperandOpt PlusOperands[] =
{
	{{OperandIntEntList,&UnTheNets}, PlusSignals},
	{{OperandEnd}}
};

struct ClassOp AllClassBinaryOps[] =  
{
	{SHIFT_R, ShiftRightOperands},
	{'+', PlusOperands},
	{0}
};

