/*  tarbuf.C   */
/*  Copyright 1991 Mountain Math Software  */
/*  All Rights Reserved                    */
#include "netlnk.h"

void TargetNode::WriteCxWord (CxMachWord Data, int OutChannel)
{
	if (!CkOut(OutChannel,"WriteCxWord") ) return;
	OutLinks[OutChannel].WriteCxWord(Data) ;
}

CxMachWord TargetNode::ReadCxWord ( int InChannel)
{
	if (!CkIn(InChannel,"WriteCxWord")) return 0;
	return InLinks[InChannel].ReadCxWord() ;
}

int TargetNode::GetContiguousSpace (int OutChannel) const
{
	if (!CkOut(OutChannel,"GetContiguousSpace")) return 0;
	return OutLinks[OutChannel].GetContiguousSpace() ;
}

int TargetNode::GetSpace (int OutChannel) const
{
	if (!CkOut(OutChannel,"GetSpace")) return 0;
	return OutLinks[OutChannel].GetSpace() ;
}

void TargetNode::WriteBinary (BinMachWord Data, int OutChannel)
{
	if (!CkOut(OutChannel,"WriteBinary")) return;
	OutLinks[OutChannel].WriteBinary(Data) ;
}

void TargetNode::WriteWord (MachWord Data, int OutChannel)
{
	if (!CkOut(OutChannel,"WriteWord")) return;
	OutLinks[OutChannel].WriteWord(Data) ;
}

int TargetNode::GetContiguousAvailableData ( int InChannel) const
{
	if (!CkIn(InChannel,"GetContiguousAvailableData")) return 0;
	return InLinks[InChannel].GetContiguousAvailableData() ;
}

int TargetNode::GetAvailableData ( int InChannel) const
{
	if (!CkIn(InChannel,"GetAvailableData")) return 0;
	return InLinks[InChannel].GetAvailableData() ;
}

BinMachWord TargetNode::ReadBinary ( int InChannel)
{
	if (!CkIn(InChannel,"ReadBinary")) return (int16) 0;
	return InLinks[InChannel].ReadBinary() ;
}

MachWord TargetNode::ReadWord ( int InChannel)
{
	if (!CkIn(InChannel,"ReadWord")) return (int16) 0;
	return InLinks[InChannel].ReadWord() ;
}

void TargetNode::UpdateRead(int32 Size, int chan)
					// Add Size words to read pointer
{
	if(!CkIn(chan,"UpdateRead")) return ;
	InLinks[chan].UpdateRead(Size) ;
}

void TargetNode::UpdateWrite(int32 Size, int chan)
					// Add Size words to write pointer
{
	if(!CkOut(chan,"UpdateWrite")) return;
	OutLinks[chan].UpdateWrite(Size) ;
}

const MachWord * TargetNode::GetReadPtr(int chan) const
{
	if (!CkIn(chan,"GetReadPtr")) return 0;
	return InLinks[chan].GetReadPtr() ;
}

MachWord * TargetNode::GetWritePtr(int chan)  const
{
	if(!CkOut(chan,"GetWritePtr")) return 0;
	return OutLinks[chan].GetWritePtr() ;
}

const MachWord * TargetNode::GetReadBase(int chan) const
{
	if(!CkIn(chan,"GetReadBase")) return 0;
	return InLinks[chan].GetReadBase() ;
}

const MachWord * TargetNode::GetReadEnd(int chan) const
{
	if(!CkIn(chan,"GetReadEnd")) return 0;
	return InLinks[chan].GetReadEnd() ;
}

MachWord * TargetNode::GetWriteBase(int chan) const
{
	if(!CkOut(chan,"GetWriteBase")) return 0;
	return OutLinks[chan].GetWriteBase() ;
}

MachWord * TargetNode::GetWriteEnd(int chan) const
{
	if(!CkOut(chan,"GetWriteEnd")) return 0;
	return OutLinks[chan].GetWriteEnd() ;
}

