/*  tarnodpar.C   */
/*  Copyright 1991 Mountain Math Software  */
/*  All Rights Reserved                    */
#include "adjust.h"
#include "cgidbg.h"
#include "tarnodpar.h"
#include "outtok.h"
#include "tarparm.h"
#include "travparm.h"
#include "bufstat.h"

TargetAdjustState TargetNodeParameters::DoAdjust(
	Adjustment& TheAdjustment)
{
/*
 *	LogOut << "TargetNodeParameters::DoAdjust  Command = " <<
 *		TheAdjustment.GetCommand() << "\n" ;
 */
	TargetAdjustState Return = TargetAdjustOK ;
	switch (TheAdjustment.GetCommand()) {
case Adjustment::EnlargeSequence:
		Return = EnlargeSequence(TheAdjustment) ;
		break ;
case Adjustment::EnlargeMultiplier:
		Return = GetExecute().SetSequenceLengthMultiplier(
			TheAdjustment.GetEnlargeBase()) ;
		break ;
case Adjustment::SetFlushSize:
		if (TheAdjustment.GetTraverseObject().GetBufferStatus()->
			GetExecutionSequenceIndex())
		Return = GetExecute().SetFlushCount(TheAdjustment) ;
		else Return = GetInit().SetFlushCount(TheAdjustment) ;
		break ;
case Adjustment::EnlargeBuffer:
		DbgError("TargetNodeParameters::DoAdjust",
			"enlarge buffer not in");
default:
		DbgError("TargetNodeParameters::DoAdjust","bad case");
	}
/*
 *	LogOut << "TargetNodeParameters::DoAdjust returning " <<Return
 *		<< "\n" ;
 */
	return Return ;
}

TargetAdjustState TargetNodeParameters::EnlargeSequence(
	Adjustment& TheAdjustment)
{
	switch (TheAdjustment.GetSequenceIndex()) {
case 0:
		return GetInit().EnlargeSequence(TheAdjustment);
case 1:
		return GetExecute().EnlargeSequence(TheAdjustment);
default:
		DbgError("TargetAdjustParameters::EnlargeSequence","bad case");
	}
	return TargetAdjustFail ;
}

TargetNodeParameters::TargetNodeParameters(DfNode& parent,BufferStatus& status):
	Parent(parent),
	InitExecuteSequence(*this,status.GetInitSequenceLengthRef()),
	ExecuteSequence(*this,status.GetExecuteSequenceLengthRef()),
	NeededExecutionCount(1)
{
	// LogOut << "TargetNodeParameters ctor\n" ;
/*
 *	LogOut << "	for `" << parent.GetName()
 *		<< "\n" ;
 *	LogOut << InitExecuteSequence.GetNode().GetName() << "\n" ;
 *	LogOut << ExecuteSequence.GetNode().GetName() << "\n" ;
 */
}


void TargetNodeParameters::EmitSequences(TraverseObject& obj)
{
	// LogOut << "TargetNodeParameters::EmitSequences\n" ;
	if (!InitExecuteSequence.GetSize() && !ExecuteSequence.GetSize())
		return ;
	// LogOut << "TargetNodeParameters::EmitSequences begin\n" ;
	OutTokens& Out = obj.GetOut();
	Out.NewLine();
	const char * InitSuffix = "Init" ;
	const char * ExecSuffix = "Exec" ;
	InitExecuteSequence.Emit(InitSuffix,obj);
	ExecuteSequence.Emit(ExecSuffix,obj);
	Out.NewLine() ;
	Out.NextOut("int *");
	Out.NextConcatToken(GetNode().GetName());
	Out.NextConcatToken(ExecutionSequenceSuffix) ;
	Out.NextOutToken("[2]") ;
	Out.NextOut("= {");
	Out.NewLine();
	if (InitExecuteSequence.GetSize()) {
		Out.NextConcatToken("\t");
		Out.NextConcatToken(GetNode().GetName());
		Out.NextConcatToken(ExecutionSequenceSuffix) ;
		Out.NextConcatToken(InitSuffix);
		Out.NextOutToken(",");
	} else Out.NextOut("\t0,") ;
	Out.NewLine();
	if (ExecuteSequence.GetSize()) {
		Out.NextConcatToken("\t");
		Out.NextConcatToken(GetNode().GetName());
		Out.NextConcatToken(ExecutionSequenceSuffix) ;
		Out.NextOutToken(ExecSuffix);
	} else Out.NextOut("\t0") ;
	Out.NewLine();
	Out.NextOut("};");
	Out.NewLine();
	// LogOut << "TargetNodeParameters::EmitSequences exit\n" ;
}

void TargetNodeParameters::ClearSequences()
{
	// LogOut << "TargetNodeParameters::ClearSequences\n" ;
	InitExecuteSequence.Clear() ;
	ExecuteSequence.Clear();
}

void TargetNodeParameters::dump(const char * node)
{
	// LogOut << "Node `" << node << "', InitSequence:\n" ;
	InitExecuteSequence.dump();
	// LogOut << "ExecuteSequence:\n" ;
    ExecuteSequence.dump();

}
