/*
 *  thread.h from ObjectProDSP 0.2
 *  Copyright (C) 1994 1995, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
/*  thread.h   */
/*  Copyright 1989 Mountain Math Software  */
/*  All Rights Reserved                    */
#include "errcode.h"

#ifndef THREAD_DOT_H
#define THREAD_DOT_H
class Thread {
	DfNode * FirstNode ;
	TimingDescription * Timing ;
public:
	Thread(DfNode * TheNode, TimingDescription * timing = 0) ;
	virtual ~Thread() ;
	DfNode * GetFirstNode() { return FirstNode;}
	void Display() {GetFirstNode()->Display();}
	void NameDisplay() {GetFirstNode()->NameDisplay();}
	int CheckComplete() {return GetFirstNode()->CheckComplete();}
	virtual void Describe(OutTokens& Out, ListEntity Option) 
		{GetFirstNode()->Describe(Out,Option);}
	const char * GetName() {return GetFirstNode()->GetName();}
	int AssignTiming(int cannot_reset ) ;
	void ClearTiming();
	int DoInitAfterLinked() {return GetFirstNode()->DoInitAfterLinked();}
} ;

class ThreadList: public SingleList {
public:
	ErrCode Insert(Thread *nt) {return SingleList::Insert(nt);}
	ErrCode Append(Thread *nt) {return SingleList::Append(nt);}
	ErrCode Append(DfNode *node)
		{return SingleList::Append(new Thread(node)) ;}
	Thread * Get()   {return (Thread *) SingleList::Get();}
	Thread * Pop() {return (Thread *) SingleList::Pop();}
	Thread * GetNFromTop(int N) ;
	Thread * GetNthEntry(int N) ;
	Thread * GetFirst() {return (Thread *) SingleList::GetFirst();}
	ThreadList(){;}
	int Size(){return SingleList::Size();}
	void Display();
	void NameDisplay();
	int CheckComplete(const char * name) ;
	virtual void Describe(OutTokens& Out, ListEntity Option) ;
	const char * GetName() {return GetFirst()->GetName();}
	ErrCode Remove(Thread * t) {return SingleList::RemoveEntry((Entity)t);}
	ErrCode Remove(DfNode * node) ;
	int DoInitAfterLinked(const char *name);
} ;

class ThreadListIterator: public SingleListIterator {
public:
	ThreadListIterator(ThreadList& df):
		SingleListIterator((SingleList&) df){}
	Thread * operator()()
		{return (Thread *) Next();}
};


#endif /* #ifdef THREAD_DOT_H */
