/*
 *  yacintfc.C from ObjectProDSP
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "cgidbg.h"
#include "yacintfc.h"
#include "usercom.h"

CommandState State ;

int CommandState::warn_def = 20 ;

CommandState::CommandState ():Exiting(0),PreviousErrorFlag(0),
	SemanticErrorFlag(0),the_log_file(0),warn_count(0),max_warn(warn_def)
{
}

void CommandState::end_node_exec()
{
	if (max_warn > -1) if (warn_count > max_warn)  HelpOut <<
		"There were " << warn_count - max_warn << " additional warnings.\n" 
		<< "Use the `-w' command line option to set the number displayed.\n" ;
	warn_count = 0 ;
}

void CommandState::Warning(const char * a, const char * b,
	const char * c, const char *  d, const char * e, const char * f,
	const char * g, const char * h)
{
	warn_count++ ;
	if (max_warn > -1) if (warn_count > max_warn) return ;
	// *Output + OutputHelp << "Warning: " << a;
	HelpOut << "Warning: " << a;
	if (b) *Output << b ;
	if (c) *Output << c ;
	if (d) *Output << d ;
	if (e) *Output << e ;
	if (f) *Output << f ;
	if (g) *Output << g ;
	if (h) *Output << h ;
	*Output << ".\n" ;
}

void CommandState::Error(const char * a, const char * b ,
	const char * c, const char *  d, const char * e, const char * f,
	const char * g, const char * h)
{
	SetError();
	HelpOut << "Error: " << a;
	if (b) *Output << b ;
	if (c) *Output << c ;
	if (d) *Output << d ;
	if (e) *Output << e ;
	if (f) *Output << f ;
	if (g) *Output << g ;
	if (h) *Output << h ;
	*Output << ".\n" ;
/*
 *	if (&LogOut != Output) {
 *		LogOut << "Error: " << a;
 *		if (b) LogOut << b ;
 *		if (c) LogOut << c ;
 *		if (d) LogOut << d ;
 *		if (e) LogOut << e ;
 *		if (f) LogOut << f ;
 *		if (g) LogOut << g ;
 *		if (h) LogOut << h ;
 *		LogOut << ".\n" ;
 *	}
 */
}

