#include <fstream.h>
#include <fcntl.h>
#include "ObjProComGui/cgidbg.h"
#include "ObjProDSP/sysconst.h"
#include "ObjProGui/yacintfc.h"
#include "ObjProGui/remcom.h"
#include "ObjProShare/shared.h"
#include "ObjProGui/dyntextd.h"
#include "ObjProNet/dfnode.h"

#include "ObjProUsr/compare.h"
#include "ObjProGen/outtok.h"
#include "ObjProGui/intfc.h"
#include "ObjProGui/remmen.h"
#include "ObjProGui/user.h"
#include "ObjProGui/dynmnu.h"
#include "ObjProArith/typout.h"
#include "ObjProGui/array.h"
#include "ObjProGui/interinit.h"
#include "ObjProGen/stattyp.h"
#include "ObjProDSPcom/infile.h"
#include "ObjProDSPcom/tarnod.h"
#include "ObjProDSPint/netlnk.h"
static EntityList * CompareDiskNodeList = 0 ;
static InteractiveEntity * IntEntCompareDisk ;
void CompareDiskNodesInit();
CompareDisk::CompareDisk (const char * Name, const char * FileName, int32 MaxReport, 
		double Tolerance, const char * ErrorFile):
	DisplayNodeStr(Name, 
	(TempInputFile =  new InputFile(this , FileName , Name)) -> GetChannels(), 1,  new StreamStr(StreamNotInitialized), TimingTypeLinear)
,
	FileName_1(FileName),
	MaxReport_2(MaxReport),
	Tolerance_3(Tolerance),
	ErrorFile_4(ErrorFile)
{
	if (!CompareDiskNodeList) CompareDiskNodesInit() ;
	CompareDiskNodeList->Append(MakeDeclaredEntity(this, IntEntCompareDisk)) ;
	InitArithType(TheArithType);
	NewMenuItem("CompareDisk",GetName());
#line 154 "../compare.usr"
 
	ctor();
#line 45 "../compare.cxx"
} // end constructor

ErrCode CompareDisk::EmitStaticCtorParameters(OutTokens& Out)
{
	ostream& Outs = *(Out.GetStream());
	Outs << ",\n\tCompareDiskStaticInitbinary_read_flag_" << GetName() << "";
	return OK;
}

ErrCode CompareDisk::EmitStaticInit(OutTokens& Out)
{
	ostream& Outs = *(Out.GetStream());
	Outs << "static int CompareDiskStaticInitbinary_read_flag_" << GetName() << " = ";	
	OutStringStaticValue(Outs,"int", &(binary_read_flag)) ;

	Outs << ";\n";
	return OK;
}

CompareDisk::~CompareDisk()
{
	TheMenuServer->DeleteMenuItem("CompareDisk",GetName());
	CompareDiskNodeList->Delete(GetName()) ;
#line 158 "../compare.usr"
 
	dtor();
#line 72 "../compare.cxx"
} // end destructor

int CompareDisk::CheckSafeDelete()
{
	int Safe_Check_Return = DfNode::CheckSafeDelete();
	if (!Safe_Check_Return) return 0;
	return 1;
} // end check safe delete

CompareDisk * CompareDiskDef;

ErrCode CompareDisk::DoNode(int32 k)
{
#line 180 "../compare.usr"
 
	return kernel(k);
#line 89 "../compare.cxx"
} // end kernel code

static UserEntity * MakeCompareDisk(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith = (ArithType::ArithCapabilities) TheArithType) ;
int CompareDisk::CppList(OutTokens& Out, CppListCmds Cmd)
{
	return IntEntCompareDisk->CppList(Out,Cmd,this);
}

void CompareDisk::Describe(OutTokens& Out, ListEntity Option)
{
	switch(Option) {
case ListSingleEntity:
		Out.NewLine();
		MakeCompareDisk(Out,EntityReqDescribeFull,*IntEntCompareDisk, (ArithType::ArithCapabilities) TheArithType);
		Out.NewLine();
		Out.NextQuoteOut("FileName");
		Out.NextQuoteOut(GetFileName());
		Out.NextFillOut("specifies the name of the disk file");
		Out.NextFillOut("to be compared with the data read from the input");
		Out.NextFillOut("channels.");
		Out.NextFillOut("Only the first");
		Out.NextQuoteOut("MaxReport");
		Out.NextFillOut("(");
		Out.NextFillOut(TypeToString(GetMaxReport()));
		Out.NextFillOut(")");
		Out.NextFillOut("errors will be reported.");
		Out.NextQuoteOut("Tolerance");
		Out.NextFillOut("(");
		Out.NextFillOut(TypeToString(GetTolerance()));
		Out.NextFillOut(")");
		Out.NextFillOut("is the absolute value of the smallest difference");
		Out.NextFillOut("that constitutes an error. Ordinarily this value is 0.0.");
		Out.NextFillOut("It might be set to a value larger than 0 to compare");
		Out.NextFillOut("slightly different algorithms");
		Out.NextFillOut("or results on two different computers with different");
		Out.NextFillOut("arithmetic.");
		Out.NextQuoteOut("ErrorFile");
		Out.NextQuoteOut(GetErrorFile());
		Out.NextFillOut("is a file in which errors will be reported instead");
		Out.NextFillOut("of displaying them in a window.");
		Out.NewLine();
		break;
case ListEntityMembers:
		Out.NextOut(GetName());
		break;
case ListGlobalClasses:
case ListEntityClasses:
		break ;
case ListSetParameterValues:
		IntEntCompareDisk->GetOneParameter("FileName")->
			StringP->CurrentValue = FileName_1;
		IntEntCompareDisk->GetOneParameter("MaxReport")->
			IntP->CurrentValue = MaxReport_2;
		IntEntCompareDisk->GetOneParameter("Tolerance")->
			FloatP->CurrentValue = Tolerance_3;
		IntEntCompareDisk->GetOneParameter("ErrorFile")->
			StringP->CurrentValue = ErrorFile_4;
		break;
	}
} // end  list entity switch

static ValueType * DisplayHeader(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextQuoteOut("DisplayHeader");
		Out.NextFillOut("displays the parameters read from file");
		Out.NextQuoteOut("FileName");
		Out.NextFillOutConcat(".");
		Out.NextFillOut("These include the original node name that generated the file,");
		Out.NextFillOut("the caption for this node, the number of input channels,");
		Out.NextFillOut("and the number of scalar elements in a sample. The arithmetic");
		Out.NextFillOut("type is also shown. The output channels and");
		Out.NextFillOut("sample size for this node are determined by these values. If the");
		Out.NextFillOut("data in the file is in a different arithmetic format");
		Out.NextFillOut("than that currently in use, the file data will be converted.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{
		((CompareDisk * )This)->DisplayHeader(
		);		}
	}
	return 0;
}

static ValueType * IgnoreHeaderCount(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextFillOut("The data file header contains a count of the number of");
		Out.NextFillOut("machine words in each channel. This count is written at");
		Out.NextFillOut("the time the node creating the file is deleted. If ObjectProDSP");
		Out.NextFillOut("exits abnormally then these counts may never be set");
		Out.NextFillOut("and one will not be able to read any of the data in the");
		Out.NextFillOut("file. This option causes these counts to be ignored.");
		Out.NextFillOut("The result is that data will be read until the physical");
		Out.NextFillOut("end of file. This may result in samples of all 0 being");
		Out.NextFillOut("read at the end of the file that were never written to it.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{
		((CompareDisk * )This)->IgnoreHeaderCount(
		);		}
	}
	return 0;
}

void CompareDiskNodesInit()
{
	if (CompareDiskNodeList)  return ;

	static StringParam CompareDiskNameParam =
		{"CompareDisk", MakeNewEntityName, 0, LegalEntityName};
	static StringParam CompareDiskFileNameParam = {
		 0, 0, 0};
	static IntParam CompareDiskMaxReportParam = {
		 1000, 0,  0,  1, 0, 2.14748e+09};
	static FloatParam CompareDiskToleranceParam = {
		 0.0, 0,  0,  0.0, 0, 1e+100};
	static StringParam CompareDiskErrorFileParam = {
		 0, 0, 0};

	static OneParameter CompareDiskParArray[] = {
		{"Name", 0, "node name", 0, 0, &CompareDiskNameParam},
		{"FileName", 0, 
			"name of disk file to read",
			0, 0, &CompareDiskFileNameParam},
		{"MaxReport", 0, 
			"maximum number of errors to report",
			&CompareDiskMaxReportParam, 0, 0, 0, 0, 1},
		{"Tolerance", 0, 
			"absolute value of minimum difference for an error",
			0, &CompareDiskToleranceParam, 0, 0, 0, 1},
		{"ErrorFile", 0, 
			"if set errors will be written to this file",
			0, 0, &CompareDiskErrorFileParam, 0, 0, 1},
		{0}
	};

	static OneParameter DisplayHeaderCompareDiskList[] = {
		{0}
	};
	UserParameters * DisplayHeaderMemberParam = new UserParameters
		(DisplayHeaderCompareDiskList);

	Procedure * MemberProcDisplayHeader = new Procedure("DisplayHeader", DisplayHeader,
		DisplayHeaderMemberParam, "void", 0, "display the caption and parameters read from the disk");
	static OneParameter IgnoreHeaderCountCompareDiskList[] = {
		{0}
	};
	UserParameters * IgnoreHeaderCountMemberParam = new UserParameters
		(IgnoreHeaderCountCompareDiskList);

	Procedure * MemberProcIgnoreHeaderCount = new Procedure("IgnoreHeaderCount", IgnoreHeaderCount,
		IgnoreHeaderCountMemberParam, "void", 0, "ignore the word counts in the data file header");
static ValueType * CompareDiskMembers[3] ;
	int ii = 0 ;
	CompareDiskMembers[ii++] = new ValueType(DecProcedure, MemberProcDisplayHeader) ;
	CompareDiskMembers[ii++] = new ValueType(DecProcedure, MemberProcIgnoreHeaderCount) ;
	CompareDiskMembers[ii++] = 0 ;
	CompareDiskNodeList = new EntityList;
	IntEntCompareDisk = new InteractiveEntity("CompareDisk", CompareDiskNodeList,
		MakeCompareDisk, InteractiveDisplay, "compare.h",
		CompareDiskMembers, "DisplayNodeStr");
	IntEntCompareDisk->SetParameters(new UserParameters(CompareDiskParArray));
	TheNodes->Append(IntEntCompareDisk);
} // end initalization

static UserEntity * MakeCompareDisk(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith)
{
	switch(Request) {
case EntityReqDescribe:

case EntityReqDescribeFull:
		Out.NextQuoteOut("CompareDisk");
		Out.NextFillOut("compares the contents of disk file");
		Out.NextQuoteOut("FileName");
		Out.NextFillOut("with data from its input channels. All discrepancies");
		Out.NextFillOut("are reported in a text window.");
		Out.NextQuoteOut("CompareDisk");
		Out.NextFillOutConcat("'s primary purpose");
		Out.NextFillOut("is for regression testing.");
		Out.NextFillOut("The number of channels and the number of multiplexed elements");
		Out.NextFillOut("in a sample are read from the header of the disk file.");
		Out.NextFillOut("Member function");
		Out.NextQuoteOut("DisplayHeader");
		Out.NextFillOut("will give the values of all the");
		Out.NextFillOut("information read from the disk file header.");
		Out.NewLine();
		break;

case EntityReqCreate:
	{
		const char * Name = IntNode.GetStringParameterValue("Name");
		const char * FileName =
			IntNode.GetStringParameterValue("FileName");
		int32 MaxReport =
			IntNode.GetIntParameterValue("MaxReport");
		double Tolerance =
			IntNode.GetFloatParameterValue("Tolerance");
		const char * ErrorFile =
			IntNode.GetStringParameterValue("ErrorFile");
		return new CompareDisk(Name, FileName, MaxReport, Tolerance, ErrorFile);

	}
	}
	return 0;
}

static InitObj LocalInit(CompareDiskNodesInit, "CompareDisk", "DisplayNodeStr");

